/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file genomic_collections_cli_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GENOMIC_COLLECTIONS_CLI_BASE_HPP
#define OBJECTS_GENOMECOLL_GENOMIC_COLLECTIONS_CLI_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>
#include <objects/genomecoll/GCClientRequest.hpp>
#include <objects/genomecoll/GCClientResponse.hpp>
#include <serial/rpcbase.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGenomicCollectionsService_Base : public CRPCClient<CGCClientRequest, CGCClientResponse>
{
    typedef CRPCClient<CGCClientRequest, CGCClientResponse> Tparent;
public:
    // constructor
    CGenomicCollectionsService_Base(void);
    // destructor
    virtual ~CGenomicCollectionsService_Base(void);

    typedef CGCClientRequest TRequest;
    typedef CGCClientResponse TReply;
    typedef TRequest TRequestChoice;
    typedef TReply TReplyChoice;

    virtual void Ask(const TRequest& request, TReply& reply);
    virtual void Ask(const TRequest& request, TReply& reply,
                     TReplyChoice::E_Choice wanted);

    virtual string AskGet_chrtype_valid
        (const CGCClient_ValidateChrTypeLocRequest& req, TReply* reply = 0);

    virtual CRef<CGCClient_EquivalentAssemblies> AskGet_equivalent_assemblies
        (const CGCClient_GetEquivalentAssembliesRequest& req, TReply* reply = 0);

    virtual vector< char > AskGet_assembly_blob
        (const CGCClient_GetAssemblyBlobRequest& req, TReply* reply = 0);

    virtual CRef<CGCClient_AssembliesForSequences> AskGet_assembly_by_sequence
        (const CGCClient_GetAssemblyBySequenceRequest& req, TReply* reply = 0);


private:
    TReplyChoice& x_Choice(TReply& reply);
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CGenomicCollectionsService_Base::TReplyChoice& CGenomicCollectionsService_Base::x_Choice(CGenomicCollectionsService_Base::TReply& reply)
{
    return reply;
}

inline
void CGenomicCollectionsService_Base::Ask(const CGenomicCollectionsService_Base::TRequest& request, CGenomicCollectionsService_Base::TReply& reply)
{
    Tparent::Ask(request, reply);
}


///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GENOMIC_COLLECTIONS_CLI_BASE_HPP
