/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GCClient_GetEquivalentAsse_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gencoll_client.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GCCLIENT_GETEQUIVALENTASSE_BASE_HPP
#define OBJECTS_GENOMECOLL_GCCLIENT_GETEQUIVALENTASSE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CGCClient_GetEquivalentAssembliesRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGCClient_GetEquivalentAssembliesRequest_Base(void);
    // destructor
    virtual ~CGCClient_GetEquivalentAssembliesRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EEquivalency {
        eEquivalency_paired_strict              = 1,  ///< Paired assembly, if identical
        eEquivalency_paired                     = 2,  ///< Paired assembly, if exists, even if not identical
        eEquivalency_same_coordinates           = 3,  ///< All assemblies with same major release and same type (Gb/Rs)
        eEquivalency_all_types_same_coordinates = 4,  ///< All assemblies with same major release, both Gb and Rs.
        eEquivalency_major_release              = 5  ///< Major release of assembly, same type
    };
    
    /// Access to EEquivalency's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EEquivalency)(void);
    
    // types
    typedef string TAccession;
    typedef int TEquivalency;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_accession,
        e_equivalency
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TAccession
    ///  Check whether the Accession data member has been assigned a value.
    bool IsSetAccession(void) const;
    /// Check whether it is safe or not to call GetAccession method.
    bool CanGetAccession(void) const;
    void ResetAccession(void);
    const TAccession& GetAccession(void) const;
    void SetAccession(const TAccession& value);
    void SetAccession(TAccession&& value);
    TAccession& SetAccession(void);

    /// mandatory
    /// typedef int TEquivalency
    ///  Check whether the Equivalency data member has been assigned a value.
    bool IsSetEquivalency(void) const;
    /// Check whether it is safe or not to call GetEquivalency method.
    bool CanGetEquivalency(void) const;
    void ResetEquivalency(void);
    TEquivalency GetEquivalency(void) const;
    void SetEquivalency(TEquivalency value);
    TEquivalency& SetEquivalency(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGCClient_GetEquivalentAssembliesRequest_Base(const CGCClient_GetEquivalentAssembliesRequest_Base&);
    CGCClient_GetEquivalentAssembliesRequest_Base& operator=(const CGCClient_GetEquivalentAssembliesRequest_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Accession;
    int m_Equivalency;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGCClient_GetEquivalentAssembliesRequest_Base::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGCClient_GetEquivalentAssembliesRequest_Base::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CGCClient_GetEquivalentAssembliesRequest_Base::TAccession& CGCClient_GetEquivalentAssembliesRequest_Base::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(0);
    }
    return m_Accession;
}

inline
void CGCClient_GetEquivalentAssembliesRequest_Base::SetAccession(const CGCClient_GetEquivalentAssembliesRequest_Base::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0x3;
}

inline
void CGCClient_GetEquivalentAssembliesRequest_Base::SetAccession(CGCClient_GetEquivalentAssembliesRequest_Base::TAccession&& value)
{
    m_Accession = std::forward<CGCClient_GetEquivalentAssembliesRequest_Base::TAccession>(value);
    m_set_State[0] |= 0x3;
}

inline
CGCClient_GetEquivalentAssembliesRequest_Base::TAccession& CGCClient_GetEquivalentAssembliesRequest_Base::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Accession;
}

inline
bool CGCClient_GetEquivalentAssembliesRequest_Base::IsSetEquivalency(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGCClient_GetEquivalentAssembliesRequest_Base::CanGetEquivalency(void) const
{
    return IsSetEquivalency();
}

inline
void CGCClient_GetEquivalentAssembliesRequest_Base::ResetEquivalency(void)
{
    m_Equivalency = (EEquivalency)(0);
    m_set_State[0] &= ~0xc;
}

inline
CGCClient_GetEquivalentAssembliesRequest_Base::TEquivalency CGCClient_GetEquivalentAssembliesRequest_Base::GetEquivalency(void) const
{
    if (!CanGetEquivalency()) {
        ThrowUnassigned(1);
    }
    return m_Equivalency;
}

inline
void CGCClient_GetEquivalentAssembliesRequest_Base::SetEquivalency(CGCClient_GetEquivalentAssembliesRequest_Base::TEquivalency value)
{
    m_Equivalency = value;
    m_set_State[0] |= 0xc;
}

inline
CGCClient_GetEquivalentAssembliesRequest_Base::TEquivalency& CGCClient_GetEquivalentAssembliesRequest_Base::SetEquivalency(void)
{
#ifdef _DEBUG
    if (!IsSetEquivalency()) {
        memset(&m_Equivalency,UnassignedByte(),sizeof(m_Equivalency));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Equivalency;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GCCLIENT_GETEQUIVALENTASSE_BASE_HPP
