/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_reply_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_REPLY_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_REPLY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/entrez2/Entrez2_dt.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CE2Reply;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///**********************************************************
/// Replies from the Entrez server
///  all replies contain the date/time stamp when they were executed
///  to do reqular date bounded searches use this value+1 to search
///  again later instead of recording the date/time on the client machine
///  the cookie allows a simple key string to represent UID lists in the history
///**********************************************************
class NCBI_ENTREZ2_EXPORT CEntrez2_reply_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_reply_Base(void);
    // destructor
    virtual ~CEntrez2_reply_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CE2Reply TReply;
    typedef CEntrez2_dt TDt;
    typedef string TServer;
    typedef string TMsg;
    typedef string TKey;
    typedef string TCookie;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_reply,
        e_dt,
        e_server,
        e_msg,
        e_key,
        e_cookie
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// the actual reply
    /// mandatory
    /// typedef CE2Reply TReply
    ///  Check whether the Reply data member has been assigned a value.
    bool IsSetReply(void) const;
    /// Check whether it is safe or not to call GetReply method.
    bool CanGetReply(void) const;
    void ResetReply(void);
    const TReply& GetReply(void) const;
    void SetReply(TReply& value);
    TReply& SetReply(void);

    /// date/time stamp from server
    /// mandatory
    /// typedef CEntrez2_dt TDt
    ///  Check whether the Dt data member has been assigned a value.
    bool IsSetDt(void) const;
    /// Check whether it is safe or not to call GetDt method.
    bool CanGetDt(void) const;
    void ResetDt(void);
    const TDt& GetDt(void) const;
    void SetDt(const TDt& value);
    TDt& SetDt(void);

    /// server version info
    /// mandatory
    /// typedef string TServer
    ///  Check whether the Server data member has been assigned a value.
    bool IsSetServer(void) const;
    /// Check whether it is safe or not to call GetServer method.
    bool CanGetServer(void) const;
    void ResetServer(void);
    const TServer& GetServer(void) const;
    void SetServer(const TServer& value);
    void SetServer(TServer&& value);
    TServer& SetServer(void);

    /// possibly a message to the user
    /// optional
    /// typedef string TMsg
    ///  Check whether the Msg data member has been assigned a value.
    bool IsSetMsg(void) const;
    /// Check whether it is safe or not to call GetMsg method.
    bool CanGetMsg(void) const;
    void ResetMsg(void);
    const TMsg& GetMsg(void) const;
    void SetMsg(const TMsg& value);
    void SetMsg(TMsg&& value);
    TMsg& SetMsg(void);

    /// history key for query
    /// optional
    /// typedef string TKey
    ///  Check whether the Key data member has been assigned a value.
    bool IsSetKey(void) const;
    /// Check whether it is safe or not to call GetKey method.
    bool CanGetKey(void) const;
    void ResetKey(void);
    const TKey& GetKey(void) const;
    void SetKey(const TKey& value);
    void SetKey(TKey&& value);
    TKey& SetKey(void);

    /// history session cookie
    /// optional
    /// typedef string TCookie
    ///  Check whether the Cookie data member has been assigned a value.
    bool IsSetCookie(void) const;
    /// Check whether it is safe or not to call GetCookie method.
    bool CanGetCookie(void) const;
    void ResetCookie(void);
    const TCookie& GetCookie(void) const;
    void SetCookie(const TCookie& value);
    void SetCookie(TCookie&& value);
    TCookie& SetCookie(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_reply_Base(const CEntrez2_reply_Base&);
    CEntrez2_reply_Base& operator=(const CEntrez2_reply_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TReply > m_Reply;
    CEntrez2_dt m_Dt;
    string m_Server;
    string m_Msg;
    string m_Key;
    string m_Cookie;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_reply_Base::IsSetReply(void) const
{
    return m_Reply.NotEmpty();
}

inline
bool CEntrez2_reply_Base::CanGetReply(void) const
{
    return true;
}

inline
const CEntrez2_reply_Base::TReply& CEntrez2_reply_Base::GetReply(void) const
{
    if ( !m_Reply ) {
        const_cast<CEntrez2_reply_Base*>(this)->ResetReply();
    }
    return (*m_Reply);
}

inline
CEntrez2_reply_Base::TReply& CEntrez2_reply_Base::SetReply(void)
{
    if ( !m_Reply ) {
        ResetReply();
    }
    return (*m_Reply);
}

inline
bool CEntrez2_reply_Base::IsSetDt(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_reply_Base::CanGetDt(void) const
{
    return IsSetDt();
}

inline
void CEntrez2_reply_Base::ResetDt(void)
{
    m_Dt = CEntrez2_dt(0);
    m_set_State[0] &= ~0xc;
}

inline
const CEntrez2_reply_Base::TDt& CEntrez2_reply_Base::GetDt(void) const
{
    if (!CanGetDt()) {
        ThrowUnassigned(1);
    }
    return m_Dt;
}

inline
void CEntrez2_reply_Base::SetDt(const CEntrez2_reply_Base::TDt& value)
{
    m_Dt = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_reply_Base::TDt& CEntrez2_reply_Base::SetDt(void)
{
    m_set_State[0] |= 0x4;
    return m_Dt;
}

inline
bool CEntrez2_reply_Base::IsSetServer(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_reply_Base::CanGetServer(void) const
{
    return IsSetServer();
}

inline
const CEntrez2_reply_Base::TServer& CEntrez2_reply_Base::GetServer(void) const
{
    if (!CanGetServer()) {
        ThrowUnassigned(2);
    }
    return m_Server;
}

inline
void CEntrez2_reply_Base::SetServer(const CEntrez2_reply_Base::TServer& value)
{
    m_Server = value;
    m_set_State[0] |= 0x30;
}

inline
void CEntrez2_reply_Base::SetServer(CEntrez2_reply_Base::TServer&& value)
{
    m_Server = std::forward<CEntrez2_reply_Base::TServer>(value);
    m_set_State[0] |= 0x30;
}

inline
CEntrez2_reply_Base::TServer& CEntrez2_reply_Base::SetServer(void)
{
#ifdef _DEBUG
    if (!IsSetServer()) {
        m_Server = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Server;
}

inline
bool CEntrez2_reply_Base::IsSetMsg(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CEntrez2_reply_Base::CanGetMsg(void) const
{
    return IsSetMsg();
}

inline
const CEntrez2_reply_Base::TMsg& CEntrez2_reply_Base::GetMsg(void) const
{
    if (!CanGetMsg()) {
        ThrowUnassigned(3);
    }
    return m_Msg;
}

inline
void CEntrez2_reply_Base::SetMsg(const CEntrez2_reply_Base::TMsg& value)
{
    m_Msg = value;
    m_set_State[0] |= 0xc0;
}

inline
void CEntrez2_reply_Base::SetMsg(CEntrez2_reply_Base::TMsg&& value)
{
    m_Msg = std::forward<CEntrez2_reply_Base::TMsg>(value);
    m_set_State[0] |= 0xc0;
}

inline
CEntrez2_reply_Base::TMsg& CEntrez2_reply_Base::SetMsg(void)
{
#ifdef _DEBUG
    if (!IsSetMsg()) {
        m_Msg = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Msg;
}

inline
bool CEntrez2_reply_Base::IsSetKey(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CEntrez2_reply_Base::CanGetKey(void) const
{
    return IsSetKey();
}

inline
const CEntrez2_reply_Base::TKey& CEntrez2_reply_Base::GetKey(void) const
{
    if (!CanGetKey()) {
        ThrowUnassigned(4);
    }
    return m_Key;
}

inline
void CEntrez2_reply_Base::SetKey(const CEntrez2_reply_Base::TKey& value)
{
    m_Key = value;
    m_set_State[0] |= 0x300;
}

inline
void CEntrez2_reply_Base::SetKey(CEntrez2_reply_Base::TKey&& value)
{
    m_Key = std::forward<CEntrez2_reply_Base::TKey>(value);
    m_set_State[0] |= 0x300;
}

inline
CEntrez2_reply_Base::TKey& CEntrez2_reply_Base::SetKey(void)
{
#ifdef _DEBUG
    if (!IsSetKey()) {
        m_Key = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Key;
}

inline
bool CEntrez2_reply_Base::IsSetCookie(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CEntrez2_reply_Base::CanGetCookie(void) const
{
    return IsSetCookie();
}

inline
const CEntrez2_reply_Base::TCookie& CEntrez2_reply_Base::GetCookie(void) const
{
    if (!CanGetCookie()) {
        ThrowUnassigned(5);
    }
    return m_Cookie;
}

inline
void CEntrez2_reply_Base::SetCookie(const CEntrez2_reply_Base::TCookie& value)
{
    m_Cookie = value;
    m_set_State[0] |= 0xc00;
}

inline
void CEntrez2_reply_Base::SetCookie(CEntrez2_reply_Base::TCookie&& value)
{
    m_Cookie = std::forward<CEntrez2_reply_Base::TCookie>(value);
    m_set_State[0] |= 0xc00;
}

inline
CEntrez2_reply_Base::TCookie& CEntrez2_reply_Base::SetCookie(void)
{
#ifdef _DEBUG
    if (!IsSetCookie()) {
        m_Cookie = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Cookie;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_REPLY_BASE_HPP
