/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_docsum_data_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_DOCSUM_DATA_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_DOCSUM_DATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZ2_EXPORT CEntrez2_docsum_data_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_docsum_data_Base(void);
    // destructor
    virtual ~CEntrez2_docsum_data_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TField_name;
    typedef string TField_value;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_field_name,
        e_field_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TField_name
    ///  Check whether the Field_name data member has been assigned a value.
    bool IsSetField_name(void) const;
    /// Check whether it is safe or not to call GetField_name method.
    bool CanGetField_name(void) const;
    void ResetField_name(void);
    const TField_name& GetField_name(void) const;
    void SetField_name(const TField_name& value);
    void SetField_name(TField_name&& value);
    TField_name& SetField_name(void);

    /// mandatory
    /// typedef string TField_value
    ///  Check whether the Field_value data member has been assigned a value.
    bool IsSetField_value(void) const;
    /// Check whether it is safe or not to call GetField_value method.
    bool CanGetField_value(void) const;
    void ResetField_value(void);
    const TField_value& GetField_value(void) const;
    void SetField_value(const TField_value& value);
    void SetField_value(TField_value&& value);
    TField_value& SetField_value(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_docsum_data_Base(const CEntrez2_docsum_data_Base&);
    CEntrez2_docsum_data_Base& operator=(const CEntrez2_docsum_data_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Field_name;
    string m_Field_value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_docsum_data_Base::IsSetField_name(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_docsum_data_Base::CanGetField_name(void) const
{
    return IsSetField_name();
}

inline
const CEntrez2_docsum_data_Base::TField_name& CEntrez2_docsum_data_Base::GetField_name(void) const
{
    if (!CanGetField_name()) {
        ThrowUnassigned(0);
    }
    return m_Field_name;
}

inline
void CEntrez2_docsum_data_Base::SetField_name(const CEntrez2_docsum_data_Base::TField_name& value)
{
    m_Field_name = value;
    m_set_State[0] |= 0x3;
}

inline
void CEntrez2_docsum_data_Base::SetField_name(CEntrez2_docsum_data_Base::TField_name&& value)
{
    m_Field_name = std::forward<CEntrez2_docsum_data_Base::TField_name>(value);
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_docsum_data_Base::TField_name& CEntrez2_docsum_data_Base::SetField_name(void)
{
#ifdef _DEBUG
    if (!IsSetField_name()) {
        m_Field_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Field_name;
}

inline
bool CEntrez2_docsum_data_Base::IsSetField_value(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_docsum_data_Base::CanGetField_value(void) const
{
    return IsSetField_value();
}

inline
const CEntrez2_docsum_data_Base::TField_value& CEntrez2_docsum_data_Base::GetField_value(void) const
{
    if (!CanGetField_value()) {
        ThrowUnassigned(1);
    }
    return m_Field_value;
}

inline
void CEntrez2_docsum_data_Base::SetField_value(const CEntrez2_docsum_data_Base::TField_value& value)
{
    m_Field_value = value;
    m_set_State[0] |= 0xc;
}

inline
void CEntrez2_docsum_data_Base::SetField_value(CEntrez2_docsum_data_Base::TField_value&& value)
{
    m_Field_value = std::forward<CEntrez2_docsum_data_Base::TField_value>(value);
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_docsum_data_Base::TField_value& CEntrez2_docsum_data_Base::SetField_value(void)
{
#ifdef _DEBUG
    if (!IsSetField_value()) {
        m_Field_value = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Field_value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_DOCSUM_DATA_BASE_HPP
