/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_vector_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_VECTOR_BASE_HPP
#define OBJECTS_CN3D_CN3D_VECTOR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a floating point 3d vector
class NCBI_CN3D_EXPORT CCn3d_vector_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_vector_Base(void);
    // destructor
    virtual ~CCn3d_vector_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef double TX;
    typedef double TY;
    typedef double TZ;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_x,
        e_y,
        e_z
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef double TX
    ///  Check whether the X data member has been assigned a value.
    bool IsSetX(void) const;
    /// Check whether it is safe or not to call GetX method.
    bool CanGetX(void) const;
    void ResetX(void);
    TX GetX(void) const;
    void SetX(TX value);
    TX& SetX(void);

    /// mandatory
    /// typedef double TY
    ///  Check whether the Y data member has been assigned a value.
    bool IsSetY(void) const;
    /// Check whether it is safe or not to call GetY method.
    bool CanGetY(void) const;
    void ResetY(void);
    TY GetY(void) const;
    void SetY(TY value);
    TY& SetY(void);

    /// mandatory
    /// typedef double TZ
    ///  Check whether the Z data member has been assigned a value.
    bool IsSetZ(void) const;
    /// Check whether it is safe or not to call GetZ method.
    bool CanGetZ(void) const;
    void ResetZ(void);
    TZ GetZ(void) const;
    void SetZ(TZ value);
    TZ& SetZ(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_vector_Base(const CCn3d_vector_Base&);
    CCn3d_vector_Base& operator=(const CCn3d_vector_Base&);

    // data
    Uint4 m_set_State[1];
    double m_X;
    double m_Y;
    double m_Z;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_vector_Base::IsSetX(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_vector_Base::CanGetX(void) const
{
    return IsSetX();
}

inline
void CCn3d_vector_Base::ResetX(void)
{
    m_X = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCn3d_vector_Base::TX CCn3d_vector_Base::GetX(void) const
{
    if (!CanGetX()) {
        ThrowUnassigned(0);
    }
    return m_X;
}

inline
void CCn3d_vector_Base::SetX(CCn3d_vector_Base::TX value)
{
    m_X = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_vector_Base::TX& CCn3d_vector_Base::SetX(void)
{
#ifdef _DEBUG
    if (!IsSetX()) {
        memset(&m_X,UnassignedByte(),sizeof(m_X));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_X;
}

inline
bool CCn3d_vector_Base::IsSetY(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_vector_Base::CanGetY(void) const
{
    return IsSetY();
}

inline
void CCn3d_vector_Base::ResetY(void)
{
    m_Y = 0;
    m_set_State[0] &= ~0xc;
}

inline
CCn3d_vector_Base::TY CCn3d_vector_Base::GetY(void) const
{
    if (!CanGetY()) {
        ThrowUnassigned(1);
    }
    return m_Y;
}

inline
void CCn3d_vector_Base::SetY(CCn3d_vector_Base::TY value)
{
    m_Y = value;
    m_set_State[0] |= 0xc;
}

inline
CCn3d_vector_Base::TY& CCn3d_vector_Base::SetY(void)
{
#ifdef _DEBUG
    if (!IsSetY()) {
        memset(&m_Y,UnassignedByte(),sizeof(m_Y));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Y;
}

inline
bool CCn3d_vector_Base::IsSetZ(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCn3d_vector_Base::CanGetZ(void) const
{
    return IsSetZ();
}

inline
void CCn3d_vector_Base::ResetZ(void)
{
    m_Z = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCn3d_vector_Base::TZ CCn3d_vector_Base::GetZ(void) const
{
    if (!CanGetZ()) {
        ThrowUnassigned(2);
    }
    return m_Z;
}

inline
void CCn3d_vector_Base::SetZ(CCn3d_vector_Base::TZ value)
{
    m_Z = value;
    m_set_State[0] |= 0x30;
}

inline
CCn3d_vector_Base::TZ& CCn3d_vector_Base::SetZ(void)
{
#ifdef _DEBUG
    if (!IsSetZ()) {
        memset(&m_Z,UnassignedByte(),sizeof(m_Z));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Z;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_VECTOR_BASE_HPP
