/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_residue_range_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_RESIDUE_RANGE_BASE_HPP
#define OBJECTS_CN3D_CN3D_RESIDUE_RANGE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/mmdb1/Residue_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a range of residues in a chain, identified by MMDB residue-id
/// (e.g., numbered from 1)
class NCBI_CN3D_EXPORT CCn3d_residue_range_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_residue_range_Base(void);
    // destructor
    virtual ~CCn3d_residue_range_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CResidue_id TFrom;
    typedef CResidue_id TTo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_from,
        e_to
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CResidue_id TFrom
    ///  Check whether the From data member has been assigned a value.
    bool IsSetFrom(void) const;
    /// Check whether it is safe or not to call GetFrom method.
    bool CanGetFrom(void) const;
    void ResetFrom(void);
    const TFrom& GetFrom(void) const;
    void SetFrom(const TFrom& value);
    TFrom& SetFrom(void);

    /// mandatory
    /// typedef CResidue_id TTo
    ///  Check whether the To data member has been assigned a value.
    bool IsSetTo(void) const;
    /// Check whether it is safe or not to call GetTo method.
    bool CanGetTo(void) const;
    void ResetTo(void);
    const TTo& GetTo(void) const;
    void SetTo(const TTo& value);
    TTo& SetTo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_residue_range_Base(const CCn3d_residue_range_Base&);
    CCn3d_residue_range_Base& operator=(const CCn3d_residue_range_Base&);

    // data
    Uint4 m_set_State[1];
    CResidue_id m_From;
    CResidue_id m_To;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_residue_range_Base::IsSetFrom(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_residue_range_Base::CanGetFrom(void) const
{
    return IsSetFrom();
}

inline
void CCn3d_residue_range_Base::ResetFrom(void)
{
    m_From = CResidue_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CCn3d_residue_range_Base::TFrom& CCn3d_residue_range_Base::GetFrom(void) const
{
    if (!CanGetFrom()) {
        ThrowUnassigned(0);
    }
    return m_From;
}

inline
void CCn3d_residue_range_Base::SetFrom(const CCn3d_residue_range_Base::TFrom& value)
{
    m_From = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_residue_range_Base::TFrom& CCn3d_residue_range_Base::SetFrom(void)
{
    m_set_State[0] |= 0x1;
    return m_From;
}

inline
bool CCn3d_residue_range_Base::IsSetTo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_residue_range_Base::CanGetTo(void) const
{
    return IsSetTo();
}

inline
void CCn3d_residue_range_Base::ResetTo(void)
{
    m_To = CResidue_id(0);
    m_set_State[0] &= ~0xc;
}

inline
const CCn3d_residue_range_Base::TTo& CCn3d_residue_range_Base::GetTo(void) const
{
    if (!CanGetTo()) {
        ThrowUnassigned(1);
    }
    return m_To;
}

inline
void CCn3d_residue_range_Base::SetTo(const CCn3d_residue_range_Base::TTo& value)
{
    m_To = value;
    m_set_State[0] |= 0xc;
}

inline
CCn3d_residue_range_Base::TTo& CCn3d_residue_range_Base::SetTo(void)
{
    m_set_State[0] |= 0x4;
    return m_To;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_RESIDUE_RANGE_BASE_HPP
