/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Reject_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_REJECT_ID_BASE_HPP
#define OBJECTS_CDD_REJECT_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;
class CUpdate_comment;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_CDD_EXPORT CReject_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CReject_id_Base(void);
    // destructor
    virtual ~CReject_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CUpdate_comment > > TDescription;
    typedef list< CRef< CSeq_id > > TIds;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_description,
        e_ids
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CUpdate_comment > > TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    TDescription& SetDescription(void);

    /// mandatory
    /// typedef list< CRef< CSeq_id > > TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CReject_id_Base(const CReject_id_Base&);
    CReject_id_Base& operator=(const CReject_id_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CUpdate_comment > > m_Description;
    list< CRef< CSeq_id > > m_Ids;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CReject_id_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CReject_id_Base::CanGetDescription(void) const
{
    return true;
}

inline
const CReject_id_Base::TDescription& CReject_id_Base::GetDescription(void) const
{
    return m_Description;
}

inline
CReject_id_Base::TDescription& CReject_id_Base::SetDescription(void)
{
    m_set_State[0] |= 0x1;
    return m_Description;
}

inline
bool CReject_id_Base::IsSetIds(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CReject_id_Base::CanGetIds(void) const
{
    return true;
}

inline
const CReject_id_Base::TIds& CReject_id_Base::GetIds(void) const
{
    return m_Ids;
}

inline
CReject_id_Base::TIds& CReject_id_Base::SetIds(void)
{
    m_set_State[0] |= 0x4;
    return m_Ids;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_REJECT_ID_BASE_HPP
