/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast_mask_list_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastdb.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTDB_BLAST_MASK_LIST_BASE_HPP
#define OBJECTS_BLASTDB_BLAST_MASK_LIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTDB_EXPORT CBlast_mask_list_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast_mask_list_Base(void);
    // destructor
    virtual ~CBlast_mask_list_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CSeq_loc > > TMasks;
    typedef bool TMore;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_masks,
        e_more
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// masks for a single sequence should be grouped in a Packed-seqint
    /// mandatory
    /// typedef list< CRef< CSeq_loc > > TMasks
    ///  Check whether the Masks data member has been assigned a value.
    bool IsSetMasks(void) const;
    /// Check whether it is safe or not to call GetMasks method.
    bool CanGetMasks(void) const;
    void ResetMasks(void);
    const TMasks& GetMasks(void) const;
    TMasks& SetMasks(void);

    /// as of 01/21/2010, this field is set to false always, indicating that the
    /// entire object (set of Seq-loc) is contained in this object
    /// mandatory
    /// typedef bool TMore
    ///  Check whether the More data member has been assigned a value.
    bool IsSetMore(void) const;
    /// Check whether it is safe or not to call GetMore method.
    bool CanGetMore(void) const;
    void ResetMore(void);
    TMore GetMore(void) const;
    void SetMore(TMore value);
    TMore& SetMore(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast_mask_list_Base(const CBlast_mask_list_Base&);
    CBlast_mask_list_Base& operator=(const CBlast_mask_list_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CSeq_loc > > m_Masks;
    bool m_More;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast_mask_list_Base::IsSetMasks(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast_mask_list_Base::CanGetMasks(void) const
{
    return true;
}

inline
const CBlast_mask_list_Base::TMasks& CBlast_mask_list_Base::GetMasks(void) const
{
    return m_Masks;
}

inline
CBlast_mask_list_Base::TMasks& CBlast_mask_list_Base::SetMasks(void)
{
    m_set_State[0] |= 0x1;
    return m_Masks;
}

inline
bool CBlast_mask_list_Base::IsSetMore(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast_mask_list_Base::CanGetMore(void) const
{
    return IsSetMore();
}

inline
void CBlast_mask_list_Base::ResetMore(void)
{
    m_More = 0;
    m_set_State[0] &= ~0xc;
}

inline
CBlast_mask_list_Base::TMore CBlast_mask_list_Base::GetMore(void) const
{
    if (!CanGetMore()) {
        ThrowUnassigned(1);
    }
    return m_More;
}

inline
void CBlast_mask_list_Base::SetMore(CBlast_mask_list_Base::TMore value)
{
    m_More = value;
    m_set_State[0] |= 0xc;
}

inline
CBlast_mask_list_Base::TMore& CBlast_mask_list_Base::SetMore(void)
{
#ifdef _DEBUG
    if (!IsSetMore()) {
        memset(&m_More,UnassignedByte(),sizeof(m_More));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_More;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTDB_BLAST_MASK_LIST_BASE_HPP
