/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_value_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_VALUE_BASE_HPP
#define OBJECTS_BLAST_BLAST4_VALUE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/blast/Blast4_strand_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBioseq;
class CBioseq_set;
class CBlast4_cutoff;
class CBlast4_mask;
class CPssmWithParameters;
class CSeq_align;
class CSeq_align_set;
class CSeq_id;
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLAST_EXPORT CBlast4_value_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_value_Base(void);
    // destructor
    virtual ~CBlast4_value_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,       ///< No variant selected
        e_Big_integer,       ///< scalar types
        e_Bioseq,
        e_Boolean,
        e_Cutoff,
        e_Integer,
        e_Matrix,
        e_Real,
        e_Seq_align,
        e_Seq_id,
        e_Seq_loc,
        e_Strand_type,
        e_String,
        e_Big_integer_list,  ///< lists of scalar types
        e_Bioseq_list,
        e_Boolean_list,
        e_Cutoff_list,
        e_Integer_list,
        e_Matrix_list,
        e_Real_list,
        e_Seq_align_list,
        e_Seq_id_list,
        e_Seq_loc_list,
        e_Strand_type_list,
        e_String_list,
        e_Bioseq_set,        ///< imported collection types
        e_Seq_align_set,
        e_Query_mask         ///< Intended to represent user-provided masking locations for a single query  sequence (name field in Blast4-parameter should be "LCaseMask").  Multiple Blast4-parameters of this type are needed to specify masking  locations for multiple queries.
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 28 ///< == e_Query_mask+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef Int8 TBig_integer;
    typedef CBioseq TBioseq;
    typedef bool TBoolean;
    typedef CBlast4_cutoff TCutoff;
    typedef int TInteger;
    typedef CPssmWithParameters TMatrix;
    typedef double TReal;
    typedef CSeq_align TSeq_align;
    typedef CSeq_id TSeq_id;
    typedef CSeq_loc TSeq_loc;
    typedef EBlast4_strand_type TStrand_type;
    typedef string TString;
    typedef list< Int8 > TBig_integer_list;
    typedef list< CRef< CBioseq > > TBioseq_list;
    typedef list< bool > TBoolean_list;
    typedef list< CRef< CBlast4_cutoff > > TCutoff_list;
    typedef list< int > TInteger_list;
    typedef list< CRef< CPssmWithParameters > > TMatrix_list;
    typedef list< double > TReal_list;
    typedef list< CRef< CSeq_align > > TSeq_align_list;
    typedef list< CRef< CSeq_id > > TSeq_id_list;
    typedef list< CRef< CSeq_loc > > TSeq_loc_list;
    typedef list< EBlast4_strand_type > TStrand_type_list;
    typedef list< string > TString_list;
    typedef CBioseq_set TBioseq_set;
    typedef CSeq_align_set TSeq_align_set;
    typedef CBlast4_mask TQuery_mask;

    // getters
    // setters

    // typedef Int8 TBig_integer
    bool IsBig_integer(void) const;
    TBig_integer GetBig_integer(void) const;
    TBig_integer& SetBig_integer(void);
    void SetBig_integer(TBig_integer value);

    // typedef CBioseq TBioseq
    bool IsBioseq(void) const;
    const TBioseq& GetBioseq(void) const;
    TBioseq& SetBioseq(void);
    void SetBioseq(TBioseq& value);

    // typedef bool TBoolean
    bool IsBoolean(void) const;
    TBoolean GetBoolean(void) const;
    TBoolean& SetBoolean(void);
    void SetBoolean(TBoolean value);

    // typedef CBlast4_cutoff TCutoff
    bool IsCutoff(void) const;
    const TCutoff& GetCutoff(void) const;
    TCutoff& SetCutoff(void);
    void SetCutoff(TCutoff& value);

    // typedef int TInteger
    bool IsInteger(void) const;
    TInteger GetInteger(void) const;
    TInteger& SetInteger(void);
    void SetInteger(TInteger value);

    // typedef CPssmWithParameters TMatrix
    bool IsMatrix(void) const;
    const TMatrix& GetMatrix(void) const;
    TMatrix& SetMatrix(void);
    void SetMatrix(TMatrix& value);

    // typedef double TReal
    bool IsReal(void) const;
    TReal GetReal(void) const;
    TReal& SetReal(void);
    void SetReal(TReal value);

    // typedef CSeq_align TSeq_align
    bool IsSeq_align(void) const;
    const TSeq_align& GetSeq_align(void) const;
    TSeq_align& SetSeq_align(void);
    void SetSeq_align(TSeq_align& value);

    // typedef CSeq_id TSeq_id
    bool IsSeq_id(void) const;
    const TSeq_id& GetSeq_id(void) const;
    TSeq_id& SetSeq_id(void);
    void SetSeq_id(TSeq_id& value);

    // typedef CSeq_loc TSeq_loc
    bool IsSeq_loc(void) const;
    const TSeq_loc& GetSeq_loc(void) const;
    TSeq_loc& SetSeq_loc(void);
    void SetSeq_loc(TSeq_loc& value);

    // typedef EBlast4_strand_type TStrand_type
    bool IsStrand_type(void) const;
    TStrand_type GetStrand_type(void) const;
    TStrand_type& SetStrand_type(void);
    void SetStrand_type(TStrand_type value);

    // typedef string TString
    bool IsString(void) const;
    const TString& GetString(void) const;
    TString& SetString(void);
    void SetString(const TString& value);

    // typedef list< Int8 > TBig_integer_list
    bool IsBig_integer_list(void) const;
    const TBig_integer_list& GetBig_integer_list(void) const;
    TBig_integer_list& SetBig_integer_list(void);

    // typedef list< CRef< CBioseq > > TBioseq_list
    bool IsBioseq_list(void) const;
    const TBioseq_list& GetBioseq_list(void) const;
    TBioseq_list& SetBioseq_list(void);

    // typedef list< bool > TBoolean_list
    bool IsBoolean_list(void) const;
    const TBoolean_list& GetBoolean_list(void) const;
    TBoolean_list& SetBoolean_list(void);

    // typedef list< CRef< CBlast4_cutoff > > TCutoff_list
    bool IsCutoff_list(void) const;
    const TCutoff_list& GetCutoff_list(void) const;
    TCutoff_list& SetCutoff_list(void);

    // typedef list< int > TInteger_list
    bool IsInteger_list(void) const;
    const TInteger_list& GetInteger_list(void) const;
    TInteger_list& SetInteger_list(void);

    // typedef list< CRef< CPssmWithParameters > > TMatrix_list
    bool IsMatrix_list(void) const;
    const TMatrix_list& GetMatrix_list(void) const;
    TMatrix_list& SetMatrix_list(void);

    // typedef list< double > TReal_list
    bool IsReal_list(void) const;
    const TReal_list& GetReal_list(void) const;
    TReal_list& SetReal_list(void);

    // typedef list< CRef< CSeq_align > > TSeq_align_list
    bool IsSeq_align_list(void) const;
    const TSeq_align_list& GetSeq_align_list(void) const;
    TSeq_align_list& SetSeq_align_list(void);

    // typedef list< CRef< CSeq_id > > TSeq_id_list
    bool IsSeq_id_list(void) const;
    const TSeq_id_list& GetSeq_id_list(void) const;
    TSeq_id_list& SetSeq_id_list(void);

    // typedef list< CRef< CSeq_loc > > TSeq_loc_list
    bool IsSeq_loc_list(void) const;
    const TSeq_loc_list& GetSeq_loc_list(void) const;
    TSeq_loc_list& SetSeq_loc_list(void);

    // typedef list< EBlast4_strand_type > TStrand_type_list
    bool IsStrand_type_list(void) const;
    const TStrand_type_list& GetStrand_type_list(void) const;
    TStrand_type_list& SetStrand_type_list(void);

    // typedef list< string > TString_list
    bool IsString_list(void) const;
    const TString_list& GetString_list(void) const;
    TString_list& SetString_list(void);

    // typedef CBioseq_set TBioseq_set
    bool IsBioseq_set(void) const;
    const TBioseq_set& GetBioseq_set(void) const;
    TBioseq_set& SetBioseq_set(void);
    void SetBioseq_set(TBioseq_set& value);

    // typedef CSeq_align_set TSeq_align_set
    bool IsSeq_align_set(void) const;
    const TSeq_align_set& GetSeq_align_set(void) const;
    TSeq_align_set& SetSeq_align_set(void);
    void SetSeq_align_set(TSeq_align_set& value);

    // typedef CBlast4_mask TQuery_mask
    bool IsQuery_mask(void) const;
    const TQuery_mask& GetQuery_mask(void) const;
    TQuery_mask& SetQuery_mask(void);
    void SetQuery_mask(TQuery_mask& value);


private:
    // copy constructor and assignment operator
    CBlast4_value_Base(const CBlast4_value_Base& );
    CBlast4_value_Base& operator=(const CBlast4_value_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TBig_integer m_Big_integer;
        TBoolean m_Boolean;
        TInteger m_Integer;
        TReal m_Real;
        TStrand_type m_Strand_type;
        NCBI_NS_NCBI::CUnionBuffer<TBig_integer_list> m_Big_integer_list;
        NCBI_NS_NCBI::CUnionBuffer<TBioseq_list> m_Bioseq_list;
        NCBI_NS_NCBI::CUnionBuffer<TBoolean_list> m_Boolean_list;
        NCBI_NS_NCBI::CUnionBuffer<TCutoff_list> m_Cutoff_list;
        NCBI_NS_NCBI::CUnionBuffer<TInteger_list> m_Integer_list;
        NCBI_NS_NCBI::CUnionBuffer<TMatrix_list> m_Matrix_list;
        NCBI_NS_NCBI::CUnionBuffer<TReal_list> m_Real_list;
        NCBI_NS_NCBI::CUnionBuffer<TSeq_align_list> m_Seq_align_list;
        NCBI_NS_NCBI::CUnionBuffer<TSeq_id_list> m_Seq_id_list;
        NCBI_NS_NCBI::CUnionBuffer<TSeq_loc_list> m_Seq_loc_list;
        NCBI_NS_NCBI::CUnionBuffer<TStrand_type_list> m_Strand_type_list;
        NCBI_NS_NCBI::CUnionBuffer<TString_list> m_String_list;
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBlast4_value_Base::E_Choice CBlast4_value_Base::Which(void) const
{
    return m_choice;
}

inline
void CBlast4_value_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBlast4_value_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBlast4_value_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBlast4_value_Base::IsBig_integer(void) const
{
    return m_choice == e_Big_integer;
}

inline
CBlast4_value_Base::TBig_integer CBlast4_value_Base::GetBig_integer(void) const
{
    CheckSelected(e_Big_integer);
    return m_Big_integer;
}

inline
CBlast4_value_Base::TBig_integer& CBlast4_value_Base::SetBig_integer(void)
{
    Select(e_Big_integer, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Big_integer;
}

inline
void CBlast4_value_Base::SetBig_integer(CBlast4_value_Base::TBig_integer value)
{
    Select(e_Big_integer, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Big_integer = value;
}

inline
bool CBlast4_value_Base::IsBioseq(void) const
{
    return m_choice == e_Bioseq;
}

inline
bool CBlast4_value_Base::IsBoolean(void) const
{
    return m_choice == e_Boolean;
}

inline
CBlast4_value_Base::TBoolean CBlast4_value_Base::GetBoolean(void) const
{
    CheckSelected(e_Boolean);
    return m_Boolean;
}

inline
CBlast4_value_Base::TBoolean& CBlast4_value_Base::SetBoolean(void)
{
    Select(e_Boolean, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Boolean;
}

inline
void CBlast4_value_Base::SetBoolean(CBlast4_value_Base::TBoolean value)
{
    Select(e_Boolean, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Boolean = value;
}

inline
bool CBlast4_value_Base::IsCutoff(void) const
{
    return m_choice == e_Cutoff;
}

inline
bool CBlast4_value_Base::IsInteger(void) const
{
    return m_choice == e_Integer;
}

inline
CBlast4_value_Base::TInteger CBlast4_value_Base::GetInteger(void) const
{
    CheckSelected(e_Integer);
    return m_Integer;
}

inline
CBlast4_value_Base::TInteger& CBlast4_value_Base::SetInteger(void)
{
    Select(e_Integer, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Integer;
}

inline
void CBlast4_value_Base::SetInteger(CBlast4_value_Base::TInteger value)
{
    Select(e_Integer, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Integer = value;
}

inline
bool CBlast4_value_Base::IsMatrix(void) const
{
    return m_choice == e_Matrix;
}

inline
bool CBlast4_value_Base::IsReal(void) const
{
    return m_choice == e_Real;
}

inline
CBlast4_value_Base::TReal CBlast4_value_Base::GetReal(void) const
{
    CheckSelected(e_Real);
    return m_Real;
}

inline
CBlast4_value_Base::TReal& CBlast4_value_Base::SetReal(void)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Real;
}

inline
void CBlast4_value_Base::SetReal(CBlast4_value_Base::TReal value)
{
    Select(e_Real, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Real = value;
}

inline
bool CBlast4_value_Base::IsSeq_align(void) const
{
    return m_choice == e_Seq_align;
}

inline
bool CBlast4_value_Base::IsSeq_id(void) const
{
    return m_choice == e_Seq_id;
}

inline
bool CBlast4_value_Base::IsSeq_loc(void) const
{
    return m_choice == e_Seq_loc;
}

inline
bool CBlast4_value_Base::IsStrand_type(void) const
{
    return m_choice == e_Strand_type;
}

inline
CBlast4_value_Base::TStrand_type CBlast4_value_Base::GetStrand_type(void) const
{
    CheckSelected(e_Strand_type);
    return m_Strand_type;
}

inline
CBlast4_value_Base::TStrand_type& CBlast4_value_Base::SetStrand_type(void)
{
    Select(e_Strand_type, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Strand_type;
}

inline
void CBlast4_value_Base::SetStrand_type(CBlast4_value_Base::TStrand_type value)
{
    Select(e_Strand_type, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Strand_type = value;
}

inline
bool CBlast4_value_Base::IsString(void) const
{
    return m_choice == e_String;
}

inline
const CBlast4_value_Base::TString& CBlast4_value_Base::GetString(void) const
{
    CheckSelected(e_String);
    return *m_string;
}

inline
CBlast4_value_Base::TString& CBlast4_value_Base::SetString(void)
{
    Select(e_String, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CBlast4_value_Base::IsBig_integer_list(void) const
{
    return m_choice == e_Big_integer_list;
}

inline
const CBlast4_value_Base::TBig_integer_list& CBlast4_value_Base::GetBig_integer_list(void) const
{
    CheckSelected(e_Big_integer_list);
    return *m_Big_integer_list;
}

inline
CBlast4_value_Base::TBig_integer_list& CBlast4_value_Base::SetBig_integer_list(void)
{
    Select(e_Big_integer_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Big_integer_list;
}

inline
bool CBlast4_value_Base::IsBioseq_list(void) const
{
    return m_choice == e_Bioseq_list;
}

inline
const CBlast4_value_Base::TBioseq_list& CBlast4_value_Base::GetBioseq_list(void) const
{
    CheckSelected(e_Bioseq_list);
    return *m_Bioseq_list;
}

inline
CBlast4_value_Base::TBioseq_list& CBlast4_value_Base::SetBioseq_list(void)
{
    Select(e_Bioseq_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Bioseq_list;
}

inline
bool CBlast4_value_Base::IsBoolean_list(void) const
{
    return m_choice == e_Boolean_list;
}

inline
const CBlast4_value_Base::TBoolean_list& CBlast4_value_Base::GetBoolean_list(void) const
{
    CheckSelected(e_Boolean_list);
    return *m_Boolean_list;
}

inline
CBlast4_value_Base::TBoolean_list& CBlast4_value_Base::SetBoolean_list(void)
{
    Select(e_Boolean_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Boolean_list;
}

inline
bool CBlast4_value_Base::IsCutoff_list(void) const
{
    return m_choice == e_Cutoff_list;
}

inline
const CBlast4_value_Base::TCutoff_list& CBlast4_value_Base::GetCutoff_list(void) const
{
    CheckSelected(e_Cutoff_list);
    return *m_Cutoff_list;
}

inline
CBlast4_value_Base::TCutoff_list& CBlast4_value_Base::SetCutoff_list(void)
{
    Select(e_Cutoff_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Cutoff_list;
}

inline
bool CBlast4_value_Base::IsInteger_list(void) const
{
    return m_choice == e_Integer_list;
}

inline
const CBlast4_value_Base::TInteger_list& CBlast4_value_Base::GetInteger_list(void) const
{
    CheckSelected(e_Integer_list);
    return *m_Integer_list;
}

inline
CBlast4_value_Base::TInteger_list& CBlast4_value_Base::SetInteger_list(void)
{
    Select(e_Integer_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Integer_list;
}

inline
bool CBlast4_value_Base::IsMatrix_list(void) const
{
    return m_choice == e_Matrix_list;
}

inline
const CBlast4_value_Base::TMatrix_list& CBlast4_value_Base::GetMatrix_list(void) const
{
    CheckSelected(e_Matrix_list);
    return *m_Matrix_list;
}

inline
CBlast4_value_Base::TMatrix_list& CBlast4_value_Base::SetMatrix_list(void)
{
    Select(e_Matrix_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Matrix_list;
}

inline
bool CBlast4_value_Base::IsReal_list(void) const
{
    return m_choice == e_Real_list;
}

inline
const CBlast4_value_Base::TReal_list& CBlast4_value_Base::GetReal_list(void) const
{
    CheckSelected(e_Real_list);
    return *m_Real_list;
}

inline
CBlast4_value_Base::TReal_list& CBlast4_value_Base::SetReal_list(void)
{
    Select(e_Real_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Real_list;
}

inline
bool CBlast4_value_Base::IsSeq_align_list(void) const
{
    return m_choice == e_Seq_align_list;
}

inline
const CBlast4_value_Base::TSeq_align_list& CBlast4_value_Base::GetSeq_align_list(void) const
{
    CheckSelected(e_Seq_align_list);
    return *m_Seq_align_list;
}

inline
CBlast4_value_Base::TSeq_align_list& CBlast4_value_Base::SetSeq_align_list(void)
{
    Select(e_Seq_align_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Seq_align_list;
}

inline
bool CBlast4_value_Base::IsSeq_id_list(void) const
{
    return m_choice == e_Seq_id_list;
}

inline
const CBlast4_value_Base::TSeq_id_list& CBlast4_value_Base::GetSeq_id_list(void) const
{
    CheckSelected(e_Seq_id_list);
    return *m_Seq_id_list;
}

inline
CBlast4_value_Base::TSeq_id_list& CBlast4_value_Base::SetSeq_id_list(void)
{
    Select(e_Seq_id_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Seq_id_list;
}

inline
bool CBlast4_value_Base::IsSeq_loc_list(void) const
{
    return m_choice == e_Seq_loc_list;
}

inline
const CBlast4_value_Base::TSeq_loc_list& CBlast4_value_Base::GetSeq_loc_list(void) const
{
    CheckSelected(e_Seq_loc_list);
    return *m_Seq_loc_list;
}

inline
CBlast4_value_Base::TSeq_loc_list& CBlast4_value_Base::SetSeq_loc_list(void)
{
    Select(e_Seq_loc_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Seq_loc_list;
}

inline
bool CBlast4_value_Base::IsStrand_type_list(void) const
{
    return m_choice == e_Strand_type_list;
}

inline
const CBlast4_value_Base::TStrand_type_list& CBlast4_value_Base::GetStrand_type_list(void) const
{
    CheckSelected(e_Strand_type_list);
    return *m_Strand_type_list;
}

inline
CBlast4_value_Base::TStrand_type_list& CBlast4_value_Base::SetStrand_type_list(void)
{
    Select(e_Strand_type_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Strand_type_list;
}

inline
bool CBlast4_value_Base::IsString_list(void) const
{
    return m_choice == e_String_list;
}

inline
const CBlast4_value_Base::TString_list& CBlast4_value_Base::GetString_list(void) const
{
    CheckSelected(e_String_list);
    return *m_String_list;
}

inline
CBlast4_value_Base::TString_list& CBlast4_value_Base::SetString_list(void)
{
    Select(e_String_list, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_String_list;
}

inline
bool CBlast4_value_Base::IsBioseq_set(void) const
{
    return m_choice == e_Bioseq_set;
}

inline
bool CBlast4_value_Base::IsSeq_align_set(void) const
{
    return m_choice == e_Seq_align_set;
}

inline
bool CBlast4_value_Base::IsQuery_mask(void) const
{
    return m_choice == e_Query_mask;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_VALUE_BASE_HPP
