/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_error_code_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_ERROR_CODE_BASE_HPP
#define OBJECTS_BLAST_BLAST4_ERROR_CODE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// Defines values for use in Blast4-error::code.
/// Note: warnings should have values greater than 1024 and less than 2048,
/// errors should have values greater than 2048.
enum EBlast4_error_code {
    eBlast4_error_code_conversion_warning = 1024,  ///< A conversion issue was found when converting to/from blast3 from/to   blast4 protocol in the blast4 server
    eBlast4_error_code_internal_error     = 2048,  ///< Indicates internal errors in the blast4 server
    eBlast4_error_code_not_implemented    = 2049,  ///< Request type is not implemented in the blast4 server
    eBlast4_error_code_not_allowed        = 2050,  ///< Request type is not allowed in the blast4 server
    eBlast4_error_code_bad_request        = 2051,  ///< Malformed/invalid requests (e.g.: parsing errors or invalid data in request)
    eBlast4_error_code_bad_request_id     = 2052,  ///< The RID requested is unknown or it has expired
    eBlast4_error_code_search_pending     = 2053  ///< The search is pending
};

/// Access to EBlast4_error_code's attributes (values, names) as defined in spec
NCBI_BLAST_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EBlast4_error_code)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_ERROR_CODE_BASE_HPP
