/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.Collection;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.Base64;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenManager$ {
    public static DelegationTokenManager$ MODULE$;
    private final String DefaultHmacAlgorithm;
    private final String OwnerKey;
    private final String RenewersKey;
    private final String IssueTimestampKey;
    private final String MaxTimestampKey;
    private final String ExpiryTimestampKey;
    private final String TokenIdKey;
    private final String VersionKey;
    private final int CurrentVersion;
    private final int ErrorTimestamp;

    static {
        new DelegationTokenManager$();
    }

    public String DefaultHmacAlgorithm() {
        return this.DefaultHmacAlgorithm;
    }

    public String OwnerKey() {
        return this.OwnerKey;
    }

    public String RenewersKey() {
        return this.RenewersKey;
    }

    public String IssueTimestampKey() {
        return this.IssueTimestampKey;
    }

    public String MaxTimestampKey() {
        return this.MaxTimestampKey;
    }

    public String ExpiryTimestampKey() {
        return this.ExpiryTimestampKey;
    }

    public String TokenIdKey() {
        return this.TokenIdKey;
    }

    public String VersionKey() {
        return this.VersionKey;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public int ErrorTimestamp() {
        return this.ErrorTimestamp;
    }

    public byte[] createHmac(String tokenId, String secretKey) {
        return this.createHmac(tokenId, this.createSecretKey(secretKey.getBytes(StandardCharsets.UTF_8)));
    }

    public SecretKey createSecretKey(byte[] keybytes) {
        return new SecretKeySpec(keybytes, this.DefaultHmacAlgorithm());
    }

    public String createBase64HMAC(String tokenId, SecretKey secretKey) {
        byte[] hmac = this.createHmac(tokenId, secretKey);
        return Base64.encoder().encodeToString(hmac);
    }

    public byte[] createHmac(String tokenId, SecretKey secretKey) {
        Mac mac = Mac.getInstance(this.DefaultHmacAlgorithm());
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(tokenId.getBytes(StandardCharsets.UTF_8));
    }

    public Map<String, Object> toJsonCompatibleMap(DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        scala.collection.mutable.Map tokenInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        tokenInfoMap.update((Object)this.VersionKey(), (Object)BoxesRunTime.boxToInteger((int)this.CurrentVersion()));
        tokenInfoMap.update((Object)this.OwnerKey(), (Object)Sanitizer.sanitize((String)tokenInfo.ownerAsString()));
        tokenInfoMap.update((Object)this.RenewersKey(), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewersAsString()).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Sanitizer.sanitize((String)e), Iterable$.MODULE$.canBuildFrom())).asJava());
        tokenInfoMap.update((Object)this.IssueTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.issueTimestamp()));
        tokenInfoMap.update((Object)this.MaxTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.maxTimestamp()));
        tokenInfoMap.update((Object)this.ExpiryTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.expiryTimestamp()));
        tokenInfoMap.update((Object)this.TokenIdKey(), (Object)tokenInfo.tokenId());
        return tokenInfoMap.toMap(Predef$.MODULE$.$conforms());
    }

    public Option<TokenInformation> fromBytes(byte[] bytes) {
        None$ none$;
        if (bytes == null || new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            return None$.MODULE$;
        }
        Option<JsonValue> option = Json$.MODULE$.parseBytes(bytes);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            JsonObject mainJs = js.asJsonObject();
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)mainJs.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$)) == this.CurrentVersion());
            KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)Sanitizer.desanitize((String)mainJs.apply(this.OwnerKey()).to(DecodeJson$DecodeString$.MODULE$)));
            Seq renewerStr = (Seq)mainJs.apply(this.RenewersKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Seq renewers = (Seq)((TraversableLike)renewerStr.map((Function1 & Serializable & scala.Serializable)x$1 -> Sanitizer.desanitize((String)x$1), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> SecurityUtils.parseKafkaPrincipal((String)x$2), Seq$.MODULE$.canBuildFrom());
            long issueTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.IssueTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long expiryTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.ExpiryTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long maxTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.MaxTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            String tokenId = mainJs.apply(this.TokenIdKey()).to(DecodeJson$DecodeString$.MODULE$);
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimestamp, maxTimestamp, expiryTimestamp);
            none$ = new Some((Object)tokenInfo);
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public boolean filterToken(KafkaPrincipal requestedPrincipal, Option<List<KafkaPrincipal>> owners, TokenInformation token, Function1<String, Object> authorizeToken) {
        boolean allow = !owners.isEmpty() && !((LinearSeqOptimized)owners.get()).exists((Function1 & Serializable & scala.Serializable)owner -> BoxesRunTime.boxToBoolean((boolean)token.ownerOrRenewer(owner))) ? false : (token.ownerOrRenewer(requestedPrincipal) ? true : BoxesRunTime.unboxToBoolean((Object)authorizeToken.apply((Object)token.tokenId())));
        return allow;
    }

    private DelegationTokenManager$() {
        MODULE$ = this;
        this.DefaultHmacAlgorithm = "HmacSHA512";
        this.OwnerKey = "owner";
        this.RenewersKey = "renewers";
        this.IssueTimestampKey = "issueTimestamp";
        this.MaxTimestampKey = "maxTimestamp";
        this.ExpiryTimestampKey = "expiryTimestamp";
        this.TokenIdKey = "tokenId";
        this.VersionKey = "version";
        this.CurrentVersion = 1;
        this.ErrorTimestamp = -1;
    }
}

