/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.QuotaType$Request$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000f\u0003\u0005\u000e\u0001\t\u0015\r\u0011\"\u0003\u000f\u0003\u0019\u0019wN\u001c4jOV\tq\u0002\u0005\u0002\n!%\u0011\u0011C\u0001\u0002\u0019\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'oQ8oM&<\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011B\b\u0002\u000f\r|gNZ5hA!AQ\u0003\u0001BC\u0002\u0013%a#A\u0004nKR\u0014\u0018nY:\u0016\u0003]\u0001\"\u0001G\u0011\u000e\u0003eQ!!\u0006\u000e\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u0006;)\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0013\t\u0011\u0013DA\u0004NKR\u0014\u0018nY:\t\u0011\u0011\u0002!\u0011!Q\u0001\n]\t\u0001\"\\3ue&\u001c7\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u0005O\u0005!A/[7f+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\u001b\u0003\u0015)H/\u001b7t\u0013\ti#F\u0001\u0003US6,\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u000bQLW.\u001a\u0011\t\u0011E\u0002!\u0011!Q\u0001\nI\n\u0001\u0003\u001e5sK\u0006$g*Y7f!J,g-\u001b=\u0011\u0005MbdB\u0001\u001b;!\t)\u0004(D\u00017\u0015\t9d!\u0001\u0004=e>|GO\u0010\u0006\u0002s\u0005)1oY1mC&\u00111\bO\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<q!)\u0001\t\u0001C\u0001\u0003\u00061A(\u001b8jiz\"RAQ\"E\u000b\u001a\u0003\"!\u0003\u0001\t\u000b5y\u0004\u0019A\b\t\u000bUy\u0004\u0019A\f\t\u000b\u0019z\u0004\u0019\u0001\u0015\t\u000bEz\u0004\u0019\u0001\u001a\t\u000f!\u0003!\u0019!C\u0001\u0013\u0006\tR.\u0019=UQJ|G\u000f\u001e7f)&lW-T:\u0016\u0003)\u0003\"a\u0013'\u000e\u0003aJ!!\u0014\u001d\u0003\t1{gn\u001a\u0005\u0007\u001f\u0002\u0001\u000b\u0011\u0002&\u0002%5\f\u0007\u0010\u00165s_R$H.\u001a+j[\u0016l5\u000f\t\u0005\u0006#\u0002!\tAU\u0001\rKb,W\u000e\u001d;TK:\u001cxN]\u000b\u0002'B\u0011\u0001\u0004V\u0005\u0003+f\u0011aaU3og>\u0014\b\"B,\u0001\t\u0003A\u0016\u0001\u0004:fG>\u0014H-\u0012=f[B$HCA-]!\tY%,\u0003\u0002\\q\t!QK\\5u\u0011\u0015if\u000b1\u0001_\u0003\u00151\u0018\r\\;f!\tYu,\u0003\u0002aq\t1Ai\\;cY\u0016DQA\u0019\u0001\u0005\u0002\r\fa#\\1zE\u0016\u0014VmY8sI\u0006sG\r\u00165s_R$H.\u001a\u000b\u00043\u0012\u0004\b\"B3b\u0001\u00041\u0017a\u0002:fcV,7\u000f\u001e\t\u0003O6t!\u0001[6\u000e\u0003%T!A\u001b\u0003\u0002\u000f9,Go^8sW&\u0011A.[\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\tqwNA\u0004SKF,Xm\u001d;\u000b\u00051L\u0007\"B9b\u0001\u0004\u0011\u0018\u0001F:f]\u0012\u0014Vm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003LgVL\u0016B\u0001;9\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002Lm&\u0011q\u000f\u000f\u0002\u0004\u0013:$\b\"B=\u0001\t\u0003Q\u0018!E7bs\n,'+Z2pe\u0012,\u00050Z7qiR\u0011\u0011l\u001f\u0005\u0006Kb\u0004\rA\u001a\u0005\u0006{\u0002!\tF`\u0001\ri\"\u0014x\u000e\u001e;mKRKW.\u001a\u000b\u0005\u0015~\fI\u0001C\u0004\u0002\u0002q\u0004\r!a\u0001\u0002\u0019\rd\u0017.\u001a8u\u001b\u0016$(/[2\u0011\u0007a\t)!C\u0002\u0002\be\u00111bS1gW\u0006lU\r\u001e:jG\"1Q\u0002 a\u0001\u0003\u0017\u00012\u0001GA\u0007\u0013\r\ty!\u0007\u0002\r\u001b\u0016$(/[2D_:4\u0017n\u001a\u0005\b\u0003'\u0001A\u0011KA\u000b\u0003Q\u0019G.[3oiJ\u000bG/Z'fiJL7MT1nKR1\u0011qCA\u0010\u0003G\u0001B!!\u0007\u0002\u001c5\t!$C\u0002\u0002\u001ei\u0011!\"T3ue&\u001cg*Y7f\u0011\u001d\t\t#!\u0005A\u0002I\nQb]1oSRL'0\u001a3Vg\u0016\u0014\bbBA\u0013\u0003#\u0001\rAM\u0001\tG2LWM\u001c;JI\"9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0012\u0001E3yK6\u0004H/T3ue&\u001cg*Y7f+\t\t9\u0002C\u0004\u00020\u0001!I!!\r\u0002!\u0015DX-\u001c9u'\u0016t7o\u001c:OC6,W#\u0001\u001a\t\u000f\u0005U\u0002\u0001\"\u0003\u00028\u0005\tb.\u00198pgR{\u0007+\u001a:dK:$\u0018mZ3\u0015\u0007y\u000bI\u0004C\u0004\u0002<\u0005M\u0002\u0019\u0001&\u0002\u000b9\fgn\\:")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final long maxThrottleTimeMs;

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    public long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    public Sensor exemptSensor() {
        return this.getOrCreateSensor(this.exemptSensorName(), this.exemptMetricName());
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public void maybeRecordAndThrottle(RequestChannel.Request request, Function1<Object, BoxedUnit> sendResponseCallback) {
        if (request.apiRemoteCompleteTimeNanos() == -1L) {
            request.apiRemoteCompleteTimeNanos_$eq(this.time().nanoseconds());
        }
        if (this.quotasEnabled()) {
            ClientSensors quotaSensors = this.getOrCreateQuotaSensors(request.session().sanitizedUser(), request.header().clientId());
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNoThrottle(quotaSensors, this.nanosToPercentage(timeNanos))));
            this.recordAndThrottleOnQuotaViolation(quotaSensors, this.nanosToPercentage(request.requestThreadTimeNanos()), sendResponseCallback);
        } else {
            sendResponseCallback.apply$mcVI$sp(0);
        }
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        block0: {
            if (!this.quotasEnabled()) break block0;
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordExempt(this.nanosToPercentage(timeNanos))));
            this.recordExempt(this.nanosToPercentage(request.requestThreadTimeNanos()));
        }
    }

    @Override
    public long throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        return package$.MODULE$.min(super.throttleTime(clientMetric, config), this.maxThrottleTimeMs());
    }

    @Override
    public MetricName clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    private MetricName exemptMetricName() {
        return this.metrics().metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
    }

    private String exemptSensorName() {
        return "exempt-" + QuotaType$Request$.MODULE$;
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientQuotaManagerConfig$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
    }
}

