/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gui.CommandThread;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.utils.StringUtils;

public class ParameterDialog {
    public static void editParameters(String string, Frame frame, String string2, String string3, CommandThread commandThread) {
        ArrayList arrayList = ParameterDialog.parseResponse(string3);
        int n = arrayList.size();
        int n2 = Math.max(1, n / 25);
        JPanel jPanel = new JPanel(new GridLayout(0, n2, 0, 2));
        for (int i = 0; i < n; ++i) {
            jPanel.add(((Parameter)arrayList.get(i)).getComponent());
        }
        Object[] objectArray = new Object[]{"Ok", "Cancel"};
        int n3 = JOptionPane.showOptionDialog(frame, jPanel, string2, 2, -1, null, objectArray, objectArray[0]);
        if (n3 != 0) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Parameter parameter = (Parameter)arrayList.get(i);
            if (!parameter.isChanged()) continue;
            String string4 = parameter.getKey();
            String string5 = parameter.getNewValue();
            if (string5.equals("") || string5.indexOf(32) >= 0) {
                string5 = "\"" + string5 + "\"";
            }
            String string6 = string + " " + string4 + " " + string5;
            try {
                commandThread.send(string6);
                continue;
            }
            catch (GtpError gtpError) {
                String string7 = "Could not change parameter " + parameter.getKey() + ":\n" + StringUtils.capitalize(gtpError.getMessage());
                SimpleDialogs.showError(frame, string7);
            }
        }
    }

    private static ArrayList parseResponse(String string) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while (true) {
            int n;
            String string2 = null;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string2 == null) break;
            string2 = string2.trim();
            boolean bl = false;
            if (string2.startsWith("[") && string2.endsWith("]")) continue;
            if (string2.startsWith("[bool]")) {
                bl = true;
                string2 = string2.replaceFirst("\\[bool\\]", "").trim();
            } else if (string2.startsWith("[string]")) {
                bl = false;
                string2 = string2.replaceFirst("\\[string\\]", "").trim();
            } else if (string2.startsWith("[")) {
                bl = false;
                n = string2.indexOf(93);
                if (n >= 0) {
                    string2 = string2.substring(n + 1).trim();
                }
            }
            n = string2.indexOf(32);
            if (n < 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (bl) {
                arrayList.add(new BoolParameter(string3, string4));
                continue;
            }
            arrayList.add(new StringParameter(string3, string4));
        }
        return arrayList;
    }

    private static class StringParameter
    extends Parameter {
        private final JTextField m_textField;
        private final JPanel m_panel = new JPanel(new GridLayout(1, 0, 5, 0));

        public StringParameter(String string, String string2) {
            super(string, string2);
            this.m_panel.add(new JLabel(this.getLabel() + ":"));
            this.m_textField = new JTextField(string2);
            this.m_panel.add(this.m_textField);
        }

        public String getNewValue() {
            return this.m_textField.getText().trim();
        }

        public boolean isChanged() {
            return !this.getNewValue().equals(this.getValue());
        }

        public Component getComponent() {
            return this.m_panel;
        }
    }

    private static class BoolParameter
    extends Parameter {
        private boolean m_bool;
        private final JCheckBox m_checkBox;
        private final JPanel m_panel;

        public BoolParameter(String string, String string2) {
            super(string, string2);
            try {
                this.m_bool = Integer.parseInt(string2) != 0;
            }
            catch (NumberFormatException numberFormatException) {
                this.m_bool = false;
            }
            this.m_panel = new JPanel(new GridLayout(1, 0, 5, 0));
            this.m_checkBox = new JCheckBox(this.getLabel(), this.m_bool);
            this.m_panel.add(this.m_checkBox);
        }

        public String getNewValue() {
            if (this.m_checkBox.isSelected()) {
                return "1";
            }
            return "0";
        }

        public boolean isChanged() {
            return this.m_checkBox.isSelected() != this.m_bool;
        }

        public Component getComponent() {
            return this.m_panel;
        }
    }

    private static abstract class Parameter {
        private final String m_key;
        private final String m_label;
        private final String m_value;

        public Parameter(String string, String string2) {
            this.m_key = string;
            this.m_value = string2;
            this.m_label = StringUtils.capitalize(string.replace('_', ' '));
        }

        public String getKey() {
            return this.m_key;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String getValue() {
            return this.m_value;
        }

        public abstract String getNewValue();

        public abstract boolean isChanged();

        public abstract Component getComponent();
    }
}

