/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.auto;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.auto.AutoSchemaReceiver;
import com.thaiopensource.validate.auto.ReparseException;
import com.thaiopensource.validate.auto.RewindableInputStream;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.auto.SchemaReceiverLoader;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AutoSchemaReader
implements SchemaReader {
    private final SchemaReceiverFactory srf;

    public AutoSchemaReader() {
        this(new SchemaReceiverLoader());
    }

    public AutoSchemaReader(SchemaReceiverFactory srf) {
        this.srf = srf == null ? new SchemaReceiverLoader() : srf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema createSchema(InputSource in, PropertyMap properties) throws IOException, SAXException, IncorrectSchemaException {
        if (SchemaReceiverFactory.PROPERTY.get(properties) != this.srf) {
            PropertyMapBuilder builder = new PropertyMapBuilder(properties);
            SchemaReceiverFactory.PROPERTY.put(builder, this.srf);
            properties = builder.toPropertyMap();
        }
        InputSource in2 = new InputSource();
        in2.setSystemId(in.getSystemId());
        in2.setPublicId(in.getPublicId());
        in2.setEncoding(in.getEncoding());
        if (in.getCharacterStream() != null) {
            throw new IllegalArgumentException("character stream input sources not supported for auto-detection");
        }
        InputStream byteStream = in.getByteStream();
        if (byteStream == null) {
            String systemId = in.getSystemId();
            if (systemId == null) {
                throw new IllegalArgumentException("null systemId and null byteStream");
            }
            byteStream = new URL(systemId).openStream();
        }
        RewindableInputStream rewindableByteStream = new RewindableInputStream(byteStream);
        in.setByteStream(rewindableByteStream);
        in2.setByteStream(rewindableByteStream);
        RewindableInputStream rewindable = rewindableByteStream;
        AutoSchemaReceiver sr = new AutoSchemaReceiver(properties, rewindable);
        XMLReaderCreator xrc = ValidateProperty.XML_READER_CREATOR.get(properties);
        XMLReader xr = xrc.createXMLReader();
        ErrorHandler eh = ValidateProperty.ERROR_HANDLER.get(properties);
        if (eh != null) {
            xr.setErrorHandler(eh);
        }
        SchemaFuture sf = sr.installHandlers(xr);
        try {
            xr.parse(in);
            Schema schema = sf.getSchema();
            rewindable.willNotRewind();
            return schema;
        }
        catch (ReparseException e) {
            try {
                rewindable.rewind();
                rewindable.willNotRewind();
                Schema schema = e.reparse(in2);
                rewindable.willNotRewind();
                return schema;
            }
            catch (Throwable throwable) {
                try {
                    rewindable.willNotRewind();
                    throw throwable;
                }
                catch (SAXException e2) {
                    Exception nested = e2.getException();
                    if (nested instanceof RuntimeException) {
                        sf.unwrapException((RuntimeException)nested);
                    }
                    throw e2;
                }
                catch (RuntimeException e3) {
                    throw sf.unwrapException(e3);
                }
            }
        }
    }

    public Option getOption(String uri) {
        return this.srf.getOption(uri);
    }
}

