/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.igoweb.go.Go;
import org.igoweb.util.CacheMap;
import org.igoweb.util.swing.Prefs;

public class StoneImages
extends Go {
    private static final int NUM_WHITE_PICS = 5;
    static final String TEXTURED_BOARD_PREF = "d][N'B&\"";
    private static final int GRID_BASE = 8;
    public static final int GRID_H_LEFT = 8;
    public static final int GRID_H_CENTER = 9;
    public static final int GRID_H_RIGHT = 10;
    public static final int GRID_V_TOP = 0;
    public static final int GRID_V_CENTER = 3;
    public static final int GRID_V_BOTTOM = 6;
    public static final int GRID_HOSHI = 17;
    private static final int NUM_GRID_PICS = 10;
    private static final int NUM_TOTAL_PICS = 18;
    protected static final int BLACK_ID = 0;
    protected static final int BLACK_TRANS_ID = 1;
    protected static final int WHITE_TRANS_ID = 2;
    private static final Random rnd = new Random();
    private static final CacheMap<Integer, StoneImages> createdImages = new CacheMap();
    private final BufferedImage[] stones = new BufferedImage[18];
    private Shape triangleMark;
    private Shape cursorMark;
    private Shape circleMark;
    private Shape squareMark;
    public final int size;
    public final boolean textured;
    protected final double dSize;
    private final Font font2;
    private final Font font3;
    public final int shadowOffset;
    private StoneImages smallImages = null;
    private static final double lightX = Math.sqrt(0.125);
    private static final double lightY = Math.sqrt(0.125);
    private static final double lightZ = Math.sqrt(0.75);
    private static final Font baseFont = new Font("SansSerif", 0, 1);
    private static final FontRenderContext baseFRC = new FontRenderContext(new AffineTransform(), true, true);
    private static final double twoDigitSize = StoneImages.calcSize("00");
    private static final double threeDigitSize = StoneImages.calcSize("000");
    public static final double shadowOffsetRatio = (1.0 - Math.sqrt(0.75)) * lightX / lightZ;

    public static StoneImages create(int size) {
        return StoneImages.create(size, Prefs.getBoolean(TEXTURED_BOARD_PREF, true));
    }

    public static StoneImages create(int size, boolean textured) {
        Integer key = new Integer(textured ? size : -size);
        StoneImages result = createdImages.get(key);
        if (result == null) {
            result = new StoneImages(size, textured);
            createdImages.put(key, result);
        }
        return result;
    }

    protected StoneImages(double size, boolean textured) {
        this.size = (int)size;
        this.textured = textured;
        this.dSize = size;
        this.shadowOffset = (int)Math.ceil(size * shadowOffsetRatio);
        this.paintImages();
        this.paintGrids();
        this.drawMarks(size);
        this.font2 = baseFont.deriveFont((float)(size * 0.9 / twoDigitSize));
        this.font3 = baseFont.deriveFont((float)(size * 0.9 / threeDigitSize));
    }

    private void paintImages() {
        int maxRadius = (this.size + 2) * (this.size + 2);
        Area stoneOutline = new Area(new Ellipse2D.Double(0.0, 0.0, this.size, this.size));
        Rectangle2D.Double fullImage = new Rectangle2D.Double(0.0, 0.0, this.size + this.shadowOffset, this.size + this.shadowOffset);
        Area stoneClip = new Area(fullImage);
        stoneClip.subtract(stoneOutline);
        BufferedImage shadowMask = new BufferedImage(this.size + this.shadowOffset, this.size + this.shadowOffset, 2);
        Graphics2D smg = shadowMask.createGraphics();
        for (int y = 0; y < this.size + this.shadowOffset; ++y) {
            for (int x = 0; x < this.size + this.shadowOffset; ++x) {
                shadowMask.setRGB(x, y, Integer.MIN_VALUE);
            }
        }
        smg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        smg.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        smg.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        smg.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        smg.setComposite(AlphaComposite.getInstance(1));
        Area shadowClip = new Area(fullImage);
        shadowClip.subtract(stoneOutline.createTransformedArea(AffineTransform.getTranslateInstance(shadowOffsetRatio * (double)this.size, shadowOffsetRatio * (double)this.size)));
        shadowClip.add(stoneOutline);
        smg.fill(shadowClip);
        for (int i = 0; i < 8; ++i) {
            this.stones[i] = new BufferedImage(this.size + this.shadowOffset, this.size + this.shadowOffset, 2);
            Graphics2D g2d = this.stones[i].createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            if (this.textured) {
                this.drawTexturedStone(this.stones[i], g2d, i, stoneClip, shadowMask, maxRadius);
                continue;
            }
            this.drawBlankStone(this.stones[i], g2d, i, stoneClip);
        }
    }

    private void drawTexturedStone(BufferedImage image, Graphics2D g2d, int imgNum, Shape stoneClip, BufferedImage shadowMask, int maxRadius) {
        int y;
        Props props = new Props(this.size);
        for (y = 0; y < this.size; ++y) {
            int yOff = this.size - (2 * y + 1);
            yOff *= yOff;
            for (int x = 0; x < this.size; ++x) {
                int color;
                int xOff = this.size - (2 * x + 1);
                if ((xOff *= xOff) + yOff > maxRadius) continue;
                switch (imgNum) {
                    case 0: {
                        color = 0xFF000000 | StoneImages.getColor(this.size, x, y, null);
                        break;
                    }
                    case 1: {
                        color = Integer.MIN_VALUE | StoneImages.getColor(this.size, x, y, null);
                        break;
                    }
                    case 2: {
                        color = Integer.MIN_VALUE | StoneImages.getColor(this.size, x, y, props);
                        break;
                    }
                    default: {
                        color = 0xFF000000 | StoneImages.getColor(this.size, x, y, props);
                    }
                }
                image.setRGB(x, y, color);
            }
        }
        g2d.setComposite(AlphaComposite.getInstance(1));
        g2d.fill(stoneClip);
        if (imgNum != 1 && imgNum != 2) {
            for (y = 0; y < this.size + this.shadowOffset; ++y) {
                for (int x = 0; x < this.size + this.shadowOffset; ++x) {
                    int shadowColor = shadowMask.getRGB(x, y);
                    if (shadowColor == 0) continue;
                    int origColor = image.getRGB(x, y);
                    int origAlpha = origColor >> 24 & 0xFF;
                    if ((shadowColor = shadowColor >> 24 & 0xFF) + origAlpha > 255) {
                        shadowColor = 255 - origAlpha;
                    }
                    int newColor = shadowColor + origAlpha << 24;
                    for (int byteNum = 0; byteNum < 3; ++byteNum) {
                        int colorEl = origColor >> byteNum * 8 & 0xFF;
                        colorEl = (colorEl * origAlpha + (origAlpha + shadowColor >> 1)) / (origAlpha + shadowColor);
                        newColor |= colorEl << byteNum * 8;
                    }
                    image.setRGB(x, y, newColor);
                }
            }
        }
    }

    private void drawBlankStone(BufferedImage image, Graphics2D g2d, int imgNum, Shape stoneClip) {
        g2d.setColor(Color.black);
        g2d.fillRect(0, 0, this.size, this.size);
        if (imgNum != 0 && imgNum != 1) {
            g2d.setColor(Color.white);
            g2d.fill(new Ellipse2D.Double((double)this.size * 0.05, (double)this.size * 0.05, (double)this.size * 0.9, (double)this.size * 0.9));
        }
        if (imgNum == 1 || imgNum == 2) {
            for (int x = 0; x < this.size; ++x) {
                for (int y = 0; y < this.size; ++y) {
                    image.setRGB(x, y, image.getRGB(x, y) & 0x80FFFFFF);
                }
            }
        }
        g2d.setComposite(AlphaComposite.getInstance(1));
        g2d.fill(stoneClip);
    }

    protected void drawMarks(double newSize) {
        this.circleMark = StoneImages.getMark(newSize, 0);
        this.cursorMark = StoneImages.getMark(newSize, 1);
        this.triangleMark = StoneImages.getMark(newSize, 3);
        this.squareMark = StoneImages.getMark(newSize, 4);
    }

    private static Shape getMark(double size, int numCorners) {
        Shape outline = null;
        double width = 0.05;
        switch (numCorners) {
            case 0: {
                outline = new Ellipse2D.Double(size * 0.25, size * 0.25, size * 0.5, size * 0.5);
                break;
            }
            case 1: {
                GeneralPath path = new GeneralPath();
                path.moveTo((float)(size * 0.25), (float)(size * 0.25));
                path.lineTo((float)(size * 0.75), (float)(size * 0.75));
                path.moveTo((float)(size * 0.25), (float)(size * 0.75));
                path.lineTo((float)(size * 0.75), (float)(size * 0.25));
                outline = path;
                break;
            }
            case 3: {
                GeneralPath path = new GeneralPath();
                double actualRadius = 0.5 - 0.025 / Math.sin(0.5235987755982988);
                path.moveTo((float)(size * 0.5), (float)(size * (0.5 - actualRadius)));
                path.lineTo((float)(size * (0.5 + actualRadius * Math.cos(5.759586531581287))), (float)(size * (0.5 - actualRadius * Math.sin(5.759586531581287))));
                path.lineTo((float)(size * (0.5 + actualRadius * Math.cos(3.665191429188092))), (float)(size * (0.5 - actualRadius * Math.sin(3.665191429188092))));
                path.closePath();
                outline = path;
                break;
            }
            case 4: {
                outline = new Rectangle2D.Double(size * (0.5 - 0.25 * Math.sqrt(2.0) + 0.025), size * (0.5 - 0.25 * Math.sqrt(2.0) + 0.025), size * (0.5 * Math.sqrt(2.0) - 0.05), size * (0.5 * Math.sqrt(2.0) - 0.05));
            }
        }
        BasicStroke stroke = new BasicStroke((float)(size * 0.05));
        return stroke.createStrokedShape(outline);
    }

    public static int getColor(int size, int x, int y, Props props) {
        int intBrightness = (int)((StoneImages.getBrightness(size, (double)x + 0.25, (double)y + 0.25, props) + StoneImages.getBrightness(size, (double)x + 0.75, (double)y + 0.25, props) + StoneImages.getBrightness(size, (double)x + 0.25, (double)y + 0.75, props) + StoneImages.getBrightness(size, (double)x + 0.75, (double)y + 0.75, props)) * 0.25);
        intBrightness = Math.min(intBrightness, 255);
        return intBrightness | intBrightness << 8 | intBrightness << 16;
    }

    public static double getBrightness(int size, double x, double y, Props props) {
        double xR = (double)size - (x + x);
        double yR = (double)size - (y + y);
        int r = size + size;
        double nz = Math.sqrt((double)(r * r) - xR * xR - yR * yR);
        double z = 1.0 - nz / (double)r;
        double lambertian = (xR * lightX + yR * lightY + nz * lightZ) / (double)r;
        double bright = 2.0 * nz * lambertian / (double)r - lightZ;
        bright *= bright;
        bright *= bright;
        if (props == null) {
            bright = bright * 165.0 + lambertian * 10.0 - 5.0;
        } else {
            bright *= bright;
            bright *= bright;
            bright *= bright;
            double wStripeLoc = x * props.cosTheta - y * props.sinTheta + props.xAdd;
            wStripeLoc += props.stripeJitter * Math.cos(wStripeLoc / 4.0);
            double wStripeColor = props.stripeWidth == 0.0 ? 1.5 : (wStripeLoc + z * z * z * props.zMul * props.stripeWidth) % props.stripeWidth / props.stripeWidth;
            if ((wStripeColor = wStripeColor * props.stripeMul - 0.5) < 0.0) {
                wStripeColor = -2.0 * wStripeColor;
            }
            if (wStripeColor > 1.0) {
                wStripeColor = 1.0;
            }
            wStripeColor = wStripeColor * 0.15 + 0.85;
            bright = bright * 70.0 + wStripeColor * (lambertian * 120.0 + 110.0);
        }
        return bright;
    }

    public static int whiteImageId() {
        return rnd.nextInt(5) + 3;
    }

    public static int whiteImageId(int baseId) {
        return baseId % 5 + 3;
    }

    public static final int transId(int color) {
        return color + 1;
    }

    public void paintStone(Graphics2D g, int color, int mark, int whiteImageId, String label, int gridType) {
        boolean hasCursor;
        boolean isDead;
        if ((mark & 0x2000) != 0) {
            color = 0;
        } else if ((mark & 0x4000) != 0) {
            color = 1;
        }
        if (gridType != 0 && (color == 2 && mark != 2 || (mark & 0xE0) != 0)) {
            g.drawImage((Image)this.stones[gridType], 0, 0, null);
        }
        int size4 = (this.size + 2) / 4;
        int phantomColor = (mark & 0x200) != 0 ? 0 : ((mark & 0x400) != 0 ? 1 : 2);
        boolean bl = isDead = (mark & 0x80) != 0;
        if ((mark & 0xE0) != 0 && phantomColor == 2) {
            phantomColor = color;
            color = 2;
        }
        boolean bl2 = hasCursor = (mark & 1) != 0;
        if (color != 2 || phantomColor != 2) {
            int picId = color == 2 ? StoneImages.transId(phantomColor) : (color == 1 ? whiteImageId : 0);
            this.drawStoneImage(g, picId);
        }
        if ((mark & 0x20) != 0) {
            if (phantomColor == 2 || color == 2) {
                this.drawSmallStoneImage(g, 0, size4);
            }
        } else if ((mark & 0x40) != 0 && (phantomColor == 2 || color == 2)) {
            this.drawSmallStoneImage(g, whiteImageId, size4);
        }
        if ((mark &= 0xFFFFF91E) != 0) {
            mark &= mark ^ mark - 1;
        }
        if (mark != 0 || hasCursor) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (isDead) {
                g.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setColor(color == 0 ? Color.white : Color.black);
            if (mark == 4096) {
                mark = 16;
            }
            switch (mark & 0xFFFFEFFE) {
                case 16: {
                    g.fill(this.circleMark);
                    break;
                }
                case 2: {
                    GlyphVector gv = (label.length() <= 2 ? this.font2 : this.font3).createGlyphVector(baseFRC, label);
                    Rectangle2D textArea = gv.getOutline().getBounds2D();
                    g.drawGlyphVector(gv, (float)(this.dSize * 0.5 - textArea.getCenterX()), (float)(this.dSize * 0.5 - textArea.getCenterY()));
                    break;
                }
                case 4: {
                    g.fill(this.triangleMark);
                    break;
                }
                case 8: 
                case 256: {
                    g.fill(this.squareMark);
                    break;
                }
                case 2048: {
                    g.fill(this.cursorMark);
                }
            }
            if (hasCursor) {
                g.fill(this.cursorMark);
            }
            if (isDead) {
                g.setComposite(AlphaComposite.SrcOver);
            }
        }
        if (phantomColor != 2 && color != 2) {
            this.drawSmallStoneImage(g, StoneImages.transId(StoneImages.opponent(color)), size4);
        }
    }

    private void createSmall() {
        int smSize = this.size - 2 * ((this.size + 2) / 4);
        if (smSize < 1) {
            smSize = 1;
        }
        this.smallImages = StoneImages.create(smSize, this.textured);
    }

    protected void drawStoneImage(Graphics2D g, int imageId) {
        g.drawImage((Image)this.stones[imageId], 0, 0, null);
    }

    protected void drawSmallStoneImage(Graphics2D g, int imageId, int offset) {
        if (this.smallImages == null) {
            this.createSmall();
        }
        g.drawImage((Image)this.smallImages.stones[imageId], offset, offset, null);
    }

    public static final int cursorMark(int color) {
        return color == 2 ? 0 : 512 << color;
    }

    public static final int territoryMark(int color) {
        if (color != 0 && color != 1) {
            throw new IllegalArgumentException("Bogus color " + color);
        }
        return 32 << color;
    }

    private static double calcSize(String text) {
        Rectangle2D bounds = baseFont.deriveFont(1000.0f).createGlyphVector(baseFRC, text).getOutline().getBounds2D();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        return Math.sqrt(w * w + h * h) / 1000.0;
    }

    private void paintGrids() {
        int i;
        Area[] grids = new Area[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            grids[i2] = new Area();
        }
        float lineW = (float)this.size / 60.0f;
        float midpoint = (float)this.size / 2.0f;
        if (lineW < 1.0f) {
            midpoint = (float)Math.floor(midpoint) + 0.5f;
        }
        Area block = new Area(new Rectangle2D.Float(0.0f, midpoint - lineW, midpoint + lineW, lineW * 2.0f));
        for (i = 0; i < 10; ++i) {
            if (i != 9 && i % 3 == 0) continue;
            grids[i].add(block);
        }
        block = new Area(new Rectangle2D.Float(midpoint - lineW, 0.0f, lineW * 2.0f, midpoint + lineW));
        for (i = 3; i < 10; ++i) {
            grids[i].add(block);
        }
        block = new Area(new Rectangle2D.Float(midpoint - lineW, midpoint - lineW, this.size, lineW * 2.0f));
        for (i = 0; i < 10; ++i) {
            if (i % 3 == 2) continue;
            grids[i].add(block);
        }
        block = new Area(new Rectangle2D.Float(midpoint - lineW, midpoint - lineW, lineW * 2.0f, this.size));
        for (i = 0; i < 10; ++i) {
            if (i / 3 == 2) continue;
            grids[i].add(block);
        }
        grids[9].add(new Area(new Ellipse2D.Double(midpoint - (lineW *= 4.5714283f), midpoint - lineW, lineW * 2.0f, lineW * 2.0f)));
        for (i = 0; i < 10; ++i) {
            BufferedImage img;
            this.stones[i + 8] = img = new BufferedImage(this.size, this.size, 2);
            Graphics2D smg = img.createGraphics();
            smg.setColor(Color.black);
            smg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            smg.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            smg.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            smg.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            smg.fill(grids[i]);
            smg.dispose();
        }
    }

    public static class Props {
        private final double cosTheta;
        private final double sinTheta;
        private final double stripeWidth;
        private final double xAdd;
        private final double stripeMul;
        private final double zMul;
        private final double stripeJitter;

        public Props(int size) {
            double minStripeW = (double)size / 20.0;
            if (size > 0 && minStripeW < 2.5) {
                minStripeW = 2.5;
            }
            double maxStripeW = (double)size / 5.0;
            if (size > 0 && maxStripeW < 4.0) {
                maxStripeW = 4.0;
            }
            double theta = rnd.nextDouble() * 2.0 * Math.PI;
            this.cosTheta = Math.cos(theta);
            this.sinTheta = Math.sin(theta);
            this.stripeWidth = minStripeW + rnd.nextDouble() * (maxStripeW - minStripeW);
            this.xAdd = rnd.nextDouble() * this.stripeWidth + (double)size * 3.0;
            this.stripeMul = size == 0 ? 1.0 : rnd.nextDouble() * 4.0 + 1.5;
            this.zMul = rnd.nextDouble() * 650.0 + 70.0;
            this.stripeJitter = 1.0 - rnd.nextDouble() * rnd.nextDouble();
        }
    }
}

