/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PStmtKey;
import org.apache.tomcat.dbcp.dbcp.PoolableCallableStatement;
import org.apache.tomcat.dbcp.dbcp.PoolablePreparedStatement;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedPoolableObjectFactory;

public class PoolingConnection
extends DelegatingConnection
implements KeyedPoolableObjectFactory<PStmtKey, DelegatingPreparedStatement> {
    protected KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> _pstmtPool = null;

    public PoolingConnection(Connection c) {
        super(c);
    }

    public PoolingConnection(Connection c, KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> pool) {
        super(c);
        this._pstmtPool = pool;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (null != this._pstmtPool) {
            KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> oldpool = this._pstmtPool;
            this._pstmtPool = null;
            try {
                oldpool.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw (SQLException)new SQLException("Cannot close connection").initCause(e);
            }
        }
        this.getInnermostDelegate().close();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql));
        }
        catch (NoSuchElementException e) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql, autoGeneratedKeys));
        }
        catch (NoSuchElementException e) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached", e).initCause(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Borrow prepareStatement from pool failed").initCause(e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency));
        }
        catch (NoSuchElementException e) {
            throw (SQLException)new SQLException("MaxOpenPreparedStatements limit reached").initCause(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw (SQLException)new SQLException("Borrow prepareStatement from pool failed").initCause(e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(sql, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql, columnIndexes));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (null == this._pstmtPool) {
            throw new SQLException("Statement pool is null - closed or invalid PoolingConnection.");
        }
        try {
            return this._pstmtPool.borrowObject(this.createKey(sql, columnNames));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenPreparedStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow prepareStatement from pool failed", e);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            return (CallableStatement)((Object)this._pstmtPool.borrowObject(this.createKey(sql, resultSetType, resultSetConcurrency, resultSetHoldability, StatementType.CALLABLE_STATEMENT)));
        }
        catch (NoSuchElementException e) {
            throw new SQLException("MaxOpenCallableStatements limit reached", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Borrow callableStatement from pool failed", e);
        }
    }

    protected PStmtKey createKey(String sql) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull());
    }

    protected PStmtKey createKey(String sql, int[] columnIndexes) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), columnIndexes);
    }

    protected PStmtKey createKey(String sql, int autoGeneratedKeys) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), autoGeneratedKeys);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, StatementType statementType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, resultSetHoldability, statementType);
    }

    protected PStmtKey createKey(String sql, int resultSetType, int resultSetConcurrency, StatementType stmtType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), resultSetType, resultSetConcurrency, stmtType);
    }

    protected PStmtKey createKey(String sql, StatementType stmtType) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), stmtType, null);
    }

    protected PStmtKey createKey(String sql, String[] columnNames) {
        return new PStmtKey(this.normalizeSQL(sql), this.getCatalogOrNull(), this.getSchemaOrNull(), columnNames);
    }

    protected String normalizeSQL(String sql) {
        return sql.trim();
    }

    private String getCatalogOrNull() {
        String catalog = null;
        try {
            catalog = this.getCatalog();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return catalog;
    }

    private String getSchemaOrNull() {
        String schema = null;
        try {
            schema = this.getSchema();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return schema;
    }

    @Override
    public DelegatingPreparedStatement makeObject(PStmtKey key) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("Prepared statement key is null.");
        }
        if (key.getStmtType() == StatementType.PREPARED_STATEMENT) {
            PreparedStatement statement = (PreparedStatement)key.createStatement(this.getDelegate());
            PoolablePreparedStatement<PStmtKey> pps = new PoolablePreparedStatement<PStmtKey>(statement, key, this._pstmtPool, this);
            return pps;
        }
        CallableStatement statement = (CallableStatement)key.createStatement(this.getDelegate());
        return new PoolableCallableStatement(statement, key, this._pstmtPool, this);
    }

    @Override
    public void destroyObject(PStmtKey key, DelegatingPreparedStatement obj) throws Exception {
        obj.getInnermostDelegate().close();
    }

    @Override
    public boolean validateObject(PStmtKey key, DelegatingPreparedStatement obj) {
        return true;
    }

    @Override
    public void activateObject(PStmtKey key, DelegatingPreparedStatement obj) throws Exception {
        obj.activate();
    }

    @Override
    public void passivateObject(PStmtKey key, DelegatingPreparedStatement obj) throws Exception {
        obj.clearParameters();
        obj.passivate();
    }

    @Override
    public String toString() {
        if (this._pstmtPool != null) {
            return "PoolingConnection: " + this._pstmtPool.toString();
        }
        return "PoolingConnection: null";
    }

    public static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

