/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.tables;

import com.google.common.collect.AbstractIterator;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.caffinitas.ohc.CacheLoader;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.CloseableIterator;
import org.caffinitas.ohc.DirectValueAccess;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;
import org.caffinitas.ohc.OHCacheStats;
import org.caffinitas.ohc.histo.EstimatedHistogram;
import org.caffinitas.ohc.tables.DirectValueAccessImpl;
import org.caffinitas.ohc.tables.HashEntries;
import org.caffinitas.ohc.tables.KeyBuffer;
import org.caffinitas.ohc.tables.Murmur3;
import org.caffinitas.ohc.tables.OffHeapMap;
import org.caffinitas.ohc.tables.Uns;
import org.caffinitas.ohc.tables.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OHCacheImpl<K, V>
implements OHCache<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OHCacheImpl.class);
    private final CacheSerializer<K> keySerializer;
    private final CacheSerializer<V> valueSerializer;
    private final OffHeapMap[] maps;
    private final long segmentMask;
    private final int segmentShift;
    private final long maxEntrySize;
    private long capacity;
    private volatile long putFailCount;
    private final boolean throwOOME;

    public OHCacheImpl(OHCacheBuilder<K, V> builder) {
        LOGGER.warn("OHC's tables implementation is deprecated and will be removed. Consider switching to linked implementation (the default).");
        if (builder.getDefaultTTLmillis() > 0L) {
            throw new IllegalArgumentException("tables implementation does not support TTLs");
        }
        long capacity = builder.getCapacity();
        if (capacity <= 0L) {
            throw new IllegalArgumentException("capacity");
        }
        this.capacity = capacity;
        this.throwOOME = builder.isThrowOOME();
        int segments = builder.getSegmentCount();
        if (segments <= 0) {
            segments = Runtime.getRuntime().availableProcessors() * 2;
        }
        segments = (int)Util.roundUpToPowerOf2(segments, 0x40000000L);
        this.maps = new OffHeapMap[segments];
        for (int i = 0; i < segments; ++i) {
            try {
                this.maps[i] = new OffHeapMap(builder, capacity / (long)segments);
                continue;
            }
            catch (RuntimeException e) {
                while (i >= 0) {
                    if (this.maps[i] != null) {
                        this.maps[i].release();
                    }
                    --i;
                }
                throw e;
            }
        }
        int bitNum = Util.bitNum(segments) - 1;
        this.segmentShift = 64 - bitNum;
        this.segmentMask = (long)segments - 1L << this.segmentShift;
        long maxEntrySize = builder.getMaxEntrySize();
        if (maxEntrySize > capacity / (long)segments) {
            throw new IllegalArgumentException("Illegal max entry size " + maxEntrySize);
        }
        if (maxEntrySize <= 0L) {
            maxEntrySize = capacity / (long)segments;
        }
        this.maxEntrySize = maxEntrySize;
        this.keySerializer = builder.getKeySerializer();
        if (this.keySerializer == null) {
            throw new NullPointerException("keySerializer == null");
        }
        this.valueSerializer = builder.getValueSerializer();
        if (this.valueSerializer == null) {
            throw new NullPointerException("valueSerializer == null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("OHC instance with {} segments and capacity of {} created.", (Object)segments, (Object)capacity);
        }
    }

    @Override
    public DirectValueAccess getDirect(K key) {
        return this.getDirect(key, true);
    }

    @Override
    public DirectValueAccess getDirect(K key, boolean updateLRU) {
        if (key == null) {
            throw new NullPointerException();
        }
        KeyBuffer keySource = this.keySource(key);
        long hashEntryAdr = this.segment(keySource.hash()).getEntry(keySource, true, updateLRU);
        if (hashEntryAdr == 0L) {
            return null;
        }
        return new DirectValueAccessImpl(hashEntryAdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        KeyBuffer keySource = this.keySource(key);
        OffHeapMap segment = this.segment(keySource.hash());
        long hashEntryAdr = segment.getEntry(keySource, true, true);
        if (hashEntryAdr == 0L) {
            return null;
        }
        try {
            V v = this.valueSerializer.deserialize(Uns.valueBufferR(hashEntryAdr));
            return v;
        }
        finally {
            HashEntries.dereference(hashEntryAdr);
        }
    }

    @Override
    public boolean containsKey(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        KeyBuffer keySource = this.keySource(key);
        return this.segment(keySource.hash()).getEntry(keySource, false, true) != 0L;
    }

    @Override
    public void put(K key, V value, long expireAt) {
        throw new UnsupportedOperationException("tables implementation does not support entry expiration");
    }

    @Override
    public boolean addOrReplace(K key, V old, V value, long expireAt) {
        throw new UnsupportedOperationException("tables implementation does not support entry expiration");
    }

    @Override
    public boolean putIfAbsent(K key, V value, long expireAt) {
        throw new UnsupportedOperationException("tables implementation does not support entry expiration");
    }

    @Override
    public void put(K k, V v) {
        this.putInternal(k, v, false, null);
    }

    @Override
    public boolean addOrReplace(K key, V old, V value) {
        return this.putInternal(key, value, false, old);
    }

    @Override
    public boolean putIfAbsent(K k, V v) {
        return this.putInternal(k, v, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putInternal(K k, V v, boolean ifAbsent, V old) {
        if (k == null || v == null) {
            throw new NullPointerException();
        }
        long keyLen = this.keySerializer.serializedSize(k);
        long valueLen = this.valueSerializer.serializedSize(v);
        long bytes = Util.allocLen(keyLen, valueLen);
        long oldValueAdr = 0L;
        long oldValueLen = 0L;
        try {
            long hashEntryAdr;
            if (old != null) {
                oldValueLen = this.valueSerializer.serializedSize(old);
                oldValueAdr = Uns.allocate(oldValueLen, this.throwOOME);
                if (oldValueAdr == 0L) {
                    throw new RuntimeException("Unable to allocate " + oldValueLen + " bytes in off-heap");
                }
                this.valueSerializer.serialize(old, Uns.directBufferFor(oldValueAdr, 0L, oldValueLen, false));
            }
            if (this.maxEntrySize > 0L && bytes > this.maxEntrySize || (hashEntryAdr = Uns.allocate(bytes, this.throwOOME)) == 0L) {
                ++this.putFailCount;
                this.remove(k);
                boolean bl = false;
                return bl;
            }
            long hash = this.serializeForPut(k, v, keyLen, valueLen, hashEntryAdr);
            HashEntries.init(hash, keyLen, valueLen, hashEntryAdr);
            if (this.segment(hash).putEntry(hashEntryAdr, hash, keyLen, bytes, ifAbsent, oldValueAdr, oldValueLen)) {
                boolean bl = true;
                return bl;
            }
            Uns.free(hashEntryAdr);
            boolean bl = false;
            return bl;
        }
        finally {
            Uns.free(oldValueAdr);
        }
    }

    private long serializeForPut(K k, V v, long keyLen, long valueLen, long hashEntryAdr) {
        try {
            this.keySerializer.serialize(k, Uns.keyBuffer(hashEntryAdr, keyLen));
            this.valueSerializer.serialize(v, Uns.valueBuffer(hashEntryAdr, keyLen, valueLen));
        }
        catch (Throwable e) {
            OHCacheImpl.freeAndThrow(e, hashEntryAdr);
        }
        return OHCacheImpl.hash(hashEntryAdr, keyLen);
    }

    private static void freeAndThrow(Throwable e, long hashEntryAdr) {
        Uns.free(hashEntryAdr);
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    @Override
    public void remove(K k) {
        if (k == null) {
            throw new NullPointerException();
        }
        KeyBuffer key = this.keySource(k);
        this.segment(key.hash()).removeEntry(key);
    }

    @Override
    public V getWithLoader(K key, CacheLoader<K, V> loader) throws InterruptedException, ExecutionException {
        return this.getWithLoaderAsync(key, loader).get();
    }

    @Override
    public V getWithLoader(K key, CacheLoader<K, V> loader, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getWithLoaderAsync(key, loader).get(timeout, unit);
    }

    @Override
    public Future<V> getWithLoaderAsync(K key, CacheLoader<K, V> loader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<V> getWithLoaderAsync(K key, CacheLoader<K, V> loader, long expireAt) {
        throw new UnsupportedOperationException();
    }

    private OffHeapMap segment(long hash) {
        int seg = (int)((hash & this.segmentMask) >>> this.segmentShift);
        return this.maps[seg];
    }

    private KeyBuffer keySource(K o) {
        int size = this.keySerializer.serializedSize(o);
        ByteBuffer key = ByteBuffer.allocate(size);
        this.keySerializer.serialize(o, key);
        assert (key.position() == key.capacity() && key.capacity() == size);
        return new KeyBuffer(key.array()).finish();
    }

    @Override
    public void clear() {
        for (OffHeapMap map : this.maps) {
            map.clear();
        }
    }

    @Override
    public void setCapacity(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException();
        }
        long oldPerSegment = this.capacity / (long)this.segments();
        this.capacity = capacity;
        long perSegment = capacity / (long)this.segments();
        long diff = perSegment - oldPerSegment;
        for (OffHeapMap map : this.maps) {
            map.updateFreeCapacity(diff);
        }
    }

    @Override
    public void close() {
        this.clear();
        for (OffHeapMap map : this.maps) {
            map.release();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing OHC instance");
        }
    }

    @Override
    public void resetStatistics() {
        for (OffHeapMap map : this.maps) {
            map.resetStatistics();
        }
        this.putFailCount = 0L;
    }

    @Override
    public OHCacheStats stats() {
        long rehashes = 0L;
        for (OffHeapMap map : this.maps) {
            rehashes += map.rehashes();
        }
        return new OHCacheStats(this.hitCount(), this.missCount(), this.evictedEntries(), 0L, this.perSegmentSizes(), this.size(), this.capacity(), this.freeCapacity(), rehashes, this.putAddCount(), this.putReplaceCount(), this.putFailCount, this.removeCount(), Uns.getTotalAllocated(), this.lruCompactions());
    }

    private long putAddCount() {
        long putAddCount = 0L;
        for (OffHeapMap map : this.maps) {
            putAddCount += map.putAddCount();
        }
        return putAddCount;
    }

    private long putReplaceCount() {
        long putReplaceCount = 0L;
        for (OffHeapMap map : this.maps) {
            putReplaceCount += map.putReplaceCount();
        }
        return putReplaceCount;
    }

    private long removeCount() {
        long removeCount = 0L;
        for (OffHeapMap map : this.maps) {
            removeCount += map.removeCount();
        }
        return removeCount;
    }

    private long hitCount() {
        long hitCount = 0L;
        for (OffHeapMap map : this.maps) {
            hitCount += map.hitCount();
        }
        return hitCount;
    }

    private long missCount() {
        long missCount = 0L;
        for (OffHeapMap map : this.maps) {
            missCount += map.missCount();
        }
        return missCount;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long freeCapacity() {
        long freeCapacity = 0L;
        for (OffHeapMap map : this.maps) {
            freeCapacity += map.freeCapacity();
        }
        return freeCapacity;
    }

    public long evictedEntries() {
        long evictedEntries = 0L;
        for (OffHeapMap map : this.maps) {
            evictedEntries += map.evictedEntries();
        }
        return evictedEntries;
    }

    @Override
    public long size() {
        long size = 0L;
        for (OffHeapMap map : this.maps) {
            size += map.size();
        }
        return size;
    }

    public long lruCompactions() {
        long lruCompactions = 0L;
        for (OffHeapMap map : this.maps) {
            lruCompactions += map.lruCompactions();
        }
        return lruCompactions;
    }

    @Override
    public int segments() {
        return this.maps.length;
    }

    @Override
    public float loadFactor() {
        return this.maps[0].loadFactor();
    }

    @Override
    public int[] hashTableSizes() {
        int[] r = new int[this.maps.length];
        for (int i = 0; i < this.maps.length; ++i) {
            r[i] = this.maps[i].hashTableSize();
        }
        return r;
    }

    @Override
    public long[] perSegmentSizes() {
        long[] r = new long[this.maps.length];
        for (int i = 0; i < this.maps.length; ++i) {
            r[i] = this.maps[i].size();
        }
        return r;
    }

    @Override
    public EstimatedHistogram getBucketHistogram() {
        int i;
        EstimatedHistogram hist = new EstimatedHistogram();
        for (OffHeapMap map : this.maps) {
            map.updateBucketHistogram(hist);
        }
        long[] offsets = hist.getBucketOffsets();
        long[] buckets = hist.getBuckets(false);
        for (i = buckets.length - 1; i > 0; --i) {
            if (buckets[i] == 0L) continue;
            offsets = Arrays.copyOf(offsets, i + 2);
            buckets = Arrays.copyOf(buckets, i + 3);
            System.arraycopy(offsets, 0, offsets, 1, i + 1);
            System.arraycopy(buckets, 0, buckets, 1, i + 2);
            offsets[0] = 0L;
            buckets[0] = 0L;
            break;
        }
        i = 0;
        while (i < offsets.length) {
            int n = i++;
            offsets[n] = offsets[n] - 1L;
        }
        return new EstimatedHistogram(offsets, buckets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseableIterator<K> deserializeKeys(final ReadableByteChannel channel) throws IOException {
        long headerAddress = Uns.allocateIOException(8L);
        try {
            ByteBuffer header = Uns.directBufferFor(headerAddress, 0L, 8L, false);
            Util.readFully(channel, header);
            header.flip();
            int magic = header.getInt();
            if (magic == 1262700623) {
                throw new IOException("File from instance with different CPU architecture cannot be loaded");
            }
            if (magic == 1330135877) {
                throw new IOException("File contains entries - expected keys");
            }
            if (magic != 1330135883) {
                throw new IOException("Illegal file header");
            }
            if (header.getInt() != 1) {
                throw new IOException("Illegal file version");
            }
        }
        finally {
            Uns.free(headerAddress);
        }
        return new CloseableIterator<K>(){
            private K next;
            private boolean eod;
            private final byte[] keyLenBuf = new byte[8];
            private final ByteBuffer bb = ByteBuffer.wrap(this.keyLenBuf);
            private long bufAdr;
            private long bufLen;

            @Override
            public void close() {
                Uns.free(this.bufAdr);
                this.bufAdr = 0L;
            }

            protected void finalize() throws Throwable {
                this.close();
                super.finalize();
            }

            @Override
            public boolean hasNext() {
                if (this.eod) {
                    return false;
                }
                if (this.next == null) {
                    this.checkNext();
                }
                return this.next != null;
            }

            private void checkNext() {
                try {
                    this.bb.clear();
                    if (!Util.readFully(channel, this.bb)) {
                        this.eod = true;
                        return;
                    }
                    long keyLen = Uns.getLongFromByteArray(this.keyLenBuf, 0);
                    long totalLen = 40L + keyLen;
                    if (this.bufLen < totalLen) {
                        Uns.free(this.bufAdr);
                        this.bufAdr = 0L;
                        this.bufLen = Math.max(4096L, Util.roundUpToPowerOf2(totalLen, 0x40000000L));
                        this.bufAdr = Uns.allocateIOException(this.bufLen);
                    }
                    if (!Util.readFully(channel, Uns.directBufferFor(this.bufAdr, 40L, keyLen, false))) {
                        this.eod = true;
                        throw new EOFException();
                    }
                    HashEntries.init(0L, keyLen, 0L, this.bufAdr);
                    this.next = OHCacheImpl.this.keySerializer.deserialize(Uns.keyBufferR(this.bufAdr));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public K next() {
                if (this.eod) {
                    throw new NoSuchElementException();
                }
                Object r = this.next;
                if (r == null) {
                    this.checkNext();
                    r = this.next;
                }
                if (r == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean deserializeEntry(ReadableByteChannel channel) throws IOException {
        long hashEntryAdr;
        long kvLen;
        byte[] hashKeyValueLen = new byte[24];
        ByteBuffer bb = ByteBuffer.wrap(hashKeyValueLen);
        if (!Util.readFully(channel, bb)) {
            return false;
        }
        long hash = Uns.getLongFromByteArray(hashKeyValueLen, 0);
        long valueLen = Uns.getLongFromByteArray(hashKeyValueLen, 8);
        long keyLen = Uns.getLongFromByteArray(hashKeyValueLen, 16);
        long totalLen = kvLen + 40L;
        if (this.maxEntrySize > 0L && totalLen > this.maxEntrySize || (hashEntryAdr = Uns.allocate(totalLen, this.throwOOME)) == 0L) {
            if (channel instanceof SeekableByteChannel) {
                SeekableByteChannel sc = (SeekableByteChannel)channel;
                sc.position(sc.position() + kvLen);
            } else {
                ByteBuffer tmp = ByteBuffer.allocate(8192);
                for (kvLen = Util.roundUpTo8(keyLen) + valueLen; kvLen > 0L; kvLen -= (long)tmp.limit()) {
                    tmp.clear();
                    if (kvLen < (long)tmp.capacity()) {
                        tmp.limit((int)kvLen);
                    }
                    if (Util.readFully(channel, tmp)) continue;
                    return false;
                }
            }
            return false;
        }
        HashEntries.init(hash, keyLen, valueLen, hashEntryAdr);
        if (!Util.readFully(channel, Uns.directBufferFor(hashEntryAdr, 40L, kvLen, false)) || !this.segment(hash).putEntry(hashEntryAdr, hash, keyLen, totalLen, false, 0L, 0L)) {
            Uns.free(hashEntryAdr);
            return false;
        }
        return true;
    }

    @Override
    public boolean serializeEntry(K key, WritableByteChannel channel) throws IOException {
        KeyBuffer keySource = this.keySource(key);
        OffHeapMap segment = this.segment(keySource.hash());
        long hashEntryAdr = segment.getEntry(keySource, true, true);
        return hashEntryAdr != 0L && OHCacheImpl.serializeEntry(channel, hashEntryAdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deserializeEntries(ReadableByteChannel channel) throws IOException {
        long headerAddress = Uns.allocateIOException(8L);
        try {
            ByteBuffer header = Uns.directBufferFor(headerAddress, 0L, 8L, false);
            Util.readFully(channel, header);
            header.flip();
            int magic = header.getInt();
            if (magic == 1162037327) {
                throw new IOException("File from instance with different CPU architecture cannot be loaded");
            }
            if (magic == 1330135883) {
                throw new IOException("File contains keys - expected entries");
            }
            if (magic != 1330135877) {
                throw new IOException("Illegal file header");
            }
            if (header.getInt() != 1) {
                throw new IOException("Illegal file version");
            }
        }
        finally {
            Uns.free(headerAddress);
        }
        int count = 0;
        while (this.deserializeEntry(channel)) {
            ++count;
        }
        return count;
    }

    @Override
    public int serializeHotNEntries(int n, WritableByteChannel channel) throws IOException {
        return this.serializeHotN(n, channel, true);
    }

    @Override
    public int serializeHotNKeys(int n, WritableByteChannel channel) throws IOException {
        return this.serializeHotN(n, channel, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int serializeHotN(int n, WritableByteChannel channel, boolean entries) throws IOException {
        long headerAddress = Uns.allocateIOException(8L);
        try {
            ByteBuffer headerBuffer = Uns.directBufferFor(headerAddress, 0L, 8L, false);
            headerBuffer.putInt(entries ? 1330135877 : 1330135883);
            headerBuffer.putInt(1);
            headerBuffer.flip();
            Util.writeFully(channel, headerBuffer);
        }
        finally {
            Uns.free(headerAddress);
        }
        int perMap = n / this.maps.length + 1;
        int cnt = 0;
        for (OffHeapMap map : this.maps) {
            long[] hotPerMap = map.hotN(perMap);
            try {
                for (int i = 0; i < hotPerMap.length; ++i) {
                    long hashEntryAdr = hotPerMap[i];
                    if (hashEntryAdr == 0L) continue;
                    try {
                        if (entries) {
                            OHCacheImpl.serializeEntry(channel, hashEntryAdr);
                        } else {
                            OHCacheImpl.serializeKey(channel, hashEntryAdr);
                        }
                    }
                    finally {
                        hotPerMap[i] = 0L;
                    }
                    ++cnt;
                }
            }
            finally {
                for (long hashEntryAdr : hotPerMap) {
                    if (hashEntryAdr == 0L) continue;
                    HashEntries.dereference(hashEntryAdr);
                }
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean serializeEntry(WritableByteChannel channel, long hashEntryAdr) throws IOException {
        try {
            long keyLen = HashEntries.getKeyLen(hashEntryAdr);
            long valueLen = HashEntries.getValueLen(hashEntryAdr);
            long totalLen = 24L + Util.roundUpTo8(keyLen) + valueLen;
            Util.writeFully(channel, Uns.directBufferFor(hashEntryAdr, 16L, totalLen, false));
            boolean bl = true;
            return bl;
        }
        finally {
            HashEntries.dereference(hashEntryAdr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean serializeKey(WritableByteChannel channel, long hashEntryAdr) throws IOException {
        try {
            long keyLen = HashEntries.getKeyLen(hashEntryAdr);
            long totalLen = 8L + keyLen;
            Util.writeFully(channel, Uns.directBufferFor(hashEntryAdr, 32L, totalLen, false));
            boolean bl = true;
            return bl;
        }
        finally {
            HashEntries.dereference(hashEntryAdr);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void removeAll(Iterable<K> iterable) {
        for (K o : iterable) {
            this.remove(o);
        }
    }

    @Override
    public long memUsed() {
        return this.capacity() - this.freeCapacity();
    }

    @Override
    public CloseableIterator<K> hotKeyIterator(int n) {
        return new AbstractHotKeyIterator<K>(n){

            @Override
            K buildResult(long hashEntryAdr) {
                return OHCacheImpl.this.keySerializer.deserialize(Uns.keyBufferR(hashEntryAdr));
            }
        };
    }

    @Override
    public CloseableIterator<ByteBuffer> hotKeyBufferIterator(int n) {
        return new AbstractHotKeyIterator<ByteBuffer>(n){

            @Override
            ByteBuffer buildResult(long hashEntryAdr) {
                return Uns.directBufferFor(hashEntryAdr, 40L, HashEntries.getKeyLen(hashEntryAdr), false);
            }
        };
    }

    @Override
    public CloseableIterator<K> keyIterator() {
        return new AbstractKeyIterator<K>(){

            @Override
            K buildResult(long hashEntryAdr) {
                return OHCacheImpl.this.keySerializer.deserialize(Uns.keyBufferR(hashEntryAdr));
            }
        };
    }

    @Override
    public CloseableIterator<ByteBuffer> keyBufferIterator() {
        return new AbstractKeyIterator<ByteBuffer>(){

            @Override
            ByteBuffer buildResult(long hashEntryAdr) {
                return Uns.directBufferFor(hashEntryAdr, 40L, HashEntries.getKeyLen(hashEntryAdr), false);
            }
        };
    }

    public static long hash(long blkAdr, long keyLen) {
        long k2;
        long k1;
        long r;
        long o = 40L;
        long h1 = 0L;
        long h2 = 0L;
        for (r = keyLen; r >= 16L; r -= 16L) {
            k1 = OHCacheImpl.getLong(blkAdr, o);
            k2 = OHCacheImpl.getLong(blkAdr, o += 8L);
            o += 8L;
            h1 ^= Murmur3.mixK1(k1);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            h2 ^= Murmur3.mixK2(k2);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        if (r > 0L) {
            k1 = 0L;
            k2 = 0L;
            switch ((int)r) {
                case 15: {
                    k2 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 14L)) << 48;
                }
                case 14: {
                    k2 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 13L)) << 40;
                }
                case 13: {
                    k2 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 12L)) << 32;
                }
                case 12: {
                    k2 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 11L)) << 24;
                }
                case 11: {
                    k2 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 10L)) << 16;
                }
                case 10: {
                    k2 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 9L)) << 8;
                }
                case 9: {
                    k2 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 8L));
                }
                case 8: {
                    k1 ^= OHCacheImpl.getLong(blkAdr, o);
                    break;
                }
                case 7: {
                    k1 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 6L)) << 48;
                }
                case 6: {
                    k1 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 5L)) << 40;
                }
                case 5: {
                    k1 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 4L)) << 32;
                }
                case 4: {
                    k1 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 3L)) << 24;
                }
                case 3: {
                    k1 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 2L)) << 16;
                }
                case 2: {
                    k1 ^= Murmur3.toLong(Uns.getByte(blkAdr, o + 1L)) << 8;
                }
                case 1: {
                    k1 ^= Murmur3.toLong(Uns.getByte(blkAdr, o));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
            h1 ^= Murmur3.mixK1(k1);
            h2 ^= Murmur3.mixK2(k2);
        }
        h1 ^= keyLen;
        h1 += (h2 ^= keyLen);
        h2 += h1;
        h1 = Murmur3.fmix64(h1);
        h2 = Murmur3.fmix64(h2);
        return h1 += h2;
    }

    private static long getLong(long blkAdr, long o) {
        long l = Murmur3.toLong(Uns.getByte(blkAdr, o + 7L)) << 56;
        l |= Murmur3.toLong(Uns.getByte(blkAdr, o + 6L)) << 48;
        l |= Murmur3.toLong(Uns.getByte(blkAdr, o + 5L)) << 40;
        l |= Murmur3.toLong(Uns.getByte(blkAdr, o + 4L)) << 32;
        l |= Murmur3.toLong(Uns.getByte(blkAdr, o + 3L)) << 24;
        l |= Murmur3.toLong(Uns.getByte(blkAdr, o + 2L)) << 16;
        l |= Murmur3.toLong(Uns.getByte(blkAdr, o + 1L)) << 8;
        return l |= Murmur3.toLong(Uns.getByte(blkAdr, o));
    }

    private abstract class AbstractHotKeyIterator<R>
    extends AbstractIterator<R>
    implements CloseableIterator<R> {
        private final int perMap;
        int mapIndex;
        long[] hotPerMap;
        int subIndex;
        long lastHashEntryAdr;

        public AbstractHotKeyIterator(int n) {
            this.perMap = n / OHCacheImpl.this.maps.length + 1;
        }

        private void derefLast() {
            if (this.lastHashEntryAdr != 0L) {
                HashEntries.dereference(this.lastHashEntryAdr);
                this.lastHashEntryAdr = 0L;
            }
        }

        @Override
        public void close() {
            this.derefLast();
            while (this.hotPerMap != null && this.subIndex < this.hotPerMap.length) {
                long hashEntryAdr;
                if ((hashEntryAdr = this.hotPerMap[this.subIndex++]) == 0L) continue;
                HashEntries.dereference(hashEntryAdr);
            }
        }

        abstract R buildResult(long var1);

        protected R computeNext() {
            this.derefLast();
            while (true) {
                long hashEntryAdr;
                if (this.hotPerMap != null && this.subIndex < this.hotPerMap.length && (hashEntryAdr = this.hotPerMap[this.subIndex++]) != 0L) {
                    this.lastHashEntryAdr = hashEntryAdr;
                    return this.buildResult(hashEntryAdr);
                }
                if (this.mapIndex == OHCacheImpl.this.maps.length) {
                    return (R)this.endOfData();
                }
                this.hotPerMap = OHCacheImpl.this.maps[this.mapIndex++].hotN(this.perMap);
                this.subIndex = 0;
            }
        }
    }

    private abstract class AbstractKeyIterator<R>
    implements CloseableIterator<R> {
        private int segmentIndex;
        private OffHeapMap segment;
        private int mapSegmentCount;
        private int mapSegmentIndex;
        private final List<Long> hashEntryAdrs = new ArrayList<Long>(1024);
        private int listIndex;
        private boolean eod;
        private R next;
        private OffHeapMap lastSegment;
        private long lastHashEntryAdr;

        private AbstractKeyIterator() {
        }

        private void derefLast() {
            if (this.lastHashEntryAdr != 0L) {
                HashEntries.dereference(this.lastHashEntryAdr);
                this.lastHashEntryAdr = 0L;
                this.lastSegment = null;
            }
        }

        @Override
        public void close() {
            this.derefLast();
            while (this.listIndex < this.hashEntryAdrs.size()) {
                long hashEntryAdr = this.hashEntryAdrs.get(this.listIndex++);
                HashEntries.dereference(hashEntryAdr);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.eod) {
                return false;
            }
            if (this.next == null) {
                this.next = this.computeNext();
            }
            return this.next != null;
        }

        @Override
        public R next() {
            if (this.eod) {
                throw new NoSuchElementException();
            }
            if (this.next == null) {
                this.next = this.computeNext();
            }
            R r = this.next;
            this.next = null;
            if (!this.eod) {
                return r;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.eod) {
                throw new NoSuchElementException();
            }
            this.lastSegment.removeEntry(this.lastHashEntryAdr);
            this.derefLast();
        }

        private R computeNext() {
            this.derefLast();
            while (true) {
                if (this.listIndex < this.hashEntryAdrs.size()) {
                    long hashEntryAdr = this.hashEntryAdrs.get(this.listIndex++);
                    this.lastSegment = this.segment;
                    this.lastHashEntryAdr = hashEntryAdr;
                    return this.buildResult(hashEntryAdr);
                }
                if (this.mapSegmentIndex >= this.mapSegmentCount) {
                    if (this.segmentIndex == OHCacheImpl.this.maps.length) {
                        this.eod = true;
                        return null;
                    }
                    this.segment = OHCacheImpl.this.maps[this.segmentIndex++];
                    this.mapSegmentCount = this.segment.hashTableSize();
                    this.mapSegmentIndex = 0;
                }
                if (this.listIndex != this.hashEntryAdrs.size()) continue;
                this.hashEntryAdrs.clear();
                this.segment.getEntryAddresses(this.mapSegmentIndex, 1024, this.hashEntryAdrs);
                this.mapSegmentIndex += 1024;
                this.listIndex = 0;
            }
        }

        abstract R buildResult(long var1);
    }
}

