/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionTask;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.compaction.writers.MajorLeveledCompactionWriter;
import org.apache.cassandra.db.compaction.writers.MaxSSTableSizeWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.io.sstable.format.SSTableReader;

public class LeveledCompactionTask
extends CompactionTask {
    private final int level;
    private final long maxSSTableBytes;
    private final boolean majorCompaction;

    public LeveledCompactionTask(ColumnFamilyStore cfs, LifecycleTransaction txn, int level, int gcBefore, long maxSSTableBytes, boolean majorCompaction) {
        super(cfs, txn, gcBefore, false);
        this.level = level;
        this.maxSSTableBytes = maxSSTableBytes;
        this.majorCompaction = majorCompaction;
    }

    @Override
    public CompactionAwareWriter getCompactionAwareWriter(ColumnFamilyStore cfs, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        if (this.majorCompaction) {
            return new MajorLeveledCompactionWriter(cfs, txn, nonExpiredSSTables, this.maxSSTableBytes, false, this.compactionType);
        }
        return new MaxSSTableSizeWriter(cfs, txn, nonExpiredSSTables, this.maxSSTableBytes, this.getLevel(), false, this.compactionType);
    }

    @Override
    protected boolean partialCompactionsAcceptable() {
        return this.level == 0;
    }

    @Override
    protected int getLevel() {
        return this.level;
    }
}

