/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.omegat.gui.dialogs.PasswordSetPanel;
import org.omegat.util.CredentialsManager;
import org.omegat.util.OStrings;
import org.omegat.util.gui.StaticUIUtils;

public class PasswordSetDialogController {
    private char[] password;
    private boolean shouldGenerate;

    public void show(Window parent) {
        final JDialog dialog = new JDialog(parent);
        dialog.setTitle(OStrings.getString("PASSWORD_DIALOG_TITLE"));
        dialog.setModal(true);
        StaticUIUtils.setWindowIcon(dialog);
        StaticUIUtils.setEscapeClosable(dialog);
        final PasswordSetPanel panel = new PasswordSetPanel();
        dialog.getContentPane().add(panel);
        dialog.getRootPane().setDefaultButton(panel.okButton);
        panel.okButton.addActionListener(e -> {
            char[] entered = panel.passwordField.getPassword();
            char[] confirmed = panel.confirmPasswordField.getPassword();
            if (entered.length == 0) {
                panel.errorTextArea.setText(OStrings.getString("PASSWORD_ERROR_EMPTY"));
            } else if (confirmed.length == 0) {
                panel.errorTextArea.setText(OStrings.getString("PASSWORD_ERROR_CONFIRMATION_EMPTY"));
            } else if (Arrays.equals(entered, confirmed)) {
                panel.errorTextArea.setText(null);
                this.password = entered;
                this.shouldGenerate = false;
                StaticUIUtils.closeWindowByEvent(dialog);
            } else {
                panel.errorTextArea.setText(OStrings.getString("PASSWORD_ERROR_NO_MATCH"));
            }
        });
        panel.cancelButton.addActionListener(e -> StaticUIUtils.closeWindowByEvent(dialog));
        panel.doNotSetButton.addActionListener(e -> {
            String cancel = OStrings.getString("PASSWORD_CONFIRM_NOT_SET_BUTTON_CANCEL");
            String confirm = OStrings.getString("PASSWORD_CONFIRM_NOT_SET_BUTTON_OK");
            Object[] options = new String[]{cancel, confirm};
            if (1 == JOptionPane.showOptionDialog(dialog, OStrings.getString("PASSWORD_CONFIRM_NOT_SET_MESSAGE"), OStrings.getString("TF_WARNING"), 0, 2, null, options, cancel)) {
                this.password = null;
                this.shouldGenerate = true;
                StaticUIUtils.closeWindowByEvent(dialog);
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                dialog.pack();
                panel.passwordField.requestFocusInWindow();
            }
        });
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    public CredentialsManager.PasswordSetResult getResult() {
        return new CredentialsManager.PasswordSetResult(this.getResponseType(), this.password);
    }

    private CredentialsManager.ResponseType getResponseType() {
        if (this.password != null) {
            return CredentialsManager.ResponseType.USE_INPUT;
        }
        if (this.shouldGenerate) {
            return CredentialsManager.ResponseType.GENERATE_AND_STORE;
        }
        return CredentialsManager.ResponseType.CANCEL;
    }
}

