/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import java.io.Serializable;
import java.util.OptionalLong;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.util.Language;

public abstract class BaseCachedTranslate
extends BaseTranslate
implements IMachineTranslation {
    private static final int SIZE_OF_CACHE = 1000;
    protected final Cache<String, String> cache = this.getCacheLayer(this.getName());

    protected Cache<String, String> getCacheLayer(String name) {
        Cache<String, String> caffeineCache = this.getCaffeineCache(name, 1000, Duration.ONE_DAY);
        CoreEvents.registerProjectChangeListener(eventType -> {
            if (eventType.equals((Object)IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE)) {
                caffeineCache.clear();
            }
        });
        return caffeineCache;
    }

    protected Cache<String, String> getCaffeineCache(String name, int sizeOfCache, Duration duration) {
        CachingProvider provider = Caching.getCachingProvider();
        CacheManager manager = provider.getCacheManager();
        Cache cache1 = manager.getCache(name);
        if (cache1 != null) {
            return cache1;
        }
        CaffeineConfiguration config = new CaffeineConfiguration();
        config.setExpiryPolicyFactory((Factory & Serializable)() -> new CreatedExpiryPolicy(duration));
        config.setMaximumSize(OptionalLong.of(sizeOfCache));
        return manager.createCache(name, (Configuration)config);
    }

    @Override
    public final String getTranslation(Language sLang, Language tLang, String text) throws Exception {
        if (this.enabled) {
            return this.translate(sLang, tLang, text);
        }
        return null;
    }

    @Override
    public final String getCachedTranslation(Language sLang, Language tLang, String text) {
        if (this.enabled) {
            return this.getCache(sLang, tLang, text);
        }
        return null;
    }

    @Override
    protected abstract String getPreferenceName();

    @Override
    protected abstract String translate(Language var1, Language var2, String var3) throws Exception;

    private String getCache(Language sLang, Language tLang, String text) {
        return (String)this.cache.get((Object)(sLang + "/" + tLang + "/" + text));
    }

    private String putCache(Language sLang, Language tLang, String text, String result) {
        if (result != null) {
            this.cache.put((Object)(sLang.toString() + "/" + tLang.toString() + "/" + text), (Object)result);
        }
        return result;
    }

    @Override
    protected String getFromCache(Language sLang, Language tLang, String text) {
        return this.getCache(sLang, tLang, text);
    }

    @Override
    protected String putToCache(Language sLang, Language tLang, String text, String result) {
        return this.putCache(sLang, tLang, text, result);
    }

    @Override
    protected void clearCache() {
        this.cache.clear();
    }
}

