/*
 * Decompiled with CFR 0.152.
 */
package org.jmeld.ui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.jmeld.settings.JMeldSettings;
import org.jmeld.ui.FilePanel;
import org.jmeld.ui.util.ColorUtil;
import org.jmeld.ui.util.Colors;

public class LineNumberBorder
extends EmptyBorder {
    private static int MARGIN = 4;
    private FilePanel filePanel;
    private Color background;
    private Color lineColor;
    private Font font;
    private int fontWidth;
    private int fontHeight;
    private boolean enableBlame = true;

    public LineNumberBorder(FilePanel filePanel) {
        super(0, 40 + MARGIN, 0, 0);
        this.filePanel = filePanel;
        this.init();
    }

    public void enableBlame(boolean enableBlame) {
        this.enableBlame = enableBlame;
    }

    private void init() {
        Color baseColor = Colors.getPanelBackground();
        this.lineColor = ColorUtil.darker(baseColor);
        this.background = ColorUtil.brighter(baseColor);
        this.font = new Font("Monospaced", 0, 10);
        FontMetrics fm = this.filePanel.getEditor().getFontMetrics(this.font);
        this.fontWidth = fm.stringWidth("0");
        this.fontHeight = fm.getHeight();
    }

    public void paintBefore(Graphics g) {
        Rectangle clip = g.getClipBounds();
        g.setColor(this.background);
        g.fillRect(0, clip.y, this.left - MARGIN, clip.y + clip.height);
    }

    public void paintAfter(Graphics g, int startOffset, int endOffset) {
        Graphics2D g2 = (Graphics2D)g;
        Rectangle clip = g.getClipBounds();
        try {
            JTextArea textArea = this.filePanel.getEditor();
            int startLine = textArea.getLineOfOffset(startOffset);
            int endLine = textArea.getLineOfOffset(endOffset);
            Rectangle r1 = textArea.modelToView(startOffset);
            int y = r1.y;
            int lineHeight = r1.height;
            int heightCorrection = (lineHeight - this.fontHeight) / 2;
            g.setColor(this.lineColor);
            g.drawLine(this.left - MARGIN, clip.y, this.left - MARGIN, clip.y + clip.height);
            if (JMeldSettings.getInstance().getEditor().isAntialiasEnabled()) {
                // empty if block
            }
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setFont(this.font);
            g.setColor(Color.black);
            for (int line = startLine; line <= endLine; ++line) {
                String s = Integer.toString(line + 1);
                g.drawString(s, this.left - this.fontWidth * s.length() - 1 - MARGIN, (y += lineHeight) - heightCorrection);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

