/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddUniqueConstraintDialog;

public class AddUniqueConstraintCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(AddUniqueConstraintCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddUniqueConstraintCommand.class);
    protected AddUniqueConstraintDialog customDialog;
    private HashMap<String, TableColumnInfo> columnMap = new HashMap();

    public AddUniqueConstraintCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        this.showCustomDialog();
    }

    protected void showCustomDialog() throws SQLException {
        ITableInfo selectedTable = (ITableInfo)this._info[0];
        TableColumnInfo[] tableColumnInfos = this._session.getMetaData().getColumnInfo(selectedTable);
        TreeSet<String> localColumns = new TreeSet<String>();
        for (TableColumnInfo column : tableColumnInfos) {
            this.columnMap.put(column.getColumnName(), column);
            localColumns.add(column.getColumnName());
        }
        this.customDialog = new AddUniqueConstraintDialog(selectedTable.getSimpleName(), localColumns.toArray(new String[0]));
        this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(this.customDialog));
        this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, this.customDialog));
        this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setVisible(true);
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this._info[0].getCatalogName(), this._info[0].getSchemaName());
        List<String> columnNames = this.customDialog.getUniqueColumns();
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        for (String columnName : columnNames) {
            columns.add(this.columnMap.get(columnName));
        }
        String[] result = this._dialect.getAddUniqueConstraintSQL(this._info[0].getSimpleName(), this.customDialog.getConstraintName(), columns.toArray(new TableColumnInfo[0]), qualifier, this._sqlPrefs);
        return result;
    }

    @Override
    protected void executeScript(String script) {
        AbstractRefactoringCommand.CommandExecHandler handler = new AbstractRefactoringCommand.CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AddUniqueConstraintCommand.this.customDialog.setVisible(false);
                        AddUniqueConstraintCommand.this.customDialog.dispose();
                        AddUniqueConstraintCommand.this._session.getSchemaInfo().reload(AddUniqueConstraintCommand.this._info[0]);
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        return dialect.supportsAddUniqueConstraint();
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = AddUniqueConstraintCommand.access$000().getString("AddUniqueConstraintCommand.sqlDialogTitle");
    }
}

