/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    private ColorSpace srccs;
    private ColorSpace dstcs;
    private RenderingHints hints;
    private ICC_Profile[] profiles;
    private ColorSpace[] spaces;
    private boolean rasterValid;

    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        ColorModel scm;
        if (dst == null && this.spaces.length == 0) {
            throw new IllegalArgumentException();
        }
        if (((BufferedImage)src).isAlphaPremultiplied()) {
            BufferedImage tmp = this.createCompatibleDestImage((BufferedImage)src, ((BufferedImage)src).getColorModel());
            this.copyimage((BufferedImage)src, tmp);
            tmp.coerceData(false);
            src = scm;
        }
        scm = ((BufferedImage)src).getColorModel();
        int i = 0;
        while (i < this.spaces.length) {
            ColorModel cm = scm.cloneColorModel(this.spaces[i]);
            BufferedImage tmp = this.createCompatibleDestImage((BufferedImage)src, cm);
            this.copyimage((BufferedImage)src, tmp);
            src = tmp;
            ++i;
        }
        if (dst == null) {
            return src;
        }
        this.copyimage((BufferedImage)src, dst);
        return dst;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel dstCM) {
        return new BufferedImage(dstCM, src.getRaster().createCompatibleWritableRaster(), src.isPremultiplied, null);
    }

    public final ICC_Profile[] getICC_Profiles() {
        return this.profiles;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final WritableRaster filter(Raster src, WritableRaster dest) {
        if (!this.rasterValid) {
            throw new IllegalArgumentException();
        }
        int i = 1;
        while (i < this.spaces.length - 1) {
            WritableRaster tmp = this.createCompatibleDestRaster(src);
            this.copyraster(src, this.spaces[i - 1], tmp, this.spaces[i]);
            src = tmp;
            ++i;
        }
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        }
        this.copyraster(src, this.spaces[this.spaces.length - 2], dest, this.spaces[this.spaces.length - 1]);
        return dest;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster();
    }

    public final Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }

    public final Rectangle2D getBounds2D(BufferedImage src) {
        return src.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    private final void copyimage(BufferedImage src, BufferedImage dst) {
        Graphics2D gg = dst.createGraphics();
        gg.setRenderingHints(this.hints);
        gg.drawImage((Image)src, 0, 0, null);
        gg.dispose();
    }

    private final void copyraster(Raster src, ColorSpace scs, WritableRaster dst, ColorSpace dcs) {
        float[] sbuf = new float[src.getNumBands()];
        if (this.hints.get(RenderingHints.KEY_COLOR_RENDERING) == RenderingHints.VALUE_COLOR_RENDER_QUALITY) {
            int y = src.getMinY();
            while (y < src.getHeight() + src.getMinY()) {
                int x = src.getMinX();
                while (x < src.getWidth() + src.getMinX()) {
                    dst.setPixel(x, y, dcs.fromCIEXYZ(scs.toCIEXYZ(src.getPixel(x, y, sbuf))));
                    ++x;
                }
                ++y;
            }
        } else {
            int y = src.getMinY();
            while (y < src.getHeight() + src.getMinY()) {
                int x = src.getMinX();
                while (x < src.getWidth() + src.getMinX()) {
                    dst.setPixel(x, y, dcs.fromRGB(scs.toRGB(src.getPixel(x, y, sbuf))));
                    ++x;
                }
                ++y;
            }
        }
    }

    public ColorConvertOp(ColorSpace cspace, RenderingHints hints) {
        if (cspace == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{cspace};
        this.hints = hints;
        this.rasterValid = false;
    }

    public ColorConvertOp(ColorSpace srcCspace, ColorSpace dstCspace, RenderingHints hints) {
        if (srcCspace == null || dstCspace == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{srcCspace, dstCspace};
        this.hints = hints;
    }

    public ColorConvertOp(ICC_Profile[] profiles, RenderingHints hints) {
        if (profiles == null) {
            throw new NullPointerException();
        }
        this.hints = hints;
        this.profiles = profiles;
        this.spaces = new ColorSpace[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            this.spaces[i] = new ICC_ColorSpace(profiles[i]);
            ++i;
        }
    }

    public ColorConvertOp(RenderingHints hints) {
        this.hints = hints;
        this.srccs = null;
        this.dstcs = null;
        this.rasterValid = false;
    }
}

