/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.locale;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocaleHelper {
    public static String getLocalizedString(Locale inLocale, String key, String name, boolean checkEnglish, boolean checkRoot) {
        String localizedString;
        if (key.equals("")) {
            return "";
        }
        String property = name + '.' + key;
        try {
            localizedString = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", inLocale).getString(property);
        }
        catch (MissingResourceException exception) {
            localizedString = null;
        }
        if (localizedString == null) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation");
                localizedString = bundle.getString(property);
            }
            catch (MissingResourceException exception) {
                localizedString = null;
            }
        }
        if (localizedString == null && checkEnglish) {
            try {
                localizedString = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", Locale.ENGLISH).getString(property);
            }
            catch (MissingResourceException exception) {
                localizedString = null;
            }
        }
        if (localizedString == null && checkRoot) {
            try {
                localizedString = ResourceBundle.getBundle("gnu.java.locale.LocaleInformation", new Locale("", "", "")).getString(property);
            }
            catch (MissingResourceException exception) {
                localizedString = null;
            }
        }
        if (localizedString == null) {
            localizedString = key;
        }
        return localizedString;
    }
}

