/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.i18n.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.i18n.I18nProvider;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

public class I18nYAMLAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        YAMLFile yamlFile;
        if (psiElement == null) {
            I18nYAMLAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            I18nYAMLAnnotator.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof YAMLFile && I18nProvider.isLocaleFile((PsiFile)(yamlFile = (YAMLFile)psiElement))) {
            I18nYAMLAnnotator.annotateYAMLLocaleFile(yamlFile, holder);
        }
    }

    private static void annotateYAMLLocaleFile(YAMLFile yamlFile, AnnotationHolder holder) {
        List documents = yamlFile.getDocuments();
        int documentsSize = documents.size();
        if (documentsSize != 1) {
            if (documentsSize == 0) {
                holder.createErrorAnnotation((PsiElement)yamlFile, RBundle.message((String)"annotator.rails.i18n.locale.file.wrong.format"));
            }
            for (YAMLDocument document : documents) {
                holder.createErrorAnnotation(PsiTreeUtil.getDeepestFirst((PsiElement)document), RBundle.message((String)"annotator.rails.i18n.locale.file.should.have.single.root"));
            }
            return;
        }
        YAMLDocument document = (YAMLDocument)documents.get(0);
        YAMLValue value = document.getTopLevelValue();
        if (!(value instanceof YAMLMapping)) {
            holder.createErrorAnnotation(PsiTreeUtil.getDeepestFirst((PsiElement)document), RBundle.message((String)"annotator.rails.i18n.locale.file.wrong.format"));
            return;
        }
        if (((YAMLMapping)value).getKeyValues().size() > 1) {
            holder.createErrorAnnotation(PsiTreeUtil.getDeepestFirst((PsiElement)value), RBundle.message((String)"annotator.rails.i18n.locale.file.should.have.single.root"));
            return;
        }
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)((YAMLMapping)value).getKeyValues().iterator().next();
        String key = yamlKeyValue.getKeyText();
        if (!yamlFile.getName().contains(key)) {
            YAMLKeyValue errorElement = yamlKeyValue.getKey() != null ? yamlKeyValue.getKey() : yamlKeyValue;
            holder.createWarningAnnotation((PsiElement)errorElement, RBundle.message((String)"annotator.rails.i18n.locale.file.name", (Object[])new Object[]{key}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/i18n/annotator/I18nYAMLAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

