/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.remote;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.ssh.RSyncUtil;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.SftpException;
import com.jetbrains.plugins.remotesdk.CredentialsDeployable;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkTransfer;
import org.jetbrains.plugins.ruby.ruby.RubyUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class RubySshRemoteTransfer
extends RemoteTransfer
implements RubyRemoteSdkTransfer {
    private static final Logger LOG = Logger.getInstance(RubySshRemoteTransfer.class);
    private static final Function<String, String> APPEND_RB_FOLDER = input -> {
        if (StringUtil.isEmpty((String)input)) {
            return null;
        }
        return input + "/rb";
    };
    private static final Function<PathMappingSettings.PathMapping, DeploymentPathMapping> PATH_MAPPING_TO_DEPLOYMENT_MAPPING = pathMapping -> {
        assert (pathMapping != null);
        DeploymentPathMapping mapping = new DeploymentPathMapping();
        mapping.setDeployPath(pathMapping.getRemoteRoot());
        mapping.setLocalPath(pathMapping.getLocalRoot());
        return mapping;
    };

    public RubySshRemoteTransfer(@Nullable Project project, @NotNull RemoteSdkCredentials data) {
        if (data == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(0);
        }
        super(project, null, data);
        LOG.assertTrue(project == null || !project.isDefault(), (Object)"Must not use a default project for remote transfer");
    }

    private static String getRemoteHelpersPath(@NotNull RemoteSdkProperties data) {
        if (data == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(1);
        }
        return (String)APPEND_RB_FOLDER.apply((Object)data.getHelpersPath());
    }

    public static Collection<String> getHelpersPaths() {
        return Collections2.transform((Collection)RubyUtil.getScriptBasePaths(), APPEND_RB_FOLDER);
    }

    @NotNull
    public static PathMappingSettings getHelpersMappings(@NotNull RemoteSdkProperties data) {
        if (data == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(2);
        }
        String remotePath = RubySshRemoteTransfer.getRemoteHelpersPath(data);
        PathMappingSettings mappingSettings = new PathMappingSettings();
        for (String localPath : RubySshRemoteTransfer.getHelpersPaths()) {
            mappingSettings.addMapping(localPath, remotePath);
        }
        PathMappingSettings pathMappingSettings = mappingSettings;
        if (pathMappingSettings == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(3);
        }
        return pathMappingSettings;
    }

    @Override
    public void uploadHelpers() throws ExecutionException {
        LOG.info("Uploading helpers");
        if (RSyncUtil.canUseRSync()) {
            this.uploadHelpersWithRSync();
        } else {
            this.uploadHelpers(true, RubySshRemoteTransfer.getHelpersPaths(), RubySshRemoteTransfer.getRemoteHelpersPath((RemoteSdkProperties)this.getRemoteSdkCredentials()), RBundle.message((String)"upload.helpers"));
        }
        LOG.info("Helpers uploaded");
    }

    private void uploadHelpersWithRSync() throws ExecutionException {
        Ref error = new Ref();
        Task process = this.createTask(this.getProject(), RBundle.message((String)"upload.helpers"), true, indicator -> {
            RemoteSdkCredentials credentials = this.getRemoteSdkCredentials();
            try {
                for (String localHelperPath : RubySshRemoteTransfer.getHelpersPaths()) {
                    RSyncUtil.uploadWithRSync((String)localHelperPath, (String)RubySshRemoteTransfer.getRemoteHelpersPath((RemoteSdkProperties)credentials), (RemoteCredentials)credentials, (ProgressIndicator)indicator);
                }
            }
            catch (ExecutionException e) {
                error.set((Object)e);
            }
        });
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ProgressManager.getInstance().run(process));
        } else {
            process.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!error.isNull()) {
            throw (ExecutionException)((Object)error.get());
        }
    }

    @Override
    public void updateLocalGemsCopy(@NotNull Sdk sdk, @NotNull List<PathMappingSettings.PathMapping> pathMappings, @NotNull ProgressIndicator indicator) throws RemoteSdkException {
        if (sdk == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(4);
        }
        if (pathMappings == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(5);
        }
        if (indicator == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(6);
        }
        LOG.info("Updating gems' local copy");
        CredentialsDeployable deployable = new CredentialsDeployable((RemoteCredentials)this.getRemoteSdkCredentials());
        deployable.setId("Download Dir" + deployable.toString());
        try {
            RemoteTransfer.RemoteSdkExecutionContext context = this.createCopyGemContext(indicator, (Deployable)deployable, indicator.getText(), pathMappings);
            try {
                if (RSyncUtil.canUseRSync()) {
                    RSyncUtil.download(pathMappings, (RemoteCredentials)this.getRemoteSdkCredentials(), (ProgressIndicator)context.getProgressIndicator());
                } else {
                    RubySshRemoteTransfer.copyLocations(sdk, context, RubySshRemoteTransfer.convertMappingsToLocation(pathMappings));
                }
            }
            catch (ExecutionException e) {
                throw new RemoteSdkException("Can't copy gems", (Throwable)e);
            }
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            PublishUtils.showLoginDialogAfterAuthFail((Throwable)e, (Deployable)deployable);
        }
    }

    @NotNull
    private static List<String> convertMappingsToLocation(@NotNull List<PathMappingSettings.PathMapping> pathMappings) {
        if (pathMappings == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(7);
        }
        ArrayList locations = Lists.newArrayList();
        for (PathMappingSettings.PathMapping pathMapping : pathMappings) {
            locations.add(new File(pathMapping.getLocalRoot()).getAbsolutePath());
        }
        ArrayList arrayList = locations;
        if (arrayList == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private RemoteTransfer.RemoteSdkExecutionContext createCopyGemContext(@NotNull ProgressIndicator indicator, @NotNull Deployable deployable, @NotNull String title, @NotNull List<PathMappingSettings.PathMapping> pathMappings) throws FileSystemException {
        if (indicator == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(9);
        }
        if (deployable == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(10);
        }
        if (title == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(11);
        }
        if (pathMappings == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(12);
        }
        RemoteConnection connection = RSyncUtil.canUseRSync() ? null : this.openConnection(title, deployable, indicator);
        RemoteTransfer.RemoteSdkExecutionContext context = this.getRemoteSdkExecutionContext(indicator, connection, deployable);
        context.setServerSideModification(false);
        context.setPromptForOverwrite(true);
        PublishConfig publishConfig = context.getConfig();
        publishConfig.setStopOnFirstError(false);
        publishConfig.setCreateEmptyDirectories(true);
        publishConfig.setOverwriteAll(false);
        publishConfig.setPromptOnLocalOverwrite(false);
        publishConfig.setDeleteMissingItems(true);
        publishConfig.setPathMappings(deployable.getId(), Lists.transform(pathMappings, PATH_MAPPING_TO_DEPLOYMENT_MAPPING));
        publishConfig.setExcludeMask(publishConfig.getExcludeMask().replace(".git;", "").replace(";.git", ""));
        return context;
    }

    private static synchronized void copyLocations(@NotNull Sdk sdk, @NotNull RemoteTransfer.RemoteSdkExecutionContext context, @NotNull List<String> locations) throws FileSystemException {
        if (sdk == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(13);
        }
        if (context == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(14);
        }
        if (locations == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(15);
        }
        RubySdkUtil.checkIfRubySdkDisposed((Sdk)sdk);
        TransferTask.ListBased.ResultWithErrors resultWithErrors = RubySshRemoteTransfer.scanFiles((ExecutionContext)context, locations);
        for (TransferOperation operation : Lists.newArrayList((Iterable)resultWithErrors.operations)) {
            RubySdkUtil.checkIfRubySdkDisposed((Sdk)sdk);
            context.getProgressIndicator().checkCanceled();
            context.getProgressIndicator().setText(operation.getProgressText((ExecutionContext)context));
            try {
                operation.execute((ExecutionContext)context);
            }
            catch (FileSystemException e) {
                if (RubySshRemoteTransfer.isPermissionDenied(e)) {
                    LOG.warn("Permission denied", (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
    }

    private static boolean isPermissionDenied(@NotNull FileSystemException e) {
        if (e == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(16);
        }
        return e.getCause() instanceof FileSystemException && e.getCause().getCause() instanceof SftpException && ((SftpException)e.getCause().getCause()).id == 3;
    }

    @NotNull
    private static TransferTask.ListBased.ResultWithErrors scanFiles(@NotNull ExecutionContext context, @NotNull Collection<String> roots) throws FileSystemException {
        if (context == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(17);
        }
        if (roots == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(18);
        }
        ArrayList result = Lists.newArrayList();
        DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
        for (String root : roots) {
            DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processIncoming((FileObject)DeploymentPathUtils.getLocalFile((String)root), (ExecutionContext)context, (List)result);
            errors.addAll(e);
        }
        TransferTask.ListBased.ResultWithErrors resultWithErrors = new TransferTask.ListBased.ResultWithErrors((List)result, errors);
        if (resultWithErrors == null) {
            RubySshRemoteTransfer.$$$reportNull$$$0(19);
        }
        return resultWithErrors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/remote/RubySshRemoteTransfer";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 5: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/remote/RubySshRemoteTransfer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpersMappings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMappingsToLocation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "scanFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteHelpersPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHelpersMappings";
                break;
            }
            case 3: 
            case 8: 
            case 19: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateLocalGemsCopy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertMappingsToLocation";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCopyGemContext";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyLocations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPermissionDenied";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "scanFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

