/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.facet;

import b.h.la;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.generators.GeneratorsModuleCache;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfiguration;
import org.jetbrains.plugins.ruby.rails.facet.configuration.BaseRailsFacetConfigurationLowLevel;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.facet.ui.wizard.RailsWizardSettingsHolder;
import org.jetbrains.plugins.ruby.rails.facet.versions.BaseRailsFacet;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RunContentDescriptorFactory;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.tasks.rake.RakeTaskModuleCache;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

public class BaseRailsFacetBuilder {
    private static final Logger a;
    private static final long b;

    private BaseRailsFacetBuilder() {
    }

    public static void constructOrInitFacetInstance(BaseRailsFacet railsFacet, @Nullable Sdk rubySdk, boolean isConstructorContext) {
        BaseRailsFacetConfigurationLowLevel baseRailsFacetConfigurationLowLevel = (BaseRailsFacetConfigurationLowLevel)railsFacet.getConfiguration();
        baseRailsFacetConfigurationLowLevel.setSdk(rubySdk);
        Module module = railsFacet.getModule();
        if (!baseRailsFacetConfigurationLowLevel.isInitialized()) {
            if (!isConstructorContext) {
                baseRailsFacetConfigurationLowLevel.setInitialized();
            }
            if (module.isLoaded()) {
                if (isConstructorContext) {
                    BaseRailsFacetBuilder.constructGreenhornFacetForLoadedModuleInstance(railsFacet, rubySdk);
                } else {
                    BaseRailsFacetBuilder.configureRailsSourcePaths(baseRailsFacetConfigurationLowLevel, module, rubySdk);
                    if (RailsUtil.containsRailsApp(baseRailsFacetConfigurationLowLevel.getNullableRailsApplicationRootPath())) {
                        BaseRailsFacetBuilder.configureRakeTasksAndGenerators(railsFacet);
                    }
                }
            } else if (baseRailsFacetConfigurationLowLevel.getNullableRailsApplicationRootPath() != null) {
                Runnable runnable = isConstructorContext ? () -> BaseRailsFacetBuilder.configureRailsSourcePaths(baseRailsFacetConfigurationLowLevel, module, rubySdk) : () -> BaseRailsFacetBuilder.regenerateGeneratorsSettings(module, baseRailsFacetConfigurationLowLevel.getSdk());
                StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(runnable);
            }
        } else if (!baseRailsFacetConfigurationLowLevel.wereTestSourcesPatched()) {
            StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(() -> {
                RailsApp railsApp = RailsApp.fromModule(module);
                if (railsApp != null) {
                    ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                    ContentEntry[] contentEntryArray = modifiableRootModel.getContentEntries();
                    if (contentEntryArray.length > 0) {
                        BaseRailsFacetBuilder.a(contentEntryArray[0], ((BaseRailsFacetConfiguration)railsFacet.getConfiguration()).getPaths());
                    }
                    WriteAction.run(() -> modifiableRootModel.commit());
                }
            });
        }
        baseRailsFacetConfigurationLowLevel.setTestSourcesPatched(true);
    }

    public static void constructGreenhornFacetForLoadedModuleInstance(BaseRailsFacet railsFacet, @Nullable Sdk rubySdk) {
        String string;
        long l2 = b ^ 0x1CB1B2C5C975L;
        BaseRailsFacetConfigurationLowLevel baseRailsFacetConfigurationLowLevel = (BaseRailsFacetConfigurationLowLevel)railsFacet.getConfiguration();
        final Module module = railsFacet.getModule();
        Project project = module.getProject();
        assert (!baseRailsFacetConfigurationLowLevel.isInitialized());
        assert (module.isLoaded());
        final Ref ref = new Ref();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        String string2 = baseRailsFacetConfigurationLowLevel.getNullableRailsApplicationRootPath();
        if (string2 != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            string = VirtualFileUtil.constructLocalUrl(string2);
        } else if (baseRailsFacetConfigurationLowLevel.getNullableRailsApplicationRootUrl() != null) {
            string = baseRailsFacetConfigurationLowLevel.getRailsApplicationRootUrl();
        } else {
            ProgressManager.getInstance().run((Task)new Task.Modal(project, RBundle.message((String)"rails.facet.builder.rails.application.searching"), true){
                private static final long a = la.a(-439227595017641462L, 1253082350642201276L, MethodHandles.lookup().lookupClass()).a(84105597593248L);

                public void run(@NotNull ProgressIndicator indicator) {
                    long l2 = a ^ 0x166D81B95A52L;
                    if (indicator == null) {
                        1.a(0);
                    }
                    indicator.setText(RBundle.message((String)"progress.indicator.title.directories.scanning"));
                    indicator.setText2(RBundle.message((String)"progress.indicator.title.please.wait"));
                    ref.set((Object)BaseRailsFacetBuilder.a(module, indicator));
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x21E1684C114AL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/rails/facet/BaseRailsFacetBuilder$1", "run"));
                }
            });
            if (ref.get() != null) {
                string = VirtualFileUtil.constructLocalUrl((String)ref.get());
            } else {
                String string3 = railsFacet.getDefaultRailsApplicationHomePath((ModuleRootModel)moduleRootManager);
                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                fileChooserDescriptor.setTitle(RBundle.message((String)"rails.facet.builder.rails.application.choose.title"));
                fileChooserDescriptor.setDescription(RBundle.message((String)"rails.facet.builder.rails.application.choose.relative.path"));
                fileChooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)module);
                fileChooserDescriptor.setRoots(new VirtualFile[]{LocalFileSystem.getInstance().findFileByPath(string3)});
                fileChooserDescriptor.withTreeRootVisible(true);
                FileChooserDialogImpl fileChooserDialogImpl = new FileChooserDialogImpl(fileChooserDescriptor, project);
                VirtualFile[] virtualFileArray = fileChooserDialogImpl.choose(project, new VirtualFile[0]);
                string = virtualFileArray.length > 0 ? virtualFileArray[0].getUrl() : VirtualFileUtil.constructLocalUrl(string3);
            }
        }
        BaseRailsFacetBuilder.initGreenhornFacetConfiguration(string, rubySdk, (BaseRailsFacetConfiguration)railsFacet.getConfiguration());
    }

    public static void initGreenhornFacetConfiguration(@NotNull String applicationHomeUrl, @Nullable Sdk sdk, @NotNull BaseRailsFacetConfiguration configuration) {
        if (applicationHomeUrl == null) {
            BaseRailsFacetBuilder.a(0);
        }
        if (configuration == null) {
            BaseRailsFacetBuilder.a(1);
        }
        BaseRailsFacetConfigurationLowLevel baseRailsFacetConfigurationLowLevel = (BaseRailsFacetConfigurationLowLevel)configuration;
        baseRailsFacetConfigurationLowLevel.setRailsApplicationRootUrl(applicationHomeUrl);
        baseRailsFacetConfigurationLowLevel.setSdk(sdk);
    }

    public static void setupGreenhornFacet(Module module, BaseRailsFacet railsFacet, ModifiableRootModel rootModel, @NotNull RailsWizardSettingsHolder settings) {
        ContentEntry[] contentEntryArray;
        if (settings == null) {
            BaseRailsFacetBuilder.a(2);
        }
        Sdk sdk = settings.getSdk();
        String string = RailsFacetUtil.getRailsAppHomeDirPath(module);
        assert (string != null);
        if (sdk != null) {
            BaseRailsFacetBuilder.a(module, railsFacet, sdk, settings, string);
        }
        if ((contentEntryArray = rootModel.getContentEntries()).length > 0) {
            BaseRailsFacetBuilder.a(contentEntryArray[0], ((BaseRailsFacetConfiguration)railsFacet.getConfiguration()).getPaths());
        }
        if (module.getUserData(RailsUtil.GENERATE_RAILS_VERSION) == null) {
            module.putUserData(RailsUtil.GENERATE_RAILS_VERSION, (Object)settings.getRailsVersion());
        }
        if (!PlatformUtils.isRubyMine()) {
            RailsUtil.createRailsRunConfiguration(module);
        }
        RModuleUtil.getInstance().refreshRubyModuleTypeContent(module);
    }

    private static void a(@NotNull ContentEntry contentEntry, @NotNull StandardRailsPaths standardRailsPaths) {
        if (contentEntry == null) {
            BaseRailsFacetBuilder.a(3);
        }
        if (standardRailsPaths == null) {
            BaseRailsFacetBuilder.a(4);
        }
        contentEntry.addSourceFolder(standardRailsPaths.getTestsStdUnitRootURL(), true);
        contentEntry.addSourceFolder(standardRailsPaths.getTestsSpecRootURL(), true);
    }

    private static void a(@NotNull Module module, @NotNull BaseRailsFacet baseRailsFacet, @NotNull Sdk sdk, @NotNull RailsWizardSettingsHolder railsWizardSettingsHolder, @NotNull String string) {
        if (module == null) {
            BaseRailsFacetBuilder.a(5);
        }
        if (baseRailsFacet == null) {
            BaseRailsFacetBuilder.a(6);
        }
        if (sdk == null) {
            BaseRailsFacetBuilder.a(7);
        }
        if (railsWizardSettingsHolder == null) {
            BaseRailsFacetBuilder.a(8);
        }
        if (string == null) {
            BaseRailsFacetBuilder.a(9);
        }
        String string2 = module.getName();
        Project project = module.getProject();
        Runnable runnable = () -> {
            if (module == null) {
                BaseRailsFacetBuilder.a(16);
            }
            if (sdk == null) {
                BaseRailsFacetBuilder.a(17);
            }
            if (railsWizardSettingsHolder == null) {
                BaseRailsFacetBuilder.a(18);
            }
            if (string == null) {
                BaseRailsFacetBuilder.a(19);
            }
            if (baseRailsFacet == null) {
                BaseRailsFacetBuilder.a(20);
            }
            RunContentDescriptorFactory.PinTabsFactory pinTabsFactory = new RunContentDescriptorFactory.PinTabsFactory();
            BaseRailsFacetBuilder.a(module, sdk, (RunContentDescriptorFactory)pinTabsFactory, railsWizardSettingsHolder, string, BaseRailsFacetBuilder.a(pinTabsFactory, module, sdk, baseRailsFacet, project, string2));
        };
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL));
    }

    private static Runnable a(RunContentDescriptorFactory.PinTabsFactory pinTabsFactory, Module module, Sdk sdk, BaseRailsFacet baseRailsFacet, Project project, String string) {
        return () -> {
            BaseRailsFacetBuilder.regenerateGeneratorsSettings(module, sdk);
            try {
                pinTabsFactory.unpinAll();
                BaseRailsFacetBuilder.regenerateGeneratorsSettings(module, sdk);
                if (!module.isDisposed()) {
                    RakeTaskModuleCache.getInstance(module).reloadTasks(true, sdk);
                }
                RailsFacetUtil.refreshRailsAppHomeContent(module);
                BaseRailsFacetBuilder.configureRailsSourcePaths((BaseRailsFacetConfiguration)baseRailsFacet.getConfiguration(), module, sdk);
            }
            catch (Exception exception) {
                BaseRailsFacetBuilder.a(exception, project, string);
            }
        };
    }

    public static void regenerateGeneratorsSettings(Module module, @Nullable Sdk sdk) {
        if (module.isDisposed()) {
            return;
        }
        GeneratorsModuleCache.getInstance(module).reloadGenerators(true, sdk, true);
    }

    private static void a(Module module, @Nullable Sdk sdk) {
        GeneratorsModuleCache.getInstance(module).reloadGenerators(false, sdk, true);
    }

    private static void a(Module module, @NotNull Sdk sdk, RunContentDescriptorFactory runContentDescriptorFactory, @NotNull RailsWizardSettingsHolder railsWizardSettingsHolder, @NotNull String string, @Nullable Runnable runnable) {
        int n2;
        long l2 = b ^ 0x10DE09876BFL;
        if (sdk == null) {
            BaseRailsFacetBuilder.a(10);
        }
        if (railsWizardSettingsHolder == null) {
            BaseRailsFacetBuilder.a(11);
        }
        if (string == null) {
            BaseRailsFacetBuilder.a(12);
        }
        String string2 = railsWizardSettingsHolder.getDBNameToPreconfigure();
        String string3 = railsWizardSettingsHolder.getRailsVersion();
        String string4 = railsWizardSettingsHolder.getRailsTemplate();
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        boolean bl2 = virtualFile != null && virtualFile.isDirectory() && RailsUtil.containsRailsApp(string) ? (n2 = Messages.showYesNoDialog((Project)module.getProject(), (String)RBundle.message((String)"module.rails.generateapp.rails.new.overwrite.message", (Object[])new Object[]{string}), (String)RBundle.message((String)"module.rails.generateapp.rails.new.overwrite.title"), (Icon)Messages.getQuestionIcon())) == 0 : false;
        RailsUtil.generateRailsApp(module, sdk, string, bl2, string3, string4, railsWizardSettingsHolder.shouldSkipTestUnitFiles(), railsWizardSettingsHolder.isGenerateEngine(), railsWizardSettingsHolder.isGenerateApi(), railsWizardSettingsHolder.getJavaScriptLibrary(), string2, runContentDescriptorFactory, runnable);
    }

    private static void a(Exception exception, Project project, String string) {
        long l2 = b ^ 0x68DA91C112E0L;
        String string2 = RBundle.message((String)"module.create.dialog.init.errors.title", (Object[])new Object[]{string});
        RunnerUtil.showErrorMessage(project, string2, exception);
        a.warn((Throwable)exception);
    }

    public static void configureRakeTasksAndGenerators(Facet facet) {
        Module module = facet.getModule();
        Runnable runnable = BaseRailsFacetBuilder.a(module);
        StartupManager.getInstance((Project)module.getProject()).runWhenProjectIsInitialized(runnable);
    }

    private static Runnable a(Module module) {
        return () -> BaseRailsFacetBuilder.a(module, RModuleUtil.getInstance().findRubySdkForModule(module));
    }

    @Nullable
    private static String a(@NotNull Module module, @NotNull ProgressIndicator progressIndicator) {
        if (module == null) {
            BaseRailsFacetBuilder.a(13);
        }
        if (progressIndicator == null) {
            BaseRailsFacetBuilder.a(14);
        }
        Ref ref = new Ref();
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        moduleFileIndex.iterateContent(virtualFile -> {
            String string;
            if (progressIndicator == null) {
                BaseRailsFacetBuilder.a(15);
            }
            if (progressIndicator.isCanceled()) {
                return false;
            }
            if (virtualFile.isDirectory() && RailsUtil.containsRailsApp(string = virtualFile.getPath())) {
                ref.set((Object)string);
                return false;
            }
            return true;
        });
        return (String)ref.get();
    }

    public static void configureRailsSourcePaths(BaseRailsFacetConfiguration conf, final Module module, @Nullable Sdk sdk) {
        if (module.isDisposed()) {
            return;
        }
        final Runnable runnable = () -> {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            WriteAction.runAndWait(() -> {
                long l2 = b ^ 0x3F800115080L;
                ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                ContentEntry[] contentEntryArray = modifiableRootModel.getContentEntries();
                if (contentEntryArray.length == 0) {
                    modifiableRootModel.dispose();
                    return;
                }
                String string = conf.getRailsApplicationRootUrl();
                ContentEntry contentEntry = BaseRailsFacetBuilder.a(string, contentEntryArray);
                if (contentEntry == null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Unable to find rails app in content roots.\nRails app home: ").append(string).append(", Entries: [");
                    for (ContentEntry contentEntry2 : contentEntryArray) {
                        stringBuilder.append(contentEntry2.getUrl());
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("]");
                    a.error((Object)stringBuilder);
                    return;
                }
                BaseRailsFacetBuilder.a(string, contentEntry);
                Runnable runnable = () -> RbenvGemsetManager.addRbenvLocalGemsetsExcludedFolders(module, sdk, contentEntry);
                Project project = module.getProject();
                if (!project.isDisposed()) {
                    if (project.isInitialized()) {
                        runnable.run();
                    } else {
                        StartupManager.getInstance((Project)project).registerPostStartupActivity(runnable);
                    }
                }
                BaseRailsFacetBuilder.a(contentEntry, conf.getPaths());
                modifiableRootModel.commit();
            });
        };
        if (module.isLoaded()) {
            runnable.run();
        } else {
            final MessageBusConnection messageBusConnection = module.getMessageBus().connect();
            messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){
                private static final long a = la.a(-3438872273883441244L, 3706051749740846300L, MethodHandles.lookup().lookupClass()).a(251347668874211L);

                public void moduleAdded(@NotNull Project project, @NotNull Module addedModule) {
                    if (project == null) {
                        2.a(0);
                    }
                    if (addedModule == null) {
                        2.a(1);
                    }
                    if (module.equals(addedModule)) {
                        messageBusConnection.disconnect();
                        runnable.run();
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    long l2 = a ^ 0x56C3CAF39E1EL;
                    Object[] objectArray2 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "project";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "addedModule";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/ruby/rails/facet/BaseRailsFacetBuilder$2";
                    objectArray[2] = "moduleAdded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Nullable
    private static ContentEntry a(String string, ContentEntry[] contentEntryArray) {
        ContentEntry contentEntry = null;
        for (ContentEntry contentEntry2 : contentEntryArray) {
            if (!string.contains(contentEntry2.getUrl())) continue;
            contentEntry = contentEntry2;
            break;
        }
        return contentEntry;
    }

    private static void a(String string, ContentEntry contentEntry) {
        long l2 = b ^ 0x2E8158569204L;
        String string2 = StandardRailsPaths.buildComponentsUrl(string);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(string, ".bundle"));
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(string, "vendor/bundle"));
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(string, "vendor/cache"));
        contentEntry.addExcludeFolder(VirtualFileUtil.buildUrl(string, "log"));
        contentEntry.addExcludeFolder(StandardRailsPaths.buildTmpUrl(string));
        contentEntry.addExcludeFolder(StandardRailsPaths.buildPublicSystemUrl(string));
        contentEntry.addExcludeFolder(string2);
        String string3 = StandardRailsPaths.buildEdgeRailsUrl(string);
        VirtualFile virtualFile = virtualFileManager.findFileByUrl(string3);
        if (virtualFile != null) {
            for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                VirtualFile virtualFile3 = virtualFile2.findChild("test");
                if (virtualFile3 == null) continue;
                contentEntry.addExcludeFolder(virtualFile3);
            }
        }
    }

    static {
        b = la.a(-4035188542230379753L, 7077299455334066997L, MethodHandles.lookup().lookupClass()).a(218301762781279L);
        a = Logger.getInstance(BaseRailsFacetBuilder.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x5E42F6177AC6L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationHomeUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uncommittedModule";
                break;
            }
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsFacet";
                break;
            }
            case 7: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 9: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicationHomePath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rails/facet/BaseRailsFacetBuilder";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "initGreenhornFacetConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setupGreenhornFacet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addTestRoots";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "installComponents";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "generateRailsApplication";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "searchRailsAppInUnderDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$searchRailsAppInUnderDirectory$8";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$installComponents$4";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

