/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rack;

import b.h.la;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;

public class RackUtil {
    public static final String RACK_CONFIG = "config.ru";
    public static final String RACK_GEM_NAME = "rack";
    private static final String a = "rackup";
    public static final int PORT = 9292;
    public static final String WIN_LOCALHOST = "127.0.0.1";
    public static final String NOT_WIN_LOCALHOST = "0.0.0.0";
    public static final String LOCALHOST;
    public static final String RACK_ENV = "RACK_ENV";
    private static final long b;

    public static boolean isRackConfig(PsiFile file) {
        long l2 = b ^ 0x5B6AF906F1E7L;
        return file instanceof RFile && RACK_CONFIG.equals(file.getName());
    }

    public static boolean isRackConfig(@NotNull VirtualFile file) {
        long l2 = b ^ 0x1E65EF8301F6L;
        if (file == null) {
            RackUtil.a(0);
        }
        return RACK_CONFIG.equalsIgnoreCase(file.getName());
    }

    public static String[] getSupportedServers() {
        RackServers[] rackServersArray = RackServers.values();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (RackServers rackServers : rackServersArray) {
            arrayList.add(rackServers.getServerName());
        }
        return ArrayUtil.toStringArray(arrayList);
    }

    @Nullable
    public static VirtualFile findRackConfig(@NotNull Module module) {
        long l2 = b ^ 0x533EDE4C5CB9L;
        if (module == null) {
            RackUtil.a(1);
        }
        if (RModuleUtil.getInstance().hasRubySupport(module)) {
            VirtualFile virtualFile = module.getModuleFile();
            if (virtualFile != null) {
                VirtualFile virtualFile2 = virtualFile.getParent().getParent();
                return virtualFile2.findFileByRelativePath(RACK_CONFIG);
            }
            VirtualFile virtualFile3 = module.getProject().getBaseDir();
            if (virtualFile3 != null) {
                return virtualFile3.findFileByRelativePath(RACK_CONFIG);
            }
        }
        return null;
    }

    @Nullable
    public static String findRackupExecutablePath(@NotNull Module module, @NotNull Sdk sdk) {
        GemInfo gemInfo;
        long l2 = b ^ 0x3F18D1096A14L;
        if (module == null) {
            RackUtil.a(2);
        }
        if (sdk == null) {
            RackUtil.a(3);
        }
        return (gemInfo = GemManager.findGem(module, RACK_GEM_NAME)) != null ? RubyGemExecutionContext.getScriptPath(sdk, module, RACK_GEM_NAME, a) : null;
    }

    static {
        b = la.a(8314690348012693070L, -8004599085351225966L, MethodHandles.lookup().lookupClass()).a(163872018002555L);
        long l2 = b ^ 0x5634FCA1995DL;
        LOCALHOST = SystemInfo.isWindows ? WIN_LOCALHOST : NOT_WIN_LOCALHOST;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x252958CC3051L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/rack/RackUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRackConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findRackConfig";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findRackupExecutablePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class RackServers
    extends Enum<RackServers> {
        public static final /* enum */ RackServers DEFAULT;
        public static final /* enum */ RackServers WEBRICK;
        public static final /* enum */ RackServers MONGREL;
        public static final /* enum */ RackServers THIN;
        public static final /* enum */ RackServers TORQUEBOX;
        @NonNls
        private final String a;
        private static final /* synthetic */ RackServers[] b;

        public static RackServers[] values() {
            return (RackServers[])b.clone();
        }

        public static RackServers valueOf(String name) {
            return Enum.valueOf(RackServers.class, name);
        }

        private RackServers(String name) {
            this.a = name;
        }

        public String getServerName() {
            return this.a;
        }

        public String getCommandOption() {
            return this.a.toLowerCase();
        }

        static {
            long l2 = la.a(-666398571915100139L, 9159098862846020529L, MethodHandles.lookup().lookupClass()).a(44851120416464L) ^ 0xC44422C3CDDL;
            DEFAULT = new RackServers("default");
            WEBRICK = new RackServers("WEBrick");
            MONGREL = new RackServers("Mongrel");
            THIN = new RackServers("Thin");
            TORQUEBOX = new RackServers("Torquebox");
            b = new RackServers[]{DEFAULT, WEBRICK, MONGREL, THIN, TORQUEBOX};
        }
    }
}

