/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import b.h.la;
import com.intellij.analysis.AnalysisScope;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.ExternalIntegerKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
implements Disposable {
    private static final Logger b;
    private static final int a = 7000;
    private final PersistentMap<Integer, List<MyEntry>> e;
    private final DuplicatesProfile[] c;
    private final Project d;
    private final File f;
    private static final long g;

    public DuplicatesIndex(@NotNull Project project, @NotNull DuplicatesProfile[] profiles) throws IOException {
        long l2 = g ^ 0x388507F2AD93L;
        if (project == null) {
            DuplicatesIndex.a(0);
        }
        if (profiles == null) {
            DuplicatesIndex.a(1);
        }
        this.c = profiles;
        this.d = project;
        this.f = ProjectUtil.getProjectCachePath((Project)project, (String)"duplicates").toFile();
        PersistentHashMap.deleteFilesStartingWith((File)this.f);
        this.e = new PersistentHashMap(this.f, (KeyDescriptor)new ExternalIntegerKeyDescriptor(), (DataExternalizer)new MyDataExternalizer());
        this.e.force();
    }

    public void dispose() {
        try {
            this.e.close();
        }
        catch (IOException iOException) {
            b.error((Throwable)iOException);
        }
        PersistentHashMap.deleteFilesStartingWith((File)this.f);
    }

    public void update(@NotNull AnalysisScope scope) {
        long l2 = g ^ 0x4F05DFB958C1L;
        if (scope == null) {
            DuplicatesIndex.a(2);
        }
        final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        final int n2 = scope.getFileCount();
        if (progressIndicator != null) {
            progressIndicator.setText(DupLocatorBundle.message("duplicates.indexing.progress", new Object[0]));
        }
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            private int a = 0;

            public void visitFile(PsiFile baseFile) {
                DuplocateVisitor[] duplocateVisitorArray;
                Object object;
                VirtualFile virtualFile;
                Project project = baseFile.getProject();
                ++this.a;
                if (progressIndicator != null) {
                    virtualFile = baseFile.getVirtualFile();
                    if (virtualFile != null) {
                        object = virtualFile.getPresentableUrl();
                        duplocateVisitorArray = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)object, (Project)project, (boolean)true, (boolean)false);
                        progressIndicator.setText2((String)duplocateVisitorArray);
                    }
                    progressIndicator.setFraction((double)this.a / (double)n2);
                }
                if ((virtualFile = baseFile.getVirtualFile()) == null) {
                    return;
                }
                object = new MyIndexingFragmentsCollector();
                duplocateVisitorArray = DuplicatesIndex.a(DuplicatesIndex.this.c, (FragmentsCollector)object);
                for (Object object2 : baseFile.getViewProvider().getAllFiles()) {
                    for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray) {
                        duplocateVisitor.visitNode((PsiElement)object2);
                    }
                    PsiManager psiManager = PsiManager.getInstance((Project)project);
                    psiManager.dropResolveCaches();
                    InjectedLanguageManager.getInstance((Project)project).dropFileCaches((PsiFile)object2);
                }
                Map<Integer, Set<MyEntry>> map = ((MyIndexingFragmentsCollector)object).getResult();
                for (PsiManager psiManager : map.keySet()) {
                    Set set = (Set)map.get(psiManager);
                    try {
                        ArrayList arrayList = (ArrayList)DuplicatesIndex.this.e.get((Object)psiManager);
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.addAll(set);
                        DuplicatesIndex.this.e.put((Object)psiManager, new ArrayList(arrayList));
                    }
                    catch (IOException iOException) {
                        b.error((Throwable)iOException);
                    }
                }
            }
        });
    }

    public void processAll(@NotNull AnalysisScope scope, @NotNull FragmentsCollector collector) {
        long l2 = g ^ 0xBEBFF31EA2BL;
        if (scope == null) {
            DuplicatesIndex.a(3);
        }
        if (collector == null) {
            DuplicatesIndex.a(4);
        }
        try {
            TIntArrayList tIntArrayList = new TIntArrayList();
            this.e.processKeys(n2 -> {
                tIntArrayList.add(n2.intValue());
                return true;
            });
            final Map<VirtualFile, Map<Language, TIntHashSet>> map = this.a(tIntArrayList);
            final DuplocateVisitor[] duplocateVisitorArray = DuplicatesIndex.a(this.c, new MyProcessingFragmentsCollector(map, collector));
            final ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setText(DupLocatorBundle.message("duplicates.searching.progress", new Object[0]));
            }
            final int n3 = map.size();
            final Set<VirtualFile> set = map.keySet();
            scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
                private int a = 0;

                public void visitFile(PsiFile baseFile) {
                    if (!baseFile.isValid()) {
                        return;
                    }
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile == null || !set.contains(virtualFile)) {
                        return;
                    }
                    if (progressIndicator != null) {
                        String string = virtualFile.getPresentableUrl();
                        String string2 = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)string, (Project)DuplicatesIndex.this.d, (boolean)true, (boolean)false);
                        progressIndicator.setText2(string2);
                        progressIndicator.setFraction((double)this.a / (double)n3);
                    }
                    ++this.a;
                    for (String string2 : ((Map)map.get(virtualFile)).keySet()) {
                        PsiFile psiFile = baseFile.getViewProvider().getPsi((Language)string2);
                        if (psiFile == null || !psiFile.isValid()) continue;
                        for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray) {
                            duplocateVisitor.visitNode((PsiElement)psiFile);
                        }
                        PsiManager psiManager = PsiManager.getInstance((Project)DuplicatesIndex.this.d);
                        psiManager.dropResolveCaches();
                        InjectedLanguageManager.getInstance((Project)DuplicatesIndex.this.d).dropFileCaches(psiFile);
                    }
                }
            });
        }
        catch (IOException iOException) {
            b.error((Throwable)iOException);
        }
    }

    @Nullable
    private static TIntHashSet a(@NotNull Map<VirtualFile, Map<Language, TIntHashSet>> map, @NotNull PsiFragment psiFragment) {
        Map<Language, TIntHashSet> map2;
        VirtualFile virtualFile;
        PsiFile psiFile;
        Language language;
        if (map == null) {
            DuplicatesIndex.a(5);
        }
        if (psiFragment == null) {
            DuplicatesIndex.a(6);
        }
        if ((language = psiFragment.getLanguage()) != null && (psiFile = psiFragment.getFile()) != null && (virtualFile = psiFile.getVirtualFile()) != null && (map2 = map.get(virtualFile)) != null) {
            return map2.get(language);
        }
        return null;
    }

    private Map<VirtualFile, Map<Language, TIntHashSet>> a(@NotNull TIntArrayList tIntArrayList) throws IOException {
        if (tIntArrayList == null) {
            DuplicatesIndex.a(7);
        }
        HashMap<VirtualFile, Map<Language, TIntHashSet>> hashMap = new HashMap<VirtualFile, Map<Language, TIntHashSet>>();
        int n2 = tIntArrayList.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            int n3 = tIntArrayList.get(i10);
            List list2 = (List)this.e.get((Object)n3);
            if (list2.size() < 2) continue;
            for (MyEntry myEntry : list2) {
                TIntHashSet tIntHashSet;
                PersistentFS persistentFS;
                VirtualFile virtualFile;
                Language language;
                if (myEntry.getTextRanges().length == 0 || (language = Language.findLanguageByID((String)myEntry.getLanguageId())) == null || (virtualFile = IndexInfrastructure.findFileById((PersistentFS)(persistentFS = (PersistentFS)ManagingFS.getInstance()), (int)myEntry.getFileId())) == null) continue;
                HashMap<Language, TIntHashSet> hashMap2 = (HashMap<Language, TIntHashSet>)hashMap.get(virtualFile);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<Language, TIntHashSet>();
                    hashMap.put(virtualFile, hashMap2);
                }
                if ((tIntHashSet = (TIntHashSet)hashMap2.get(language)) == null) {
                    tIntHashSet = new TIntHashSet();
                    hashMap2.put(language, tIntHashSet);
                }
                tIntHashSet.add(DuplicatesIndex.a(myEntry.getTextRanges()));
            }
        }
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (((Map)entry.getValue()).size() != 0) continue;
            iterator.remove();
        }
        return hashMap;
    }

    private static int a(@NotNull TextRange[] textRangeArray) {
        if (textRangeArray == null) {
            DuplicatesIndex.a(8);
        }
        int n2 = 0;
        for (TextRange textRange : textRangeArray) {
            n2 = n2 * 31 + textRange.getStartOffset();
            n2 = n2 * 31 + textRange.getEndOffset();
        }
        return n2;
    }

    private static DuplocateVisitor[] a(DuplicatesProfile[] duplicatesProfileArray, FragmentsCollector fragmentsCollector) {
        DuplocateVisitor[] duplocateVisitorArray = new DuplocateVisitor[duplicatesProfileArray.length];
        for (int i10 = 0; i10 < duplocateVisitorArray.length; ++i10) {
            duplocateVisitorArray[i10] = duplicatesProfileArray[i10].createVisitor(fragmentsCollector);
        }
        return duplocateVisitorArray;
    }

    @NotNull
    private static TextRange[] a(@NotNull PsiFragment psiFragment) {
        if (psiFragment == null) {
            DuplicatesIndex.a(9);
        }
        PsiElement[] psiElementArray = psiFragment.getElements();
        ArrayList<TextRange> arrayList = new ArrayList<TextRange>(psiElementArray.length);
        for (PsiElement psiElement : psiElementArray) {
            arrayList.add(psiElement != null ? psiElement.getTextRange() : TextRange.EMPTY_RANGE);
        }
        TextRange[] textRangeArray = arrayList.toArray(TextRange.EMPTY_ARRAY);
        if (textRangeArray == null) {
            DuplicatesIndex.a(10);
        }
        return textRangeArray;
    }

    static {
        g = la.a(-1816246802640340169L, -742252513819293794L, MethodHandles.lookup().lookupClass()).a(31330681564190L);
        long l2 = g ^ 0x566DE45FCCCFL;
        b = Logger.getInstance((String)"#com.intellij.dupLocator.DuplicatesIndex");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x310A334F4B3CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRanges";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentsSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeHash";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextRanges";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProcessingFragmentsCollector
    implements FragmentsCollector {
        private final Map<VirtualFile, Map<Language, TIntHashSet>> b;
        private final FragmentsCollector a;

        MyProcessingFragmentsCollector(Map<VirtualFile, Map<Language, TIntHashSet>> map, FragmentsCollector collector) {
            this.b = map;
            this.a = collector;
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            TIntHashSet tIntHashSet;
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            if (cost < duplocatorState.getLowerBound() || cost > 7000) {
                return;
            }
            if (frag != null && (tIntHashSet = DuplicatesIndex.a(this.b, frag)) != null) {
                boolean bl2 = false;
                TextRange[] textRangeArray = DuplicatesIndex.a(frag);
                int n2 = DuplicatesIndex.a(textRangeArray);
                if (tIntHashSet.contains(n2)) {
                    bl2 = true;
                }
                if (bl2) {
                    this.a.add(hash, cost, frag);
                }
                return;
            }
            this.a.add(hash, cost, frag);
        }
    }

    private static class MyIndexingFragmentsCollector
    implements FragmentsCollector {
        private final Map<Integer, Set<MyEntry>> a = new HashMap<Integer, Set<MyEntry>>();
        private static final long b = la.a(-1552791150387419845L, -6529399709731799965L, MethodHandles.lookup().lookupClass()).a(240977369928535L);

        private MyIndexingFragmentsCollector() {
        }

        @NotNull
        public Map<Integer, Set<MyEntry>> getResult() {
            Map<Integer, Set<MyEntry>> map = this.a;
            if (map == null) {
                MyIndexingFragmentsCollector.a(0);
            }
            return map;
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            if (frag == null) {
                return;
            }
            PsiFile psiFile = frag.getFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            int n2 = duplocatorState.getLowerBound();
            if (cost < n2 || cost > 7000) {
                return;
            }
            TextRange[] textRangeArray = DuplicatesIndex.a(frag);
            Language language = frag.getLanguage();
            if (language == null) {
                return;
            }
            HashSet hashSet = this.a.get(hash);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.a.put(hash, (Set<MyEntry>)hashSet);
            }
            int n3 = FileBasedIndex.getFileId((VirtualFile)virtualFile);
            hashSet.add(new MyEntry(n3, language.getID(), textRangeArray));
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = b ^ 0x63422B999405L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesIndex$MyIndexingFragmentsCollector", "getResult"));
        }
    }

    private static class MyDataExternalizer
    implements DataExternalizer<List<MyEntry>> {
        private static final long a = la.a(-7178117601298916529L, -3218702979344157306L, MethodHandles.lookup().lookupClass()).a(264890971874050L);

        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<MyEntry> entryList) throws IOException {
            if (out == null) {
                MyDataExternalizer.a(0);
            }
            out.writeInt(entryList.size());
            for (MyEntry myEntry : entryList) {
                out.writeInt(myEntry.getFileId());
                out.writeUTF(myEntry.getLanguageId());
                TextRange[] textRangeArray = myEntry.getTextRanges();
                out.writeInt(textRangeArray.length);
                for (TextRange textRange : textRangeArray) {
                    if (textRange == null) {
                        out.writeInt(0);
                        out.writeInt(0);
                        continue;
                    }
                    out.writeInt(textRange.getStartOffset());
                    out.writeInt(textRange.getEndOffset());
                }
            }
        }

        public List<MyEntry> read(@NotNull DataInput in2) throws IOException {
            if (in2 == null) {
                MyDataExternalizer.a(1);
            }
            int n2 = in2.readInt();
            ArrayList<MyEntry> arrayList = new ArrayList<MyEntry>(n2);
            for (int i10 = 0; i10 < n2; ++i10) {
                int n3 = in2.readInt();
                String string = in2.readUTF();
                int n4 = in2.readInt();
                TextRange[] textRangeArray = new TextRange[n4];
                for (int i11 = 0; i11 < n4; ++i11) {
                    int n5 = in2.readInt();
                    int n6 = in2.readInt();
                    textRangeArray[i11] = n5 == -1 || n6 == -1 ? null : new TextRange(n5, n6);
                }
                MyEntry myEntry = new MyEntry(n3, string, textRangeArray);
                arrayList.add(myEntry);
            }
            return arrayList;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x4F66FA01F60DL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyDataExternalizer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyEntry {
        private final int b;
        private final String c;
        private final TextRange[] a;
        private static final long d = la.a(1642467506277335115L, 7959340697656350795L, MethodHandles.lookup().lookupClass()).a(5840851542377L);

        private MyEntry(int fileId, @NotNull String languageId, @NotNull TextRange[] textRanges) {
            if (languageId == null) {
                MyEntry.a(0);
            }
            if (textRanges == null) {
                MyEntry.a(1);
            }
            this.b = fileId;
            this.c = languageId;
            this.a = textRanges;
        }

        public int getFileId() {
            return this.b;
        }

        @NotNull
        public String getLanguageId() {
            String string = this.c;
            if (string == null) {
                MyEntry.a(2);
            }
            return string;
        }

        @NotNull
        public TextRange[] getTextRanges() {
            if (this.a == null) {
                MyEntry.a(3);
            }
            return this.a;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            MyEntry myEntry = (MyEntry)o2;
            if (this.b != myEntry.b) {
                return false;
            }
            if (!this.c.equals(myEntry.c)) {
                return false;
            }
            return Arrays.equals(this.a, myEntry.a);
        }

        public int hashCode() {
            int n2 = this.b;
            n2 = 31 * n2 + this.c.hashCode();
            n2 = 31 * n2 + Arrays.hashCode(this.a);
            return n2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x19B3D160F843L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRanges";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRanges";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

