/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WhereParser {
    static final String ourExcPrefix = "p4 where wrong result: ";
    private String myIn;
    private final List<String> myClientRoots;
    private final String myClientName;
    private final String myAnyPath;
    private String myLocal;
    private String myLocalRootRelative;
    private String myDepot;

    WhereParser(@NotNull String in, List<String> clientRoots, @NotNull String clientName, @NotNull String anyPath) {
        if (in == null) {
            WhereParser.$$$reportNull$$$0(0);
        }
        if (clientName == null) {
            WhereParser.$$$reportNull$$$0(1);
        }
        if (anyPath == null) {
            WhereParser.$$$reportNull$$$0(2);
        }
        this.myIn = in;
        this.myClientRoots = clientRoots;
        this.myClientName = clientName;
        this.myAnyPath = anyPath;
    }

    public void execute() throws VcsException {
        String preparedAnyPath = this.myAnyPath.replace('\\', '/');
        int lastIdx = preparedAnyPath.lastIndexOf(47);
        preparedAnyPath = lastIdx == -1 ? preparedAnyPath : preparedAnyPath.substring(lastIdx + 1);
        this.myIn = this.myIn.replace('\\', '/');
        int idxOfLocalRootRelative = this.myIn.indexOf(" //" + this.myClientName + "/");
        if (idxOfLocalRootRelative == -1) {
            throw new VcsException(this.createErrorMessage(preparedAnyPath));
        }
        int idxLocal = this.findRelativeEnd(idxOfLocalRootRelative + 1);
        if (idxLocal == -1 || idxLocal <= idxOfLocalRootRelative) {
            throw new VcsException(this.createErrorMessage(preparedAnyPath));
        }
        this.myDepot = this.myIn.substring(0, idxOfLocalRootRelative).trim();
        this.myLocalRootRelative = this.myIn.substring(idxOfLocalRootRelative, idxLocal).trim();
        this.myLocal = this.myIn.substring(idxLocal).trim();
    }

    private int findRelativeEnd(int from) {
        for (String root : this.myClientRoots) {
            int index = this.myIn.indexOf(" " + root, from);
            if (index < 0) continue;
            return index;
        }
        if (SystemInfo.isWindows) {
            int colon = this.myIn.indexOf(":", from);
            while (colon > from + 2) {
                if (this.myIn.charAt(colon - 2) == ' ' && Character.isLetter(this.myIn.charAt(colon - 1)) && colon + 1 < this.myIn.length() && (this.myIn.charAt(colon + 1) == '/' || this.myIn.charAt(colon + 1) == '\\')) {
                    return colon - 2;
                }
                colon = this.myIn.indexOf(":", colon + 1);
            }
        }
        return this.myIn.indexOf(" ", from);
    }

    public String getLocal() {
        return this.myLocal;
    }

    public String getLocalRootRelative() {
        return this.myLocalRootRelative;
    }

    public String getDepot() {
        return this.myDepot;
    }

    private String createErrorMessage(String preparedAnyPath) {
        return ourExcPrefix + this.myIn + ", myAnyPath = '" + this.myAnyPath + "', anyPathFile = '" + preparedAnyPath + "', myClientName = '" + this.myClientName + "', myClientRoots = '" + this.myClientRoots + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "in";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "clientName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "anyPath";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/perforce/perforce/WhereParser";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

