/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;

public class JSWithWhileSurrounder
extends JSStatementSurrounder {
    public String getTemplateDescription() {
        return JSBundle.message((String)"javascript.surround.with.while", (Object[])new Object[0]);
    }

    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "while(true) { }";
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSWhileStatement stmt = (JSWhileStatement)statementNode.getPsi();
        return stmt.getBody().getLastChild().getNode();
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSWhileStatement stmt = (JSWhileStatement)statementNode.getPsi();
        return stmt.getCondition().getTextRange();
    }
}

