/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.ecmascript6.parsing.jsx.JSXParser;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.parsing.JavaScriptParser;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXHarmonyLanguageDialect
extends JSLanguageDialect {
    public static final DialectOptionHolder DIALECT_OPTION_HOLDER = DialectOptionHolder.JSX;

    public JSXHarmonyLanguageDialect() {
        super("JSX Harmony", DIALECT_OPTION_HOLDER, JavaScriptSupportLoader.ECMA_SCRIPT_6, "text/jsx", "text/babel");
    }

    public static boolean isReactComponent(@Nullable JSExpression expression) {
        if (!(expression instanceof JSCallExpression)) {
            return false;
        }
        JSCallExpression callExpression = (JSCallExpression)expression;
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        return JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "React", "createClass") || JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)methodExpression, "createReactClass");
    }

    public static boolean areReferencesResolvedOrEmpty(@NotNull JSXmlLiteralExpression expression) {
        PsiReference[] references;
        if (expression == null) {
            JSXHarmonyLanguageDialect.$$$reportNull$$$0(0);
        }
        if ((references = expression.getReferences()).length == 0) {
            return true;
        }
        ArrayList resolved = ContainerUtil.newArrayList();
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
                List<PsiElement> elements = JSResolveResult.toElements(results);
                resolved.addAll(ContainerUtil.filter(elements, el -> {
                    if (expression == null) {
                        JSXHarmonyLanguageDialect.$$$reportNull$$$0(2);
                    }
                    return !el.equals(expression);
                }));
                continue;
            }
            PsiElement resolve = reference.resolve();
            if (resolve == null || resolve.equals(expression)) continue;
            resolved.add(resolve);
        }
        return !resolved.isEmpty();
    }

    @Override
    public String getFileExtension() {
        return "js";
    }

    @Override
    public JavaScriptParser<?, ?, ?, ?> createParser(@NotNull PsiBuilder builder) {
        if (builder == null) {
            JSXHarmonyLanguageDialect.$$$reportNull$$$0(1);
        }
        return new JSXParser(this, builder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/dialects/JSXHarmonyLanguageDialect";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areReferencesResolvedOrEmpty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$areReferencesResolvedOrEmpty$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

