/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import org.jetbrains.annotations.NotNull;

public class EditDistance {
    private EditDistance() {
    }

    public static int levenshtein(@NotNull CharSequence str1, @NotNull CharSequence str2, boolean caseSensitive) {
        if (str1 == null) {
            EditDistance.$$$reportNull$$$0(0);
        }
        if (str2 == null) {
            EditDistance.$$$reportNull$$$0(1);
        }
        int[][] d = EditDistance.prepare(str1.length(), str2.length());
        for (int i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                int cost = EditDistance.equal(str1.charAt(i - 1), str2.charAt(j - 1), caseSensitive) ? 0 : 1;
                d[i][j] = EditDistance.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[str1.length()][str2.length()];
    }

    public static int optimalAlignment(@NotNull CharSequence str1, @NotNull CharSequence str2, boolean caseSensitive) {
        if (str1 == null) {
            EditDistance.$$$reportNull$$$0(2);
        }
        if (str2 == null) {
            EditDistance.$$$reportNull$$$0(3);
        }
        int[][] d = EditDistance.prepare(str1.length(), str2.length());
        for (int i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                int cost = EditDistance.equal(str1.charAt(i - 1), str2.charAt(j - 1), caseSensitive) ? 0 : 1;
                d[i][j] = EditDistance.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
                if (i <= 1 || j <= 1 || !EditDistance.equal(str1.charAt(i - 1), str2.charAt(j - 2), caseSensitive) || !EditDistance.equal(str1.charAt(i - 2), str2.charAt(j - 1), caseSensitive)) continue;
                d[i][j] = Math.min(d[i][j], d[i - 2][j - 2] + cost);
            }
        }
        return d[str1.length()][str2.length()];
    }

    private static int[][] prepare(int length1, int length2) {
        int[][] d = new int[length1 + 1][length2 + 1];
        for (int i = 0; i <= length1; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= length2; ++j) {
            d[0][j] = j;
        }
        return d;
    }

    private static boolean equal(char c1, char c2, boolean caseSensitive) {
        return caseSensitive ? c1 == c2 : Character.toLowerCase(c1) == Character.toLowerCase(c2);
    }

    private static int min(int a, int b, int c) {
        return Math.min(Math.min(a, b), c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str1";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str2";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/text/EditDistance";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "levenshtein";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "optimalAlignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

