/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import java.util.Locale;

public enum PgDataTypeSubKind {
    NONE('\u0000'),
    BASE_TYPE('b'),
    COMPOSITE('c'),
    DOMAIN('d'),
    ENUM('e'),
    PSEUDO('p'),
    UNKNOWN('x');

    public final char code;

    private PgDataTypeSubKind(char code) {
        this.code = code;
    }

    public static PgDataTypeSubKind of(char c2) {
        switch (Character.toLowerCase(c2)) {
            case 'b': {
                return BASE_TYPE;
            }
            case 'c': {
                return COMPOSITE;
            }
            case 'd': {
                return DOMAIN;
            }
            case 'e': {
                return ENUM;
            }
            case 'p': {
                return PSEUDO;
            }
            case '\u0000': {
                return NONE;
            }
        }
        return UNKNOWN;
    }

    public String human_readable_name() {
        return this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
    }
}

