class SushiNet::StoreCart < Borges::Component

  def increase(item)
    session.cart[item] += 1
  end

  def reduce(item)
    session.cart[item] -= 1
    session.cart.delete item if session.cart[item] == 0
  end

  def remove(item)
    session.cart.delete item
  end

  def render_content_on(r)
    return unless session.has_cart?

    r.div_named 'cart' do
      r.text 'Your cart: '

      r.list_do(session.cart) do |item, count|
        render_row_for_count_on count, item, r
      end

      sum = 0
      session.cart.each do |item, count|
        sum += (item.price * count)
      end
      r.text "Total: #{sum.to_cents}"
    end
  end

  def render_row_for_count_on(count, item, r)
    r.text "#{count} #{item.title} #{(count * item.price).to_cents} "
    r.text ' '
    r.anchor '+' do increase item end
    r.text ' '
    r.anchor '-' do reduce item end
    r.text ' '
    r.anchor 'X' do remove item end
  end

  def style
    "#cart ul { list-style: none; }"
  end

end # class SushiNet::StoreCart

