/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.LineCommandAdapter;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.UpdateOutputLineConverter;

public class BaseUpdateCommandListener
extends LineCommandAdapter {
    @NotNull
    private final UpdateOutputLineConverter converter;
    @Nullable
    private final ProgressTracker handler;
    @NotNull
    private final AtomicReference<SvnBindException> exception;

    public BaseUpdateCommandListener(@NotNull File base, @Nullable ProgressTracker handler) {
        if (base == null) {
            BaseUpdateCommandListener.$$$reportNull$$$0(0);
        }
        this.handler = handler;
        this.converter = new UpdateOutputLineConverter(base);
        this.exception = new AtomicReference();
    }

    @Override
    public void onLineAvailable(String line, Key outputType) {
        ProgressEvent event;
        if (ProcessOutputTypes.STDOUT.equals((Object)outputType) && (event = this.converter.convert(line)) != null) {
            this.beforeHandler(event);
            try {
                BaseSvnClient.callHandler(this.handler, event);
            }
            catch (SvnBindException e) {
                this.cancel();
                this.exception.set(e);
            }
        }
    }

    public void throwWrappedIfException() throws SvnBindException {
        SvnBindException e = this.exception.get();
        if (e != null) {
            throw e;
        }
    }

    protected void beforeHandler(@NotNull ProgressEvent event) {
        if (event == null) {
            BaseUpdateCommandListener.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/commandLine/BaseUpdateCommandListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

