/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import org.jetbrains.annotations.NotNull;

class CyclomaticComplexityVisitor
extends JSRecursiveElementVisitor {
    private int complexity = 1;

    CyclomaticComplexityVisitor() {
    }

    public void visitJSElement(JSElement jsElement) {
        int oldComplexity = 0;
        if (jsElement instanceof JSFunction) {
            oldComplexity = this.complexity;
        }
        super.visitJSElement(jsElement);
        if (jsElement instanceof JSFunction) {
            this.complexity = oldComplexity;
        }
    }

    public void visitJSForStatement(@NotNull JSForStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(0);
        }
        super.visitJSForStatement(statement);
        ++this.complexity;
    }

    public void visitJSForInStatement(@NotNull JSForInStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(1);
        }
        super.visitJSForInStatement(statement);
        ++this.complexity;
    }

    public void visitJSIfStatement(@NotNull JSIfStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(2);
        }
        super.visitJSIfStatement(statement);
        ++this.complexity;
    }

    public void visitJSDoWhileStatement(@NotNull JSDoWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(3);
        }
        super.visitJSDoWhileStatement(statement);
        ++this.complexity;
    }

    public void visitJSConditionalExpression(JSConditionalExpression expression) {
        super.visitJSConditionalExpression(expression);
        ++this.complexity;
    }

    public void visitJSSwitchStatement(@NotNull JSSwitchStatement statement) {
        JSCaseClause[] caseClauses;
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(4);
        }
        super.visitJSSwitchStatement(statement);
        for (JSCaseClause clause : caseClauses = statement.getCaseClauses()) {
            JSStatement[] statements = clause.getStatements();
            if (statements == null || statements.length == 0) continue;
            ++this.complexity;
        }
    }

    public void visitJSWhileStatement(@NotNull JSWhileStatement statement) {
        if (statement == null) {
            CyclomaticComplexityVisitor.$$$reportNull$$$0(5);
        }
        super.visitJSWhileStatement(statement);
        ++this.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "statement";
        objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/CyclomaticComplexityVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForStatement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSForInStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSIfStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSDoWhileStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSSwitchStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSWhileStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

