/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.lang.javascript.hierarchy.method.JSMethodHierarchyNodeDescriptor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMethodHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final SmartPsiElementPointer myMethod;

    public JSMethodHierarchyTreeStructure(Project project, JSFunction method) {
        super(project, null);
        this.myBaseDescriptor = this.buildHierarchyElement(project, method);
        ((JSMethodHierarchyNodeDescriptor)this.myBaseDescriptor).setTreeStructure(this);
        this.myMethod = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)method);
        this.setBaseElement(this.myBaseDescriptor);
    }

    private HierarchyNodeDescriptor buildHierarchyElement(Project project, JSFunction method) {
        List<JSClass> classesToShow = JSMethodHierarchyTreeStructure.getSuperClassesToShow(method);
        JSMethodHierarchyNodeDescriptor descriptor2 = null;
        for (int i = classesToShow.size() - 1; i >= 0; --i) {
            JSClass jsClass = classesToShow.get(i);
            JSMethodHierarchyNodeDescriptor newDescriptor = new JSMethodHierarchyNodeDescriptor(project, descriptor2, jsClass, false, this);
            if (descriptor2 != null) {
                descriptor2.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor2 = newDescriptor;
        }
        JSMethodHierarchyNodeDescriptor newDescriptor = new JSMethodHierarchyNodeDescriptor(project, descriptor2, JSResolveUtil.getClassOfContext((PsiElement)method), true, this);
        if (descriptor2 != null) {
            descriptor2.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static List<JSClass> getSuperClassesToShow(JSFunction method) {
        JSClass upperNonInterfaceClass;
        JSFunction jsFunction;
        Collection<JSFunction> interfaceMethods;
        JSClass[] superClasses;
        JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)method);
        assert (jsClass != null);
        ArrayList<JSClass> superClassesToShow = new ArrayList<JSClass>();
        JSClass superClass = jsClass;
        while ((superClasses = superClass.getSuperClasses()).length > 0 && !superClassesToShow.contains(superClass = superClasses[0])) {
            superClassesToShow.add(superClass);
            if (!JSResolveUtil.isObjectClass(superClass)) continue;
        }
        for (int i = superClassesToShow.size() - 1; i >= 0 && JSInheritanceUtil.findMethodInClass(method, (JSClass)superClassesToShow.get(i), false) == null; --i) {
            superClassesToShow.remove(i);
        }
        if (!jsClass.isInterface() && !(interfaceMethods = JSInheritanceUtil.findImplementedMethods(jsFunction = JSInheritanceUtil.findMethodInClass(method, upperNonInterfaceClass = superClassesToShow.isEmpty() ? jsClass : (JSClass)superClassesToShow.get(superClassesToShow.size() - 1), false))).isEmpty()) {
            superClassesToShow.add(JSResolveUtil.getClassOfContext((PsiElement)interfaceMethods.iterator().next()));
        }
        return superClassesToShow;
    }

    @Nullable
    public final JSFunction getBaseMethod() {
        PsiElement element = this.myMethod.getElement();
        return element instanceof JSFunction ? (JSFunction)element : null;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        if (descriptor2 == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        JSClass jsClass = ((JSMethodHierarchyNodeDescriptor)descriptor2).getJSClass();
        Collection<JSClass> subclasses = JSInheritanceUtil.findDirectSubClasses(jsClass, true);
        ArrayList<JSMethodHierarchyNodeDescriptor> descriptors = new ArrayList<JSMethodHierarchyNodeDescriptor>(subclasses.size());
        for (JSClass aClass : subclasses) {
            if (HierarchyBrowserManager.getInstance((Project)this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED && this.shouldHideClass(aClass)) continue;
            JSMethodHierarchyNodeDescriptor d = new JSMethodHierarchyNodeDescriptor(this.myProject, descriptor2, aClass, false, this);
            descriptors.add(d);
        }
        Object[] objectArray = descriptors.toArray(new HierarchyNodeDescriptor[0]);
        if (objectArray == null) {
            JSMethodHierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    private boolean shouldHideClass(JSClass jsClass) {
        if (JSInheritanceUtil.findMethodInClass(this.getBaseMethod(), jsClass, false) != null) {
            return false;
        }
        if (this.hasBaseClassMethod(jsClass)) {
            for (JSClass subclass : JSInheritanceUtil.findDirectSubClasses(jsClass, true)) {
                if (this.shouldHideClass(subclass)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasBaseClassMethod(JSClass jsClass) {
        JSFunction baseClassMethod = JSInheritanceUtil.findMethodInClass(this.getBaseMethod(), jsClass, true);
        return baseClassMethod != null;
    }

    boolean isSuperClassForBaseClass(JSClass aClass) {
        JSFunction baseMethod = this.getBaseMethod();
        if (baseMethod == null) {
            return false;
        }
        JSClass baseClass = JSResolveUtil.getClassOfContext((PsiElement)baseMethod);
        if (baseClass == null) {
            return false;
        }
        return JSInheritanceUtil.isParentClass(baseClass, aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyTreeStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

