/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpxPackageDescriptor
extends NodePackageDescriptor {
    private static final String NPX_BIN_FILE = "bin" + File.separator + "npx-cli.js";
    private static final String NPX = "npx";
    private static final String NPX_SPACE = "npx ";
    private final List<? extends NpxCommand> myCommands;

    public NpxPackageDescriptor(@NotNull List<String> packageNames, @NotNull List<? extends NpxCommand> commands) {
        if (packageNames == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(0);
        }
        if (commands == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(1);
        }
        super(packageNames);
        this.myCommands = commands;
    }

    @Override
    @NotNull
    public List<NodePackage> listAvailable(@NotNull Project project, @Nullable NodeJsInterpreter interpreter, @Nullable VirtualFile contextFileOrDirectory, boolean directDependenciesInsideProject) {
        if (project == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(2);
        }
        ArrayList results = ContainerUtil.newArrayList();
        if (NpxPackageDescriptor.getNpxBinFilePath(interpreter) != null) {
            for (NpxCommand npxCommand : this.myCommands) {
                results.add(npxCommand.createPackage());
            }
        }
        NodeJsInterpreter forSearchingGlobalPackages = !directDependenciesInsideProject ? interpreter : null;
        results.addAll(super.listAvailable(project, forSearchingGlobalPackages, contextFileOrDirectory, directDependenciesInsideProject));
        ArrayList arrayList = results;
        if (arrayList == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public NodePackage createPackage(@NotNull String path) {
        if (path == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(4);
        }
        if (path.startsWith(NPX_SPACE)) {
            NpxNodePackage npxNodePackage = new NpxNodePackage(path.substring(NPX_SPACE.length()));
            if (npxNodePackage == null) {
                NpxPackageDescriptor.$$$reportNull$$$0(5);
            }
            return npxNodePackage;
        }
        NodePackage nodePackage = super.createPackage(path);
        if (nodePackage == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(6);
        }
        return nodePackage;
    }

    @Nullable
    public static NpxNodePackage createIfAvailable(@Nullable NodeJsInterpreter interpreter, @NotNull NpxCommand command) {
        NodeJsLocalInterpreter localInterpreter;
        if (command == null) {
            NpxPackageDescriptor.$$$reportNull$$$0(7);
        }
        if ((localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter)) == null) {
            return command.createPackage();
        }
        String bin = NpxPackageDescriptor.getNpxBinFilePath(localInterpreter);
        if (bin != null) {
            return command.createPackage();
        }
        return null;
    }

    @Nullable
    private static String getNpxBinFilePath(@Nullable NodeJsInterpreter interpreter) {
        WslNodePackage pkg;
        File bin;
        String npmPackageDir;
        if (interpreter instanceof NodeJsLocalInterpreter && !StringUtil.isEmptyOrSpaces((String)(npmPackageDir = ((NodeJsLocalInterpreter)interpreter).getNpmPackageDir())) && (bin = new File(npmPackageDir, NPX_BIN_FILE)).isFile()) {
            return bin.getAbsolutePath();
        }
        if (interpreter instanceof WslNodeInterpreter && (pkg = WslNodePackage.resolvePackageRefAsWsl((WslNodeInterpreter)interpreter, NodePackageRef.create("npm"))) != null) {
            return pkg.getSystemIndependentPath() + "/" + FileUtil.toSystemIndependentName((String)NPX_BIN_FILE);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "listAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "listAvailable";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPackage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createIfAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class NpxNodePackage
    extends NodePackage {
        private final List<String> myArguments;

        public NpxNodePackage(@NotNull List<String> arguments) {
            if (arguments == null) {
                NpxNodePackage.$$$reportNull$$$0(0);
            }
            this(ParametersListUtil.join(arguments));
        }

        public NpxNodePackage(@NotNull String npxArguments) {
            if (npxArguments == null) {
                NpxNodePackage.$$$reportNull$$$0(1);
            }
            super(NpxPackageDescriptor.NPX_SPACE + npxArguments);
            this.myArguments = ParametersListUtil.parse((String)npxArguments);
        }

        @Override
        @NotNull
        public String getPresentablePath() {
            String string = this.getSystemIndependentPath();
            if (string == null) {
                NpxNodePackage.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean isValid() {
            return !this.myArguments.isEmpty();
        }

        @Override
        @Nullable
        public SemVer getVersion() {
            return null;
        }

        @Override
        @Nullable
        public String getErrorMessage(@NotNull String packageName) {
            if (packageName == null) {
                NpxNodePackage.$$$reportNull$$$0(3);
            }
            return this.isValid() ? null : "Invalid npx command";
        }

        @Nullable
        public String getErrorMessage(@NotNull NodeJsInterpreter interpreter) {
            if (interpreter == null) {
                NpxNodePackage.$$$reportNull$$$0(4);
            }
            if (!this.isValid()) {
                return "Invalid npx command";
            }
            if (NpxPackageDescriptor.getNpxBinFilePath(interpreter) == null) {
                return NpxNodePackage.getNpxNotFoundErrorMessage(interpreter);
            }
            return null;
        }

        @NotNull
        public List<String> getArguments(@NotNull NodeJsInterpreter interpreter) throws ExecutionException {
            String binPath;
            if (interpreter == null) {
                NpxNodePackage.$$$reportNull$$$0(5);
            }
            if ((binPath = NpxPackageDescriptor.getNpxBinFilePath(interpreter)) == null) {
                throw new ExecutionException(NpxNodePackage.getNpxNotFoundErrorMessage(interpreter));
            }
            ImmutableList immutableList = ImmutableList.builder().add((Object)binPath).addAll(this.myArguments).build();
            if (immutableList == null) {
                NpxNodePackage.$$$reportNull$$$0(6);
            }
            return immutableList;
        }

        @NotNull
        private static String getNpxNotFoundErrorMessage(@NotNull NodeJsInterpreter interpreter) {
            if (interpreter == null) {
                NpxNodePackage.$$$reportNull$$$0(7);
            }
            String string = "Cannot find npx bundled with " + interpreter.getPresentableName();
            if (string == null) {
                NpxNodePackage.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npxArguments";
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxNodePackage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxNodePackage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentablePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArguments";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNpxNotFoundErrorMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getErrorMessage";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getArguments";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getNpxNotFoundErrorMessage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class NpxCommand {
        private final String myPackageName;
        private final String myCommand;

        public NpxCommand(@NotNull String packageName, @NotNull String command) {
            if (packageName == null) {
                NpxCommand.$$$reportNull$$$0(0);
            }
            if (command == null) {
                NpxCommand.$$$reportNull$$$0(1);
            }
            this.myPackageName = packageName;
            this.myCommand = command;
        }

        @NotNull
        private NpxNodePackage createPackage() {
            if (this.myPackageName.equals(this.myCommand)) {
                NpxNodePackage npxNodePackage = new NpxNodePackage(Collections.singletonList(this.myCommand));
                if (npxNodePackage == null) {
                    NpxCommand.$$$reportNull$$$0(2);
                }
                return npxNodePackage;
            }
            NpxNodePackage npxNodePackage = new NpxNodePackage(Arrays.asList("--package", this.myPackageName, this.myCommand));
            if (npxNodePackage == null) {
                NpxCommand.$$$reportNull$$$0(3);
            }
            return npxNodePackage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpxPackageDescriptor$NpxCommand";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPackage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

