/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolExecutionException;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolMessageProcessor {
    private final List<QualityToolMessage> myMessages = new ArrayList<QualityToolMessage>();
    private final int myMaxMessages;
    private PsiFile myFile;
    private QualityToolMessage internalErrorMessage;
    private final Map<String, String> mySubstitutions = new HashMap<String, String>();
    private boolean myFatalError = false;
    private HighlightDisplayLevel myDefaultHighlightDisplayLevel = HighlightDisplayLevel.WARNING;
    private final IntentionAction myConfigureFix = new ConfigureFix();

    protected QualityToolMessageProcessor(int maxMessages) {
        this.myMaxMessages = maxMessages;
    }

    protected QualityToolMessageProcessor(QualityToolAnnotatorInfo info, int maxMessages) {
        this.myFile = info.getPsiFile();
        this.myMaxMessages = maxMessages;
        if (!info.getProject().isDisposed()) {
            this.myDefaultHighlightDisplayLevel = InspectionProjectProfileManager.getInstance((Project)info.getProject()).getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)info.getInspection().getID()), (PsiElement)info.getPsiFile());
        }
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public boolean processStdErrMessages() {
        return true;
    }

    public abstract void parseLine(String var1);

    public abstract void done() throws QualityToolExecutionException;

    @Nullable
    protected String getMessagePrefix() {
        return null;
    }

    public final void addSubstitution(String sample, String replacement) {
        this.mySubstitutions.put(sample, replacement);
    }

    @NotNull
    public final List<QualityToolMessage> getMessages() {
        List<QualityToolMessage> list = this.myMessages;
        if (list == null) {
            QualityToolMessageProcessor.$$$reportNull$$$0(0);
        }
        return list;
    }

    public int getMessageCount() {
        return this.myMessages.size();
    }

    public final void addInternalMessage(int line, String messageText) {
        this.addMessage(new QualityToolMessage(this, line, QualityToolMessage.Severity.INTERNAL_ERROR, messageText, new IntentionAction[0]));
    }

    protected void addMessage(QualityToolMessage message) {
        if (message.isInternalError()) {
            this.internalErrorMessage = message;
        }
        if (this.myMessages.size() < this.myMaxMessages) {
            for (String sample : this.mySubstitutions.keySet()) {
                if (!message.getMessageText().contains(sample)) continue;
                message.substitute(sample, this.mySubstitutions.get(sample));
            }
            HighlightDisplayLevel displayLevel = this.severityToDisplayLevel(message.getSeverity());
            message.setDisplayLevel(displayLevel != null ? displayLevel : this.myDefaultHighlightDisplayLevel);
            this.myMessages.add(message);
        } else if (this.myMessages.size() == this.myMaxMessages) {
            QualityToolMessage lastMessage = this.myMessages.get(this.myMessages.size() - 1);
            QualityToolMessage errorMessage = new QualityToolMessage(this, lastMessage.getTextRange(), QualityToolMessage.Severity.INTERNAL_ERROR, "Too many messages per file, only first " + this.myMaxMessages + " errors/warnings are shown.", this.myConfigureFix);
            this.myMessages.add(errorMessage);
        }
    }

    @Nullable
    protected abstract HighlightDisplayLevel severityToDisplayLevel(@NotNull QualityToolMessage.Severity var1);

    @NotNull
    protected abstract String getQuickFixFamilyName();

    @Nullable
    protected abstract Configurable getToolConfigurable(@NotNull Project var1);

    public QualityToolMessage getInternalErrorMessage() {
        return this.internalErrorMessage;
    }

    public void setFatalError() {
        this.myFatalError = true;
    }

    public boolean isFatalError() {
        return this.myFatalError;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/tools/quality/QualityToolMessageProcessor", "getMessages"));
    }

    private class ConfigureFix
    implements IntentionAction {
        private ConfigureFix() {
        }

        @NotNull
        public String getText() {
            if ("Configure" == null) {
                ConfigureFix.$$$reportNull$$$0(0);
            }
            return "Configure";
        }

        @NotNull
        public String getFamilyName() {
            String string = QualityToolMessageProcessor.this.getQuickFixFamilyName();
            if (string == null) {
                ConfigureFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                ConfigureFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            Configurable toolConfigurable;
            if (project == null) {
                ConfigureFix.$$$reportNull$$$0(3);
            }
            if ((toolConfigurable = QualityToolMessageProcessor.this.getToolConfigurable(project)) != null) {
                ShowSettingsUtil.getInstance().editConfigurable(project, toolConfigurable);
                DaemonCodeAnalyzer.getInstance((Project)project).restart();
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolMessageProcessor$ConfigureFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolMessageProcessor$ConfigureFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

