/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.pullPush.pullUp;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.pullPush.PhpPullPushBaseConflicts;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPullUpConflicts
extends PhpPullPushBaseConflicts {
    public PhpPullUpConflicts(PhpClass clazz, Collection<PhpMemberInfo> members) {
        super(clazz, members);
    }

    @Override
    protected String checkStaticReference(@NotNull MemberReference reference, String name, PhpClass containingClass, PhpClassMember member) {
        if (reference == null) {
            PhpPullUpConflicts.$$$reportNull$$$0(0);
        }
        if (reference.isStatic() && member instanceof Method && !((Method)member).isStatic() && containingClass != null && PhpLangUtil.equalsClassNames(name, containingClass.getNameCS())) {
            return PhpBundle.message("refactoring.pull.up.static.reference.is.not.accessible.in.the.target.class", reference.getText());
        }
        return null;
    }

    @Override
    @Nullable
    protected String checkMemberAccess(@NotNull String classReference, @NotNull PhpClassMember member) {
        if (classReference == null) {
            PhpPullUpConflicts.$$$reportNull$$$0(1);
        }
        if (member == null) {
            PhpPullUpConflicts.$$$reportNull$$$0(2);
        }
        if (PhpLangUtil.equalsClassNames("parent", classReference)) {
            return PhpBundle.message("refactoring.pull.up.may.not.be.accessible.in.the.target.class", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true));
        }
        if (!PhpLangUtil.equalsClassNames(classReference, this.myClazz.getNameCS()) || member.getModifier().isPrivate()) {
            return PhpBundle.message("refactoring.pull.up.will.not.be.accessible.in.the.target.class", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)true));
        }
        return null;
    }

    public void checkForConflicts(@NotNull PhpClass targetClass) {
        if (targetClass == null) {
            PhpPullUpConflicts.$$$reportNull$$$0(3);
        }
        List members = ContainerUtil.map((Collection)this.myMembers, info -> (PhpClassMember)info.getMember());
        for (PhpPsiElement member : members) {
            assert (member instanceof PhpClassMember);
            this.checkModifiers((PhpClassMember)member, targetClass.isInterface());
            if (member instanceof Method) {
                this.checkInternalReferences((Method)member);
                continue;
            }
            if (!(member instanceof Field) || !((Field)member).isConstant() || !targetClass.isInterface()) continue;
            Collection subclasses = PhpIndex.getInstance((Project)targetClass.getProject()).getAllSubclasses(targetClass.getFQN());
            for (PhpClass subclass : subclasses) {
                Field field = subclass.findOwnFieldByName((CharSequence)member.getName(), true);
                if (field == null || field == member) continue;
                this.myConflicts.putValue((Object)field, (Object)PhpBundle.message("refactoring.pull.up.conflict.duplicate.constant", RefactoringUIUtil.getDescription((PsiElement)field, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)subclass, (boolean)false)));
            }
        }
    }

    private void checkModifiers(@NotNull PhpClassMember member, boolean moveToInterface) {
        if (member == null) {
            PhpPullUpConflicts.$$$reportNull$$$0(4);
        }
        if (moveToInterface && member instanceof Method && ((Method)member).isStatic()) {
            String message = PhpBundle.message("refactoring.pull.up.validation.static.method.into.interface", RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false));
            this.myConflicts.putValue((Object)member, (Object)message);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/pullPush/pullUp/PhpPullUpConflicts";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStaticReference";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMemberAccess";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForConflicts";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkModifiers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

