/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.Collection;
import java.util.Set;

public final class PhpIntroduceContext {
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final PsiElement myScope;
    private final PsiElement myLogicalElement;
    private final PsiElement myPhysicalElement;
    private final boolean myReplaceSourceElement;
    private final PsiElement myInitValue;
    private final PsiElement myContext;
    private final TextRange myLogicalElementRange;
    private MultiMap<PsiElement, PsiElement> myOccurrences;
    private PsiElement[] myElementOccurrences;

    public PhpIntroduceContext(Editor editor, PsiElement physicalElement, PsiElement logicalElement, TextRange logicalElementRange, PsiElement scope, PsiElement context, PsiFile file, boolean replaceSourceElement) {
        this.myEditor = editor;
        this.myPhysicalElement = physicalElement;
        this.myLogicalElement = logicalElement;
        AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition(this.myPhysicalElement, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
        PhpPsiElement variable = assignment == null ? null : assignment.getVariable();
        this.myReplaceSourceElement = replaceSourceElement && this.myPhysicalElement instanceof Variable && variable == this.myPhysicalElement;
        this.myInitValue = this.myReplaceSourceElement ? assignment.getValue() : this.myLogicalElement;
        this.myLogicalElementRange = logicalElementRange;
        this.myFile = file;
        this.myProject = file.getProject();
        this.myScope = scope;
        this.myContext = context;
    }

    public void setOccurrences(MultiMap<PsiElement, PsiElement> elementOccurrences) {
        this.myOccurrences = elementOccurrences;
        Collection values = this.myOccurrences.values();
        this.myElementOccurrences = PsiUtilCore.toPsiElementArray((Collection)values);
    }

    public PsiElement getLogicalElement() {
        return this.myLogicalElement;
    }

    public TextRange getLogicalElementRange() {
        return this.myLogicalElementRange;
    }

    public TextRange getPhysicalElementRange() {
        return this.myPhysicalElement.getTextRange();
    }

    public PsiElement[] getOccurrences() {
        return this.myElementOccurrences;
    }

    public MultiMap<PsiElement, PsiElement> getOccurrencesWithContext() {
        return this.myOccurrences;
    }

    public int getOccurrencesCount() {
        return this.myElementOccurrences.length + 1;
    }

    public boolean isPhysical() {
        return PsiTreeUtil.isAncestor((PsiElement)this.myPhysicalElement, (PsiElement)this.myLogicalElement, (boolean)false);
    }

    public PsiElement getScope() {
        return this.myScope;
    }

    public Project getProject() {
        return this.myProject;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public PsiElement getPhysicalElement() {
        return this.myPhysicalElement;
    }

    public PsiElement getContext() {
        return this.myContext;
    }

    public String getElementDeclarationText() {
        String fqn;
        if (this.myInitValue instanceof ClassReference && (fqn = ((ClassReference)this.myLogicalElement).getFQN()) != null) {
            return "'" + fqn + "'";
        }
        return this.myInitValue == null ? "" : this.myInitValue.getText();
    }

    public boolean isInSameContext() {
        Set contexts = this.myOccurrences.keySet();
        if (contexts.size() == 1) {
            return contexts.contains(this.myContext);
        }
        return contexts.size() == 0;
    }

    public PsiElement getInitializeValue() {
        return this.myInitValue;
    }

    public boolean isToReplaceSourceElement() {
        return this.myReplaceSourceElement;
    }
}

