/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRefactoringUtil {
    private static final TokenSet CONSTANT_OF_FIELD_SET = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.CLASS_CONSTANTS, PhpElementTypes.CLASS_FIELDS});
    private static final IElementType[] NON_EXTRACTABLE_EXPRESSION_TYPES = new IElementType[]{PhpElementTypes.HASH_ARRAY_ELEMENT};

    private PhpRefactoringUtil() {
    }

    public static boolean isExpression(@NotNull PsiElement element) {
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PhpExpression)) {
            if (element instanceof Function) {
                return ((Function)element).isClosure();
            }
            return false;
        }
        if (element instanceof Variable && ((Variable)element).isDeclaration()) {
            return false;
        }
        return !(element instanceof ArrayIndex);
    }

    public static boolean canBeAssignmentValue(@NotNull PsiElement element) {
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(1);
        }
        if (!PhpRefactoringUtil.isExpression(element)) {
            return false;
        }
        if (element instanceof ClassReference) {
            return !PhpLangUtil.isSelfReference((ClassReference)element);
        }
        return true;
    }

    public static boolean isEmbedVariableAllowed(@NotNull PhpIntroduceContext introduceContext) {
        if (introduceContext == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(2);
        }
        PsiElement physicalElement = introduceContext.getPhysicalElement();
        if (!introduceContext.isPhysical() && physicalElement instanceof StringLiteralExpression && PhpElementTypes.STRING.equals(physicalElement.getNode().getElementType())) {
            return physicalElement.getText().charAt(0) == '\"';
        }
        return false;
    }

    public static boolean isScalarExpressions(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (!(expression instanceof PhpExpression)) {
            return false;
        }
        if (expression instanceof ArrayHashElement) {
            return false;
        }
        return PhpType.isScalar((PhpType)((PhpExpression)expression).getType(), (Project)expression.getProject());
    }

    public static boolean isReferenceFreeExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(4);
        }
        final boolean[] result = new boolean[]{true};
        expression.accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PhpReference && !(element instanceof ConstantReference) && !(element instanceof ClassConstantReference)) {
                    result[0] = false;
                }
                if (result[0]) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }
        });
        return result[0];
    }

    public static boolean containsLocalVariables(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(5);
        }
        final boolean[] result = new boolean[]{false};
        expression.accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                result[0] = true;
            }

            public void visitPhpFieldReference(FieldReference fieldReference) {
            }

            public void visitElement(PsiElement element) {
                if (!result[0]) {
                    element.acceptChildren((PsiElementVisitor)this);
                }
            }
        });
        return result[0];
    }

    public static String[] getPrefixesByReference(PhpReference reference) {
        if (reference instanceof MethodReference) {
            return PhpLangUtil.METHOD_PREFIXES;
        }
        if (reference instanceof FieldReference) {
            return PhpLangUtil.FIELD_PREFIXES;
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public static boolean isFunction(@NotNull PsiElement element) {
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(6);
        }
        return element instanceof Function && !(element instanceof Method);
    }

    public static boolean isConstructor(@NotNull Method method) {
        PhpClass containingClass;
        if (method == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(7);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            return false;
        }
        Method constructor = containingClass.getConstructor();
        if (constructor == null) {
            return false;
        }
        return method == constructor;
    }

    @NotNull
    public static String getParameterTypeDeclarationString(Parameter parameter) {
        PsiElement typeElement = parameter.getFirstChild();
        String firstChildText = typeElement.getText();
        firstChildText = firstChildText == "?" ? firstChildText + typeElement.getNextSibling().getText() : firstChildText;
        String string = StringUtil.isEmpty((String)firstChildText) || firstChildText.startsWith("$") || firstChildText.startsWith("&") || firstChildText.equals("...") ? "" : firstChildText.trim();
        if (string == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void initializeFieldsByParameters(@NotNull PhpClass clazz, @NotNull Collection<? extends Parameter> parameters, @NotNull String visibilityModifier) {
        if (clazz == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(9);
        }
        if (parameters == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(10);
        }
        if (visibilityModifier == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(11);
        }
        if (parameters.isEmpty()) {
            return;
        }
        Method constructor = clazz.getConstructor();
        Object groupStatement = PhpPsiUtil.getChildByCondition((PsiElement)constructor, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        if (groupStatement != null) {
            THashSet fieldNames = new THashSet();
            Collection fields = clazz.getFields();
            for (Field field : fields) {
                if (field.getModifier().isPrivate() && field.getContainingClass() != clazz) continue;
                fieldNames.add(field.getName());
            }
            ArrayList<PsiElement> typedFields = new ArrayList<PsiElement>();
            for (Parameter parameter : parameters) {
                String parameterName = parameter.getName();
                if (!fieldNames.contains(parameterName)) {
                    PhpPsiElement field = PhpPsiElementFactory.createPhpPsiFromText(clazz.getProject(), PhpElementTypes.CLASS_FIELDS, "class A { " + visibilityModifier + " $" + parameterName + ";}");
                    PsiElement newField = PhpCodeEditUtil.insertClassMember(clazz, (PsiElement)field);
                    PhpType type = parameter.getType().global(clazz.getProject());
                    if (!type.hasUnknown() && !type.isEmpty()) {
                        typedFields.add(newField);
                    }
                }
                AssignmentExpression assignmentExpression = PhpPsiElementFactory.createPhpPsiFromText(clazz.getProject(), AssignmentExpression.class, "$this->" + parameterName + " = $" + parameterName + ";");
                PsiElement semicolon = assignmentExpression.getNextSibling();
                assert (semicolon != null);
                groupStatement.addRangeBefore((PsiElement)assignmentExpression, semicolon, groupStatement.getLastChild());
            }
            for (PsiElement psiElement : typedFields) {
                if (PhpDocCommentGenerator.isTemplateNullOrEmpty(psiElement)) {
                    return;
                }
                PhpDocComment comment = PhpDocCommentGenerator.constructDocComment(clazz.getProject(), psiElement, false);
                assert (comment != null);
                psiElement.getParent().addBefore((PsiElement)comment, psiElement);
            }
        }
    }

    public static boolean isElementConstructor(@Nullable PsiElement element) {
        return element instanceof Method && ((Method)element).getMethodType(false) == Method.MethodType.CONSTRUCTOR;
    }

    public static boolean isExtractableExpression(PhpExpression expression) {
        return !PhpPsiUtil.isOfType((PsiElement)expression, NON_EXTRACTABLE_EXPRESSION_TYPES[0]);
    }

    @NotNull
    public static TextRange getVariableIdentifierRange(@NotNull TextRange range, @NotNull PsiElement element) {
        ASTNode node;
        if (range == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(12);
        }
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (element instanceof PhpNamedElement && (node = ((PhpNamedElement)element).getNameNode()) != null) {
            int offset = element.getTextRange().getStartOffset();
            TextRange nodeRange = node.getTextRange();
            assert (nodeRange.getStartOffset() >= offset);
            range = new TextRange(nodeRange.getStartOffset() - offset, nodeRange.getEndOffset() - offset);
        }
        if (element.getTextLength() > range.getStartOffset() && element.getText().charAt(range.getStartOffset()) == '$') {
            TextRange textRange = new TextRange(range.getStartOffset() + 1, range.getEndOffset());
            if (textRange == null) {
                PhpRefactoringUtil.$$$reportNull$$$0(14);
            }
            return textRange;
        }
        TextRange textRange = range;
        if (textRange == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(15);
        }
        return textRange;
    }

    @Nullable
    public static PsiReference getReferenceAtCaret(@NotNull PsiElement scope, @NotNull Editor editor) {
        int startOffset;
        TextRange textRange;
        if (scope == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(17);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiFile editorFile = PsiDocumentManager.getInstance((Project)scope.getProject()).getPsiFile(editor.getDocument());
        PsiFile file = editorFile != null ? editorFile : scope.getContainingFile();
        PsiReference reference = file.findReferenceAt(offset);
        if (reference != null || offset == 0) {
            return reference;
        }
        PsiReference leftReference = file.findReferenceAt(offset - 1);
        if (leftReference != null && (textRange = leftReference.getRangeInElement()).shiftRight(startOffset = leftReference.getElement().getTextRange().getStartOffset()).containsOffset(offset)) {
            return leftReference;
        }
        return null;
    }

    public static void adjustCaretOffsetToIdentifierRange(@NotNull Editor editor, @NotNull PsiElement element, @NotNull TextRange range) {
        int offset;
        TextRange identifierRange;
        TextRange absoluteRange;
        if (editor == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(18);
        }
        if (element == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(19);
        }
        if (range == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (!(absoluteRange = (identifierRange = PhpRefactoringUtil.getVariableIdentifierRange(range, element)).shiftRight(element.getTextRange().getStartOffset())).containsOffset(offset = editor.getCaretModel().getOffset())) {
            editor.getCaretModel().moveToOffset(absoluteRange.getStartOffset());
        }
    }

    @NotNull
    public static Statement wrapWithBraces(@NotNull Project project, @NotNull Statement statement) {
        if (project == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(21);
        }
        if (statement == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(22);
        }
        GroupStatement groupStatement = (GroupStatement)PhpPsiElementFactory.createStatement(project, "{}");
        groupStatement.addAfter((PsiElement)statement, groupStatement.getFirstChild());
        groupStatement = (GroupStatement)statement.replace((PsiElement)groupStatement);
        Statement statement2 = (Statement)groupStatement.getStatements()[0];
        if (statement2 == null) {
            PhpRefactoringUtil.$$$reportNull$$$0(23);
        }
        return statement2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpRefactoringUtil";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityModifier";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpRefactoringUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypeDeclarationString";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableIdentifierRange";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithBraces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canBeAssignmentValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEmbedVariableAllowed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isScalarExpressions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceFreeExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "containsLocalVariables";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFunction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConstructor";
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 23: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "initializeFieldsByParameters";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getVariableIdentifierRange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceAtCaret";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "adjustCaretOffsetToIdentifierRange";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithBraces";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 14: 
            case 15: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

