/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.intentions.array.OffsetPair;
import com.jetbrains.php.lang.intentions.array.OffsetTriple;
import com.jetbrains.php.lang.intentions.array.PhpConvertArraySyntaxBase;
import com.jetbrains.php.lang.intentions.array.PhpConvertToShortArraySyntaxIntention;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpArrayStylePreprocessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement psiElement;
        if (element == null) {
            PhpArrayStylePreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PhpArrayStylePreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null || !psiElement.isValid() || !psiElement.getLanguage().is((Language)PhpLanguage.INSTANCE)) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpArrayStylePreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = new PhpArrayFormatter(psiElement).process(range);
        if (textRange == null) {
            PhpArrayStylePreprocessor.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    static boolean isReadOnly(@NotNull TextRange range, @NotNull Document document, @NotNull Project project) {
        if (range == null) {
            PhpArrayStylePreprocessor.$$$reportNull$$$0(4);
        }
        if (document == null) {
            PhpArrayStylePreprocessor.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PhpArrayStylePreprocessor.$$$reportNull$$$0(6);
        }
        List readOnlyFragments = document instanceof DocumentWindow ? InjectedLanguageManager.getInstance((Project)project).getNonEditableFragments((DocumentWindow)document) : ContainerUtil.emptyList();
        return PhpArrayStylePreprocessor.intersect(readOnlyFragments, range);
    }

    private static boolean intersect(@NotNull List<TextRange> trs, @NotNull TextRange r) {
        if (trs == null) {
            PhpArrayStylePreprocessor.$$$reportNull$$$0(7);
        }
        if (r == null) {
            PhpArrayStylePreprocessor.$$$reportNull$$$0(8);
        }
        for (TextRange tr : trs) {
            if (!tr.intersects(r)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpArrayStylePreprocessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpArrayStylePreprocessor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReadOnly";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpArrayFormatter
    extends PhpElementVisitor {
        private PsiDocumentManager myDocumentManager;
        private Document myDocument;
        private PhpCodeStyleSettings myPhpCodeStyleSettings;
        private Project myProject;
        private PsiElement myElement;
        private final PhpConvertArraySyntaxBase myIntention;
        private List<OffsetPair> offsetList;
        TextRange myRange;

        private PhpArrayFormatter(@NotNull PsiElement element) {
            if (element == null) {
                PhpArrayFormatter.$$$reportNull$$$0(0);
            }
            this.myIntention = new PhpConvertToShortArraySyntaxIntention();
            try {
                this.myElement = element;
                this.myProject = element.getProject();
                PsiFile file = element.getContainingFile();
                this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
                this.myDocument = file.isPhysical() ? this.myDocumentManager.getDocument(file) : file.getViewProvider().getDocument();
                this.myPhpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
                this.offsetList = new ArrayList<OffsetPair>();
            }
            catch (PsiInvalidElementAccessException e) {
                this.myProject = null;
            }
        }

        TextRange process(@NotNull TextRange range) {
            if (range == null) {
                PhpArrayFormatter.$$$reportNull$$$0(1);
            }
            this.myRange = range;
            if (this.myProject == null) {
                return range;
            }
            if (this.myDocument == null) {
                return range;
            }
            PhpLanguageLevel preferableLanguageLevel = PhpProjectConfigurationFacade.getInstance(this.myProject).getLanguageLevel();
            if (preferableLanguageLevel.hasFeature(PhpLanguageFeature.SHORT_ARRAY_SYNTAX) && this.myPhpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE && !PhpArrayStylePreprocessor.isReadOnly(range, this.myDocument, this.myProject)) {
                this.myDocumentManager.doPostponedOperationsAndUnblockDocument(this.myDocument);
                this.myElement.accept((PsiElementVisitor)this);
                Collections.sort(this.offsetList);
                this.myIntention.makeReplaces(this.myDocument, this.offsetList);
                this.myDocumentManager.commitDocument(this.myDocument);
            }
            return range;
        }

        public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
            if (this.myRange.contains(expression.getTextRange())) {
                super.visitPhpArrayCreationExpression(expression);
                PhpLanguageLevel preferableLanguageLevel = PhpProjectConfigurationFacade.getInstance(expression.getProject()).getLanguageLevel();
                if (PhpConvertToShortArraySyntaxIntention.isAvailableOnArrayExpression(preferableLanguageLevel, expression) && this.myPhpCodeStyleSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE) {
                    int endOffset = this.myIntention.getEndOffset(expression);
                    int leftStartOffset = this.myIntention.getLeftStartOffset(expression);
                    int rightStartOffset = this.myIntention.getRightStartOffset(expression);
                    this.offsetList.add(new OffsetPair(leftStartOffset, new OffsetTriple(leftStartOffset, rightStartOffset, endOffset)));
                }
            }
        }

        public void visitElement(PsiElement element) {
            element.acceptChildren((PsiElementVisitor)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpArrayStylePreprocessor$PhpArrayFormatter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

