/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.debug.common;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpLineBreakpointType;
import com.jetbrains.php.util.pathmapper.PhpPathMapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLineBreakpointHandler<P extends PhpDebugProcess>
extends XBreakpointHandler<XLineBreakpoint<XBreakpointProperties>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.debug.common.PhpLineBreakpointHandler");
    private final P myDebugProcess;
    private final Set<XLineBreakpoint<XBreakpointProperties>> myUnregisteredBreakpoints;
    protected final BidirectionalMap<XLineBreakpoint<XBreakpointProperties>, String> myRegisteredBreakpoints;
    private final Object myLock;

    public PhpLineBreakpointHandler(@NotNull P debugProcess) {
        if (debugProcess == null) {
            PhpLineBreakpointHandler.$$$reportNull$$$0(0);
        }
        super(PhpLineBreakpointType.class);
        this.myUnregisteredBreakpoints = new HashSet<XLineBreakpoint<XBreakpointProperties>>();
        this.myRegisteredBreakpoints = new BidirectionalMap();
        this.myLock = new Object();
        this.myDebugProcess = debugProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBreakpoint(final @NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        PhpPathMapper pathMapper;
        if (breakpoint == null) {
            PhpLineBreakpointHandler.$$$reportNull$$$0(1);
        }
        if ((pathMapper = ((PhpDebugProcess)this.getDebugProcess()).getPathMapper()) == null) {
            return;
        }
        XSourcePosition sourcePosition = breakpoint.getSourcePosition();
        if (sourcePosition == null) {
            return;
        }
        String localFileUrl = sourcePosition.getFile().getUrl();
        String remoteFilePath = pathMapper.getRemoteFilePath(localFileUrl);
        if (remoteFilePath == null) {
            LOG.debug(PhpBundle.message("debug.log.cant.register.breakpoint.no.remote", localFileUrl));
            Object object = this.myLock;
            synchronized (object) {
                this.myUnregisteredBreakpoints.add(breakpoint);
            }
            String errorMessage = PhpBundle.message("debug.cannot.map.local.file", new Object[0]);
            this.getDebugProcess().getSession().setBreakpointInvalid(breakpoint, errorMessage);
        } else if (((PhpDebugProcess)this.getDebugProcess()).isConnected()) {
            XExpression condition = breakpoint.getConditionExpression();
            String expression = condition == null ? null : condition.getExpression();
            ((PhpDebugProcess)this.getDebugProcess()).registerBreakpoint(remoteFilePath, breakpoint.getLine(), expression, new PhpDebugProcess.RegisterBreakpointCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void registered(@NotNull String breakpointId) {
                    if (breakpointId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Object object = PhpLineBreakpointHandler.this.myLock;
                    synchronized (object) {
                        PhpLineBreakpointHandler.this.myUnregisteredBreakpoints.remove(breakpoint);
                        PhpLineBreakpointHandler.this.myRegisteredBreakpoints.put((Object)breakpoint, (Object)breakpointId);
                    }
                    PhpLineBreakpointHandler.this.onRegistered((XLineBreakpoint<XBreakpointProperties>)breakpoint);
                }

                @Override
                public void errorOccurred(@Nullable String errorMessage) {
                    PhpLineBreakpointHandler.this.getDebugProcess().getSession().setBreakpointInvalid(breakpoint, errorMessage);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointId", "com/jetbrains/php/debug/common/PhpLineBreakpointHandler$1", "registered"));
                }
            });
        } else {
            Object object = this.myLock;
            synchronized (object) {
                this.myUnregisteredBreakpoints.add(breakpoint);
            }
        }
    }

    protected void onRegistered(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            PhpLineBreakpointHandler.$$$reportNull$$$0(2);
        }
        this.getDebugProcess().getSession().setBreakpointVerified(breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBreakpoint(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, boolean temporary) {
        String breakpointId;
        if (breakpoint == null) {
            PhpLineBreakpointHandler.$$$reportNull$$$0(3);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myUnregisteredBreakpoints.remove(breakpoint)) {
                return;
            }
            if (!((PhpDebugProcess)this.myDebugProcess).isConnected()) {
                this.myUnregisteredBreakpoints.add(breakpoint);
                return;
            }
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            breakpointId = (String)this.myRegisteredBreakpoints.get(breakpoint);
        }
        if (breakpointId == null) {
            return;
        }
        ((PhpDebugProcess)this.getDebugProcess()).unregisterBreakpoint(breakpointId, new PhpDebugProcess.UnregisterBreakpointCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregistered() {
                Object object = PhpLineBreakpointHandler.this.myLock;
                synchronized (object) {
                    PhpLineBreakpointHandler.this.myRegisteredBreakpoints.removeValue((Object)breakpointId);
                }
            }

            @Override
            public void errorOccurred(@Nullable String errorMessage) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P getDebugProcess() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDebugProcess;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XLineBreakpoint<XBreakpointProperties> findBreakpoint(@NotNull XSourcePosition sourcePosition) {
        if (sourcePosition == null) {
            PhpLineBreakpointHandler.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            for (XLineBreakpoint breakpoint : this.myRegisteredBreakpoints.keySet()) {
                XSourcePosition breakpointSourcePosition = breakpoint.getSourcePosition();
                if (breakpointSourcePosition == null || !sourcePosition.getFile().getUrl().equalsIgnoreCase(breakpointSourcePosition.getFile().getUrl()) || sourcePosition.getLine() != breakpointSourcePosition.getLine()) continue;
                return breakpoint;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.myLock;
        synchronized (object) {
            this.myUnregisteredBreakpoints.addAll(this.myRegisteredBreakpoints.keySet());
            this.myRegisteredBreakpoints.clear();
            for (XLineBreakpoint<XBreakpointProperties> breakpoint : this.myUnregisteredBreakpoints) {
                this.myDebugProcess.getSession().updateBreakpointPresentation(breakpoint, null, null);
            }
        }
    }

    public void registerAllUnregisterBreakpoints() {
        ArrayList<XLineBreakpoint<XBreakpointProperties>> toRegister = new ArrayList<XLineBreakpoint<XBreakpointProperties>>(this.myUnregisteredBreakpoints);
        for (XLineBreakpoint<XBreakpointProperties> breakpoint : toRegister) {
            this.registerBreakpoint(breakpoint);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/debug/common/PhpLineBreakpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onRegistered";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

