/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.actions;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.actions.PhpNewBaseAction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.roots.PhpNamespaceCompositeProvider;
import com.jetbrains.php.roots.ui.PhpNamespaceComboBox;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.templates.PhpCreateFileFromTemplateDataProvider;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpBaseNewClassDialog
extends DialogWrapper
implements PhpCreateFileFromTemplateDataProvider {
    private JPanel myMainPanel;
    private EditorTextField myNameTextField;
    private PhpNamespaceComboBox myNamespaceCombobox;
    private EditorTextField myFileNameTextField;
    private PhpPsrDirectoryComboBox myDirectoryCombobox;
    protected DocumentListener myNameFieldListener;
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final PsiDirectory myDirectory;
    private final Alarm myAlarm;
    private boolean myDisposed;

    protected PhpBaseNewClassDialog(@NotNull Project project, @Nullable PsiDirectory directory) {
        if (project == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myProject = project;
        this.myDirectory = directory;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)new Disposable(){

            public void dispose() {
                PhpBaseNewClassDialog.this.myAlarm.cancelAllRequests();
                PhpBaseNewClassDialog.this.myDisposed = true;
            }
        });
    }

    protected final void init(@NotNull JPanel mainPanel, @NotNull EditorTextField nameTextField, @NotNull PhpNamespaceComboBox namespaceCombobox, @NotNull JBLabel namespaceCompletionHintLabel, @NotNull EditorTextField fileNameTextField, @NotNull PhpPsrDirectoryComboBox directoryCombobox, @NotNull JBLabel directoryCompletionHintLabel) {
        if (mainPanel == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(1);
        }
        if (nameTextField == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(2);
        }
        if (namespaceCombobox == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(3);
        }
        if (namespaceCompletionHintLabel == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(4);
        }
        if (fileNameTextField == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(5);
        }
        if (directoryCombobox == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(6);
        }
        if (directoryCompletionHintLabel == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(7);
        }
        this.myMainPanel = mainPanel;
        this.myNameTextField = nameTextField;
        this.myNamespaceCombobox = namespaceCombobox;
        this.myNamespaceCombobox.setEditable(true);
        this.myFileNameTextField = fileNameTextField;
        this.myDirectoryCombobox = directoryCombobox;
        if (this.myDirectory != null) {
            this.updateNamespacesSuggestions(PhpNamespaceCompositeProvider.INSTANCE.suggestNamespaces(this.myDirectory));
            this.myDirectoryCombobox.init(this.myDirectory.getVirtualFile(), this.getNamespace());
        } else {
            this.myDirectoryCombobox.init(this.myProject.getBaseDir(), "");
        }
        this.myDirectoryCombobox.getComboBox().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PhpBaseNewClassDialog.this.myDirectoryCombobox.getComboBox().setEditable(true);
            }
        });
        directoryCompletionHintLabel.setText(PhpBundle.message("0.completion.shortcut", "path", PhpUiUtil.getShortcutTextByActionName("CodeCompletion")));
        String shortcutText = PhpUiUtil.getShortcutTextByActionName("CodeCompletion");
        namespaceCompletionHintLabel.setText(PhpBundle.message("0.completion.shortcut", "namespace", shortcutText));
        if (this.isFileNameAutoUpdate()) {
            this.myNameFieldListener = new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    PhpBaseNewClassDialog.this.addUpdateRequest(() -> PhpBaseNewClassDialog.this.myFileNameTextField.setText(PhpBaseNewClassDialog.this.getName()), 10);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/actions/PhpBaseNewClassDialog$3", "documentChanged"));
                }
            };
            this.myNameTextField.getDocument().addDocumentListener(this.myNameFieldListener);
            this.myNamespaceCombobox.getEditorTextField().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    PhpBaseNewClassDialog.this.addUpdateRequest(() -> PhpBaseNewClassDialog.this.myDirectoryCombobox.updateDirectories(PhpBaseNewClassDialog.this.getNamespace()), 10);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/actions/PhpBaseNewClassDialog$4", "documentChanged"));
                }
            });
        }
    }

    protected void updateNamespacesSuggestions(@NotNull List<String> namespaces) {
        if (namespaces == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(8);
        }
        String mainSuggestion = namespaces.isEmpty() ? "" : namespaces.get(0);
        List<String> suggestions = namespaces.size() > 1 ? namespaces.subList(1, namespaces.size()) : null;
        this.myNamespaceCombobox.updateItems(mainSuggestion, suggestions);
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(9);
        }
        return project;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    @NotNull
    public String getFileName() {
        String string = this.getFileNameText().trim();
        if (string == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String getFileNameText() {
        return this.myFileNameTextField.getText();
    }

    @NotNull
    protected String getName() {
        String string = this.myNameTextField.getText().trim();
        if (string == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    protected final String getNamespace() {
        String string = PhpLangUtil.toName(this.myNamespaceCombobox.getSelectedNamespace().trim());
        if (string == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    protected String getExtension() {
        if ("php" == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(13);
        }
        return "php";
    }

    protected boolean isFileNameAutoUpdate() {
        return true;
    }

    @Override
    @NotNull
    public PsiDirectory getBaseDirectory() {
        PsiDirectory psiDirectory = this.getDirectory();
        if (psiDirectory == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(14);
        }
        return psiDirectory;
    }

    @Override
    @NotNull
    public final String getFilePath() {
        String filename;
        String extension;
        String chosenExtension = this.getExtension();
        String fullFileName = chosenExtension.equals(extension = PhpNameUtil.getExtension(filename = PathUtil.toSystemIndependentName((String)this.getFileName()))) ? filename : PhpNameUtil.getFullFileName(filename, chosenExtension);
        String relativePath = this.myDirectoryCombobox.getRelativePath();
        String string = StringUtil.isEmpty((String)relativePath) ? fullFileName : relativePath + "/" + StringUtil.trimEnd((String)fullFileName, (String)"/");
        if (string == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    protected PsiDirectory getDirectory() {
        PsiDirectory psiDirectory;
        VirtualFile directory = this.myDirectoryCombobox.getExistingParent();
        if (directory != null && (psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(directory)) != null) {
            return psiDirectory;
        }
        return null;
    }

    @Override
    @NotNull
    public Properties getProperties(@NotNull PsiDirectory directory) {
        if (directory == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(16);
        }
        Properties properties = new Properties();
        properties.setProperty("NAME", this.getName());
        String namespace = this.getNamespace();
        if (StringUtil.isNotEmpty((String)namespace)) {
            properties.setProperty("NAMESPACE", namespace);
        }
        Properties properties2 = properties;
        if (properties2 == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(17);
        }
        return properties2;
    }

    protected boolean postponeValidation() {
        return true;
    }

    protected ValidationInfo doValidate() {
        String name = this.getName();
        if (!PhpNameUtil.isValidClassName(name)) {
            return new ValidationInfo(PhpBundle.message("validation.class.not.valid.name", name), (JComponent)this.myNameTextField);
        }
        String namespace = this.getNamespace();
        if (StringUtil.isNotEmpty((String)namespace) && !PhpNameUtil.isValidNamespaceFullName(namespace)) {
            return new ValidationInfo(PhpBundle.message("validation.namespace.not.valid.name", namespace), (JComponent)((Object)this.myNamespaceCombobox));
        }
        PsiDirectory directory = this.getDirectory();
        if (directory == null) {
            return new ValidationInfo(PhpBundle.message("validation.value.is.not.specified.or.invalid", "directory"));
        }
        String errorMessage = PhpNewBaseAction.isValidFilePath(this.getFilePath(), directory);
        if (errorMessage != null) {
            return new ValidationInfo(errorMessage, (JComponent)this.myFileNameTextField);
        }
        return null;
    }

    protected void addUpdateRequest(@NotNull Runnable runnable) {
        if (runnable == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(18);
        }
        this.addUpdateRequest(runnable, 100);
    }

    protected void addUpdateRequest(@NotNull Runnable runnable, int delay) {
        if (runnable == null) {
            PhpBaseNewClassDialog.$$$reportNull$$$0(19);
        }
        SwingUtilities.invokeLater(() -> {
            if (runnable == null) {
                PhpBaseNewClassDialog.$$$reportNull$$$0(20);
            }
            if (this.myDisposed) {
                return;
            }
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(runnable, delay);
        });
    }

    protected void dispose() {
        if (this.isFileNameAutoUpdate()) {
            this.myNameTextField.getDocument().removeDocumentListener(this.myNameFieldListener);
        }
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameTextField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceCombobox";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceCompletionHintLabel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameTextField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryCombobox";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryCompletionHintLabel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaces";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/actions/PhpBaseNewClassDialog";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/actions/PhpBaseNewClassDialog";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateNamespacesSuggestions";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateRequest";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addUpdateRequest$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

