/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.FileAnalyzer;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.web.Prefix;
import org.opensolaris.opengrok.web.SearchHelper;
import org.opensolaris.opengrok.web.Util;

public final class Results {
    private Results() {
    }

    private static Map<String, ArrayList<Document>> createMap(IndexSearcher searcher, ScoreDoc[] hits, int startIdx, int stopIdx) throws CorruptIndexException, IOException {
        LinkedHashMap<String, ArrayList<Document>> dirHash = new LinkedHashMap<String, ArrayList<Document>>();
        for (int i = startIdx; i < stopIdx; ++i) {
            int docId = hits[i].doc;
            Document doc = searcher.doc(docId);
            String rpath = doc.get("path");
            String parent = rpath.substring(0, rpath.lastIndexOf(47));
            ArrayList<Object> dirDocs = dirHash.get(parent);
            if (dirDocs == null) {
                dirDocs = new ArrayList();
                dirHash.put(parent, dirDocs);
            }
            dirDocs.add(doc);
        }
        return dirHash;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getTags(File basedir, String path, boolean compressed) {
        char[] content = new char[8192];
        try (HTMLStripCharFilter r = new HTMLStripCharFilter(Results.getXrefReader(basedir, path, compressed));){
            int len = r.read(content);
            String string = new String(content, 0, len);
            return string;
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "An error reading tags from " + basedir + path + (compressed ? ".gz" : ""), e);
            return "";
        }
    }

    private static Reader getXrefReader(File basedir, String path, boolean compressed) throws IOException {
        if (compressed) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(new File(basedir, path + ".gz")))));
        }
        return new BufferedReader(new FileReader(new File(basedir, path)));
    }

    public static void prettyPrint(Writer out, SearchHelper sh, int start, int end) throws HistoryException, IOException, ClassNotFoundException {
        String ctxE = Util.URIEncodePath(sh.contextPath);
        String xrefPrefix = sh.contextPath + (Object)((Object)Prefix.XREF_P);
        String morePrefix = sh.contextPath + (Object)((Object)Prefix.MORE_P);
        String xrefPrefixE = ctxE + (Object)((Object)Prefix.XREF_P);
        File xrefDataDir = new File(sh.dataRoot, Prefix.XREF_P.toString());
        for (Map.Entry<String, ArrayList<Document>> entry : Results.createMap(sh.searcher, sh.hits, start, end).entrySet()) {
            String parent = entry.getKey();
            out.write("<tr class=\"dir\"><td colspan=\"3\"><a href=\"");
            out.write(xrefPrefixE);
            out.write(Util.URIEncodePath(parent));
            out.write("/\">");
            out.write(parent);
            out.write("/</a>");
            if (sh.desc != null) {
                out.write(" - <i>");
                out.write(sh.desc.get(parent));
                out.write("</i>");
            }
            out.write("</td></tr>");
            for (Document doc : entry.getValue()) {
                String rpath = doc.get("path");
                String rpathE = Util.URIEncodePath(rpath);
                out.write("<tr>");
                Util.writeHAD(out, sh.contextPath, rpathE, false);
                out.write("<td class=\"f\"><a href=\"");
                out.write(xrefPrefixE);
                out.write(rpathE);
                out.write("\">");
                out.write(rpath.substring(rpath.lastIndexOf(47) + 1));
                out.write("</a></td><td><tt class=\"con\">");
                if (sh.sourceContext != null) {
                    FileAnalyzer.Genre genre = FileAnalyzer.Genre.get(doc.get("t"));
                    Definitions tags = null;
                    IndexableField tagsField = doc.getField("tags");
                    if (tagsField != null) {
                        tags = Definitions.deserialize(tagsField.binaryValue().bytes);
                    }
                    if (FileAnalyzer.Genre.XREFABLE == genre && sh.summerizer != null) {
                        String xtags = Results.getTags(xrefDataDir, rpath, sh.compressed);
                        out.write(sh.summerizer.getSummary(xtags).toString());
                    } else if (FileAnalyzer.Genre.HTML == genre && sh.summerizer != null) {
                        String htags = Results.getTags(sh.sourceRoot, rpath, false);
                        out.write(sh.summerizer.getSummary(htags).toString());
                    } else {
                        FileReader r = genre == FileAnalyzer.Genre.PLAIN ? new FileReader(new File(sh.sourceRoot, rpath)) : null;
                        sh.sourceContext.getContext(r, out, xrefPrefix, morePrefix, rpath, tags, true, sh.builder.isDefSearch(), null);
                    }
                }
                if (sh.historyContext != null) {
                    sh.historyContext.getContext(new File(sh.sourceRoot, rpath), rpath, out, sh.contextPath);
                }
                out.write("</tt></td></tr>\n");
            }
        }
    }
}

