/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file LinkSetDbHistory_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_LINKSETDBHISTORY_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_LINKSETDBHISTORY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CLinkSetDbHistory_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CLinkSetDbHistory_Base(void);
    // destructor
    virtual ~CLinkSetDbHistory_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_QI : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_QI(void);
        // destructor
        ~C_QI(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_QueryKey,
            e_Info          ///< .+ 
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Info+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string TQueryKey;
        typedef NCBI_NS_STD::string TInfo;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string TQueryKey
        bool IsQueryKey(void) const;
        const TQueryKey& GetQueryKey(void) const;
        TQueryKey& SetQueryKey(void);
        void SetQueryKey(const TQueryKey& value);
    
        // typedef NCBI_NS_STD::string TInfo
        bool IsInfo(void) const;
        const TInfo& GetInfo(void) const;
        TInfo& SetInfo(void);
        void SetInfo(const TInfo& value);
    
    
    private:
        // copy constructor and assignment operator
        C_QI(const C_QI& );
        C_QI& operator=(const C_QI& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef NCBI_NS_STD::string TDbTo;
    typedef NCBI_NS_STD::string TLinkName;
    typedef C_QI TQI;
    typedef NCBI_NS_STD::string TERROR;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_DbTo,
        e_LinkName,
        e_QI,
        e_ERROR
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// \S+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDbTo
    ///  Check whether the DbTo data member has been assigned a value.
    bool IsSetDbTo(void) const;
    /// Check whether it is safe or not to call GetDbTo method.
    bool CanGetDbTo(void) const;
    void ResetDbTo(void);
    const TDbTo& GetDbTo(void) const;
    void SetDbTo(const TDbTo& value);
    void SetDbTo(TDbTo&& value);
    TDbTo& SetDbTo(void);

    /// \S+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TLinkName
    ///  Check whether the LinkName data member has been assigned a value.
    bool IsSetLinkName(void) const;
    /// Check whether it is safe or not to call GetLinkName method.
    bool CanGetLinkName(void) const;
    void ResetLinkName(void);
    const TLinkName& GetLinkName(void) const;
    void SetLinkName(const TLinkName& value);
    void SetLinkName(TLinkName&& value);
    TLinkName& SetLinkName(void);

    /// mandatory
    /// typedef C_QI TQI
    ///  Check whether the QI data member has been assigned a value.
    bool IsSetQI(void) const;
    /// Check whether it is safe or not to call GetQI method.
    bool CanGetQI(void) const;
    void ResetQI(void);
    const TQI& GetQI(void) const;
    void SetQI(TQI& value);
    TQI& SetQI(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::string TERROR
    ///  Check whether the ERROR data member has been assigned a value.
    bool IsSetERROR(void) const;
    /// Check whether it is safe or not to call GetERROR method.
    bool CanGetERROR(void) const;
    void ResetERROR(void);
    const TERROR& GetERROR(void) const;
    void SetERROR(const TERROR& value);
    void SetERROR(TERROR&& value);
    TERROR& SetERROR(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CLinkSetDbHistory_Base(const CLinkSetDbHistory_Base&);
    CLinkSetDbHistory_Base& operator=(const CLinkSetDbHistory_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_DbTo;
    NCBI_NS_STD::string m_LinkName;
    NCBI_NS_NCBI::CRef< TQI > m_QI;
    NCBI_NS_STD::string m_ERROR;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CLinkSetDbHistory_Base::C_QI::E_Choice CLinkSetDbHistory_Base::C_QI::Which(void) const
{
    return m_choice;
}

inline
void CLinkSetDbHistory_Base::C_QI::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CLinkSetDbHistory_Base::C_QI::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CLinkSetDbHistory_Base::C_QI::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CLinkSetDbHistory_Base::C_QI::IsQueryKey(void) const
{
    return m_choice == e_QueryKey;
}

inline
const CLinkSetDbHistory_Base::C_QI::TQueryKey& CLinkSetDbHistory_Base::C_QI::GetQueryKey(void) const
{
    CheckSelected(e_QueryKey);
    return *m_string;
}

inline
CLinkSetDbHistory_Base::C_QI::TQueryKey& CLinkSetDbHistory_Base::C_QI::SetQueryKey(void)
{
    Select(e_QueryKey, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CLinkSetDbHistory_Base::C_QI::IsInfo(void) const
{
    return m_choice == e_Info;
}

inline
const CLinkSetDbHistory_Base::C_QI::TInfo& CLinkSetDbHistory_Base::C_QI::GetInfo(void) const
{
    CheckSelected(e_Info);
    return *m_string;
}

inline
CLinkSetDbHistory_Base::C_QI::TInfo& CLinkSetDbHistory_Base::C_QI::SetInfo(void)
{
    Select(e_Info, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CLinkSetDbHistory_Base::IsSetDbTo(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLinkSetDbHistory_Base::CanGetDbTo(void) const
{
    return IsSetDbTo();
}

inline
const CLinkSetDbHistory_Base::TDbTo& CLinkSetDbHistory_Base::GetDbTo(void) const
{
    if (!CanGetDbTo()) {
        ThrowUnassigned(0);
    }
    return m_DbTo;
}

inline
void CLinkSetDbHistory_Base::SetDbTo(const CLinkSetDbHistory_Base::TDbTo& value)
{
    m_DbTo = value;
    m_set_State[0] |= 0x3;
}

inline
void CLinkSetDbHistory_Base::SetDbTo(CLinkSetDbHistory_Base::TDbTo&& value)
{
    m_DbTo = std::forward<CLinkSetDbHistory_Base::TDbTo>(value);
    m_set_State[0] |= 0x3;
}

inline
CLinkSetDbHistory_Base::TDbTo& CLinkSetDbHistory_Base::SetDbTo(void)
{
#ifdef _DEBUG
    if (!IsSetDbTo()) {
        m_DbTo = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_DbTo;
}

inline
bool CLinkSetDbHistory_Base::IsSetLinkName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CLinkSetDbHistory_Base::CanGetLinkName(void) const
{
    return IsSetLinkName();
}

inline
const CLinkSetDbHistory_Base::TLinkName& CLinkSetDbHistory_Base::GetLinkName(void) const
{
    if (!CanGetLinkName()) {
        ThrowUnassigned(1);
    }
    return m_LinkName;
}

inline
void CLinkSetDbHistory_Base::SetLinkName(const CLinkSetDbHistory_Base::TLinkName& value)
{
    m_LinkName = value;
    m_set_State[0] |= 0xc;
}

inline
void CLinkSetDbHistory_Base::SetLinkName(CLinkSetDbHistory_Base::TLinkName&& value)
{
    m_LinkName = std::forward<CLinkSetDbHistory_Base::TLinkName>(value);
    m_set_State[0] |= 0xc;
}

inline
CLinkSetDbHistory_Base::TLinkName& CLinkSetDbHistory_Base::SetLinkName(void)
{
#ifdef _DEBUG
    if (!IsSetLinkName()) {
        m_LinkName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_LinkName;
}

inline
bool CLinkSetDbHistory_Base::IsSetQI(void) const
{
    return m_QI.NotEmpty();
}

inline
bool CLinkSetDbHistory_Base::CanGetQI(void) const
{
    return true;
}

inline
const CLinkSetDbHistory_Base::TQI& CLinkSetDbHistory_Base::GetQI(void) const
{
    if ( !m_QI ) {
        const_cast<CLinkSetDbHistory_Base*>(this)->ResetQI();
    }
    return (*m_QI);
}

inline
CLinkSetDbHistory_Base::TQI& CLinkSetDbHistory_Base::SetQI(void)
{
    if ( !m_QI ) {
        ResetQI();
    }
    return (*m_QI);
}

inline
bool CLinkSetDbHistory_Base::IsSetERROR(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CLinkSetDbHistory_Base::CanGetERROR(void) const
{
    return IsSetERROR();
}

inline
const CLinkSetDbHistory_Base::TERROR& CLinkSetDbHistory_Base::GetERROR(void) const
{
    if (!CanGetERROR()) {
        ThrowUnassigned(3);
    }
    return m_ERROR;
}

inline
void CLinkSetDbHistory_Base::SetERROR(const CLinkSetDbHistory_Base::TERROR& value)
{
    m_ERROR = value;
    m_set_State[0] |= 0xc0;
}

inline
void CLinkSetDbHistory_Base::SetERROR(CLinkSetDbHistory_Base::TERROR&& value)
{
    m_ERROR = std::forward<CLinkSetDbHistory_Base::TERROR>(value);
    m_set_State[0] |= 0xc0;
}

inline
CLinkSetDbHistory_Base::TERROR& CLinkSetDbHistory_Base::SetERROR(void)
{
#ifdef _DEBUG
    if (!IsSetERROR()) {
        m_ERROR = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_ERROR;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_LINKSETDBHISTORY_BASE_HPP
