/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PublicationType.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// New methods or data members can be added to it if needed.
/// See also: PublicationType_.hpp


#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PUBLICATIONTYPE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PUBLICATIONTYPE_HPP


// generated includes
#include <objtools/eutils/efetch/PublicationType_.hpp>

// generated classes

BEGIN_eutils_SCOPE // namespace eutils::

/////////////////////////////////////////////////////////////////////////////
class CPublicationType : public CPublicationType_Base
{
    typedef CPublicationType_Base Tparent;
public:
    // constructor
    CPublicationType(void);
    CPublicationType(const std::string& value);
    // destructor
    ~CPublicationType(void);

    // typedef std::string TPublicationType;

    /// Conversion operator to 'TPublicationType' type.
    operator const TPublicationType&(void) const;
    /// Assignment operator.
    CPublicationType& operator=(const TPublicationType& value);

private:
    // Prohibit copy constructor and assignment operator
    CPublicationType(const CPublicationType& value);
    CPublicationType& operator=(const CPublicationType& value);

};

/////////////////// CPublicationType inline methods

// constructor
inline
CPublicationType::CPublicationType(void)
{
}

inline
CPublicationType::CPublicationType(const std::string& value)
{
    SetPublicationType(value);
}

inline
CPublicationType::operator const CPublicationType::TPublicationType&(void) const
{
    return GetPublicationType();
}

inline
CPublicationType& CPublicationType::operator=(const TPublicationType& value)
{
    SetPublicationType(value);
    return *this;
}


/////////////////// end of CPublicationType inline methods


END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PUBLICATIONTYPE_HPP
/* Original file checksum: lines: 109, chars: 3150, CRC32: 6d12c89 */
