/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mtd_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MTD_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MTD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objtools/eutils/efetch/ImpliedMrow.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMtd_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMtd_Base(void);
    // destructor
    virtual ~CMtd_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_rowalign {
            eAttlist_rowalign_top      = 1,
            eAttlist_rowalign_bottom   = 2,
            eAttlist_rowalign_center   = 3,
            eAttlist_rowalign_baseline = 4,
            eAttlist_rowalign_axis     = 5
        };
        
        /// Access to EAttlist_rowalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_rowalign)(void);
        
        enum EAttlist_columnalign {
            eAttlist_columnalign_left   = 1,
            eAttlist_columnalign_center = 2,
            eAttlist_columnalign_right  = 3
        };
        
        /// Access to EAttlist_columnalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_columnalign)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TRowspan;
        typedef NCBI_NS_STD::string TColumnspan;
        typedef EAttlist_rowalign TRowalign;
        typedef EAttlist_columnalign TColumnalign;
        typedef NCBI_NS_STD::string TGroupalign;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_rowspan,
            e_columnspan,
            e_rowalign,
            e_columnalign,
            e_groupalign
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 13> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRowspan
        ///  Check whether the Rowspan data member has been assigned a value.
        bool IsSetRowspan(void) const;
        /// Check whether it is safe or not to call GetRowspan method.
        bool CanGetRowspan(void) const;
        void ResetRowspan(void);
        const TRowspan& GetRowspan(void) const;
        void SetRowspan(const TRowspan& value);
        void SetRowspan(TRowspan&& value);
        TRowspan& SetRowspan(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnspan
        ///  Check whether the Columnspan data member has been assigned a value.
        bool IsSetColumnspan(void) const;
        /// Check whether it is safe or not to call GetColumnspan method.
        bool CanGetColumnspan(void) const;
        void ResetColumnspan(void);
        const TColumnspan& GetColumnspan(void) const;
        void SetColumnspan(const TColumnspan& value);
        void SetColumnspan(TColumnspan&& value);
        TColumnspan& SetColumnspan(void);
    
        /// optional
        /// typedef EAttlist_rowalign TRowalign
        ///  Check whether the Rowalign data member has been assigned a value.
        bool IsSetRowalign(void) const;
        /// Check whether it is safe or not to call GetRowalign method.
        bool CanGetRowalign(void) const;
        void ResetRowalign(void);
        TRowalign GetRowalign(void) const;
        void SetRowalign(TRowalign value);
        TRowalign& SetRowalign(void);
    
        /// optional
        /// typedef EAttlist_columnalign TColumnalign
        ///  Check whether the Columnalign data member has been assigned a value.
        bool IsSetColumnalign(void) const;
        /// Check whether it is safe or not to call GetColumnalign method.
        bool CanGetColumnalign(void) const;
        void ResetColumnalign(void);
        TColumnalign GetColumnalign(void) const;
        void SetColumnalign(TColumnalign value);
        TColumnalign& SetColumnalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TGroupalign
        ///  Check whether the Groupalign data member has been assigned a value.
        bool IsSetGroupalign(void) const;
        /// Check whether it is safe or not to call GetGroupalign method.
        bool CanGetGroupalign(void) const;
        void ResetGroupalign(void);
        const TGroupalign& GetGroupalign(void) const;
        void SetGroupalign(const TGroupalign& value);
        void SetGroupalign(TGroupalign&& value);
        TGroupalign& SetGroupalign(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Rowspan;
        NCBI_NS_STD::string m_Columnspan;
        EAttlist_rowalign m_Rowalign;
        EAttlist_columnalign m_Columnalign;
        NCBI_NS_STD::string m_Groupalign;
    };
    typedef CImpliedMrow C_Mtd;
    // types
    typedef C_Attlist TAttlist;
    typedef C_Mtd TMtd;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_mtd
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_Mtd TMtd
    ///  Check whether the Mtd data member has been assigned a value.
    bool IsSetMtd(void) const;
    /// Check whether it is safe or not to call GetMtd method.
    bool CanGetMtd(void) const;
    void ResetMtd(void);
    const TMtd& GetMtd(void) const;
    void SetMtd(TMtd& value);
    TMtd& SetMtd(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMtd_Base(const CMtd_Base&);
    CMtd_Base& operator=(const CMtd_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TMtd > m_Mtd;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMtd_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMtd_Base::C_Attlist::TId& CMtd_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMtd_Base::C_Attlist::SetId(const CMtd_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMtd_Base::C_Attlist::SetId(CMtd_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMtd_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMtd_Base::C_Attlist::TId& CMtd_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMtd_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMtd_Base::C_Attlist::TXref& CMtd_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMtd_Base::C_Attlist::SetXref(const CMtd_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMtd_Base::C_Attlist::SetXref(CMtd_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMtd_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMtd_Base::C_Attlist::TXref& CMtd_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMtd_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMtd_Base::C_Attlist::TClass& CMtd_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMtd_Base::C_Attlist::SetClass(const CMtd_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMtd_Base::C_Attlist::SetClass(CMtd_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMtd_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMtd_Base::C_Attlist::TClass& CMtd_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMtd_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMtd_Base::C_Attlist::TStyle& CMtd_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMtd_Base::C_Attlist::SetStyle(const CMtd_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMtd_Base::C_Attlist::SetStyle(CMtd_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMtd_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMtd_Base::C_Attlist::TStyle& CMtd_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMtd_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMtd_Base::C_Attlist::THref& CMtd_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMtd_Base::C_Attlist::SetHref(const CMtd_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMtd_Base::C_Attlist::SetHref(CMtd_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMtd_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMtd_Base::C_Attlist::THref& CMtd_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMtd_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMtd_Base::C_Attlist::TMathcolor& CMtd_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMtd_Base::C_Attlist::SetMathcolor(const CMtd_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMtd_Base::C_Attlist::SetMathcolor(CMtd_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMtd_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMtd_Base::C_Attlist::TMathcolor& CMtd_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMtd_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMtd_Base::C_Attlist::TMathbackground& CMtd_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMtd_Base::C_Attlist::SetMathbackground(const CMtd_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMtd_Base::C_Attlist::SetMathbackground(CMtd_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMtd_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMtd_Base::C_Attlist::TMathbackground& CMtd_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMtd_Base::C_Attlist::IsSetRowspan(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetRowspan(void) const
{
    return IsSetRowspan();
}

inline
const CMtd_Base::C_Attlist::TRowspan& CMtd_Base::C_Attlist::GetRowspan(void) const
{
    if (!CanGetRowspan()) {
        ThrowUnassigned(7);
    }
    return m_Rowspan;
}

inline
void CMtd_Base::C_Attlist::SetRowspan(const CMtd_Base::C_Attlist::TRowspan& value)
{
    m_Rowspan = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMtd_Base::C_Attlist::SetRowspan(CMtd_Base::C_Attlist::TRowspan&& value)
{
    m_Rowspan = std::forward<CMtd_Base::C_Attlist::TRowspan>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMtd_Base::C_Attlist::TRowspan& CMtd_Base::C_Attlist::SetRowspan(void)
{
#ifdef _DEBUG
    if (!IsSetRowspan()) {
        m_Rowspan = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Rowspan;
}

inline
bool CMtd_Base::C_Attlist::IsSetColumnspan(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetColumnspan(void) const
{
    return IsSetColumnspan();
}

inline
const CMtd_Base::C_Attlist::TColumnspan& CMtd_Base::C_Attlist::GetColumnspan(void) const
{
    if (!CanGetColumnspan()) {
        ThrowUnassigned(8);
    }
    return m_Columnspan;
}

inline
void CMtd_Base::C_Attlist::SetColumnspan(const CMtd_Base::C_Attlist::TColumnspan& value)
{
    m_Columnspan = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMtd_Base::C_Attlist::SetColumnspan(CMtd_Base::C_Attlist::TColumnspan&& value)
{
    m_Columnspan = std::forward<CMtd_Base::C_Attlist::TColumnspan>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMtd_Base::C_Attlist::TColumnspan& CMtd_Base::C_Attlist::SetColumnspan(void)
{
#ifdef _DEBUG
    if (!IsSetColumnspan()) {
        m_Columnspan = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Columnspan;
}

inline
bool CMtd_Base::C_Attlist::IsSetRowalign(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetRowalign(void) const
{
    return IsSetRowalign();
}

inline
void CMtd_Base::C_Attlist::ResetRowalign(void)
{
    m_Rowalign = (EAttlist_rowalign)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CMtd_Base::C_Attlist::TRowalign CMtd_Base::C_Attlist::GetRowalign(void) const
{
    if (!CanGetRowalign()) {
        ThrowUnassigned(9);
    }
    return m_Rowalign;
}

inline
void CMtd_Base::C_Attlist::SetRowalign(CMtd_Base::C_Attlist::TRowalign value)
{
    m_Rowalign = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMtd_Base::C_Attlist::TRowalign& CMtd_Base::C_Attlist::SetRowalign(void)
{
#ifdef _DEBUG
    if (!IsSetRowalign()) {
        memset(&m_Rowalign,UnassignedByte(),sizeof(m_Rowalign));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Rowalign;
}

inline
bool CMtd_Base::C_Attlist::IsSetColumnalign(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetColumnalign(void) const
{
    return IsSetColumnalign();
}

inline
void CMtd_Base::C_Attlist::ResetColumnalign(void)
{
    m_Columnalign = (EAttlist_columnalign)(0);
    m_set_State[0] &= ~0x300000;
}

inline
CMtd_Base::C_Attlist::TColumnalign CMtd_Base::C_Attlist::GetColumnalign(void) const
{
    if (!CanGetColumnalign()) {
        ThrowUnassigned(10);
    }
    return m_Columnalign;
}

inline
void CMtd_Base::C_Attlist::SetColumnalign(CMtd_Base::C_Attlist::TColumnalign value)
{
    m_Columnalign = value;
    m_set_State[0] |= 0x300000;
}

inline
CMtd_Base::C_Attlist::TColumnalign& CMtd_Base::C_Attlist::SetColumnalign(void)
{
#ifdef _DEBUG
    if (!IsSetColumnalign()) {
        memset(&m_Columnalign,UnassignedByte(),sizeof(m_Columnalign));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Columnalign;
}

inline
bool CMtd_Base::C_Attlist::IsSetGroupalign(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMtd_Base::C_Attlist::CanGetGroupalign(void) const
{
    return IsSetGroupalign();
}

inline
const CMtd_Base::C_Attlist::TGroupalign& CMtd_Base::C_Attlist::GetGroupalign(void) const
{
    if (!CanGetGroupalign()) {
        ThrowUnassigned(11);
    }
    return m_Groupalign;
}

inline
void CMtd_Base::C_Attlist::SetGroupalign(const CMtd_Base::C_Attlist::TGroupalign& value)
{
    m_Groupalign = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CMtd_Base::C_Attlist::SetGroupalign(CMtd_Base::C_Attlist::TGroupalign&& value)
{
    m_Groupalign = std::forward<CMtd_Base::C_Attlist::TGroupalign>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CMtd_Base::C_Attlist::TGroupalign& CMtd_Base::C_Attlist::SetGroupalign(void)
{
#ifdef _DEBUG
    if (!IsSetGroupalign()) {
        m_Groupalign = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Groupalign;
}

inline
bool CMtd_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMtd_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMtd_Base::TAttlist& CMtd_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMtd_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMtd_Base::TAttlist& CMtd_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMtd_Base::IsSetMtd(void) const
{
    return m_Mtd.NotEmpty();
}

inline
bool CMtd_Base::CanGetMtd(void) const
{
    return true;
}

inline
const CMtd_Base::TMtd& CMtd_Base::GetMtd(void) const
{
    if ( !m_Mtd ) {
        const_cast<CMtd_Base*>(this)->ResetMtd();
    }
    return (*m_Mtd);
}

inline
CMtd_Base::TMtd& CMtd_Base::SetMtd(void)
{
    if ( !m_Mtd ) {
        ResetMtd();
    }
    return (*m_Mtd);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MTD_BASE_HPP
